/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.timer;

import org.cache2k.impl.timer.ArrayHeapTimerQueue;
import org.cache2k.impl.timer.TimerListener;
import org.cache2k.impl.timer.TimerPayloadListener;
import org.cache2k.impl.timer.TimerService;

public class GlobalTimerService
extends TimerService {
    private static TimerService queue;
    int racyRoundRobinCounter = 0;
    ArrayHeapTimerQueue[] timerQueues;

    public static TimerService getInstance() {
        if (queue == null) {
            queue = new GlobalTimerService(null, Runtime.getRuntime().availableProcessors() * 2);
        }
        return queue;
    }

    public GlobalTimerService(String _managerName, int _threadCount) {
        String _separator = "-";
        if (_managerName != null) {
            _separator = ":" + _managerName + ":";
        }
        this.timerQueues = new ArrayHeapTimerQueue[_threadCount];
        for (int i = 0; i < this.timerQueues.length; ++i) {
            this.timerQueues[i] = new ArrayHeapTimerQueue("cache2k" + _separator + "timer-" + i);
        }
    }

    @Override
    public <T> TimerService.CancelHandle add(TimerPayloadListener<T> l, T _payload, long t) {
        this.racyRoundRobinCounter = (this.racyRoundRobinCounter + 1) % this.timerQueues.length;
        return this.timerQueues[this.racyRoundRobinCounter].add((TimerPayloadListener)l, (Object)_payload, t);
    }

    @Override
    public TimerService.CancelHandle add(TimerListener l, long t) {
        this.racyRoundRobinCounter = (this.racyRoundRobinCounter + 1) % this.timerQueues.length;
        return this.timerQueues[this.racyRoundRobinCounter].add(l, t);
    }

    @Override
    public int getQueueSize() {
        int v = 0;
        for (int i = 0; i < this.timerQueues.length; ++i) {
            v += this.timerQueues[i].getQueueSize();
        }
        return v;
    }

    @Override
    public long getEventsDelivered() {
        long v = 0L;
        for (int i = 0; i < this.timerQueues.length; ++i) {
            v += this.timerQueues[i].getEventsDelivered();
        }
        return v;
    }

    @Override
    public long getEventsScheduled() {
        long v = 0L;
        for (int i = 0; i < this.timerQueues.length; ++i) {
            v += this.timerQueues[i].getEventsScheduled();
        }
        return v;
    }

    @Override
    public long getPurgeCount() {
        long v = 0L;
        for (int i = 0; i < this.timerQueues.length; ++i) {
            v += this.timerQueues[i].getPurgeCount();
        }
        return v;
    }

    @Override
    public long getCancelCount() {
        long v = 0L;
        for (int i = 0; i < this.timerQueues.length; ++i) {
            v += this.timerQueues[i].getCancelCount();
        }
        return v;
    }

    @Override
    public long getFireExceptionCount() {
        long v = 0L;
        for (int i = 0; i < this.timerQueues.length; ++i) {
            v += this.timerQueues[i].getFireExceptionCount();
        }
        return v;
    }
}

