/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools.reposail;

import info.aduna.iteration.CloseableIteration;
import net.fortytwo.sesametools.SailConnectionTripleSource;
import net.fortytwo.sesametools.reposail.RepositoryNamespaceIteration;
import net.fortytwo.sesametools.reposail.RepositoryResourceIteration;
import net.fortytwo.sesametools.reposail.RepositoryStatementIteration;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.helpers.SailConnectionBase;

public class RepositorySailConnection
extends SailConnectionBase {
    private RepositoryConnection repoConnection;
    private final boolean inferenceDisabled;
    private final ValueFactory valueFactory;

    public RepositorySailConnection(SailBase sail, RepositoryConnection repoConnection, boolean inferenceDisabled, ValueFactory valueFactory) {
        super(sail);
        this.repoConnection = repoConnection;
        this.inferenceDisabled = inferenceDisabled;
        this.valueFactory = valueFactory;
    }

    protected void addStatementInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        try {
            this.repoConnection.add(subj, pred, obj, contexts);
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void clearInternal(Resource ... contexts) throws SailException {
        try {
            this.repoConnection.clear(contexts);
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void clearNamespacesInternal() throws SailException {
        try {
            this.repoConnection.clearNamespaces();
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void closeInternal() throws SailException {
        try {
            this.repoConnection.close();
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void commitInternal() throws SailException {
        try {
            this.repoConnection.commit();
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr query, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        try {
            SailConnectionTripleSource tripleSource = new SailConnectionTripleSource((SailConnection)this, this.valueFactory, includeInferred);
            EvaluationStrategyImpl strategy = new EvaluationStrategyImpl((TripleSource)tripleSource, dataset);
            return strategy.evaluate(query, bindings);
        }
        catch (QueryEvaluationException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        try {
            return new RepositoryResourceIteration((CloseableIteration<? extends Resource, RepositoryException>)this.repoConnection.getContextIDs());
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected String getNamespaceInternal(String prefix) throws SailException {
        try {
            return this.repoConnection.getNamespace(prefix);
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        try {
            return new RepositoryNamespaceIteration((CloseableIteration<? extends Namespace, RepositoryException>)this.repoConnection.getNamespaces());
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        try {
            return new RepositoryStatementIteration((CloseableIteration<? extends Statement, RepositoryException>)this.repoConnection.getStatements(subj, pred, obj, includeInferred && !this.inferenceDisabled, contexts));
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void removeNamespaceInternal(String prefix) throws SailException {
        try {
            this.repoConnection.removeNamespace(prefix);
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void removeStatementsInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        try {
            this.repoConnection.remove(subj, pred, obj, contexts);
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void rollbackInternal() throws SailException {
        try {
            this.repoConnection.rollback();
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void setNamespaceInternal(String prefix, String name) throws SailException {
        try {
            this.repoConnection.setNamespace(prefix, name);
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected long sizeInternal(Resource ... contexts) throws SailException {
        try {
            return this.repoConnection.size(new Resource[0]);
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void startTransactionInternal() throws SailException {
        try {
            this.repoConnection.begin();
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }
}

