/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types;

import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.graphdb.database.management.ModifierType;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.types.CompositeIndexType;
import com.thinkaurelius.titan.graphdb.types.IndexField;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.SchemaSource;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.tinkerpop.blueprints.Direction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TypeUtil {
    public static boolean hasSimpleInternalVertexKeyIndex(TitanRelation rel) {
        if (!(rel instanceof TitanProperty)) {
            return false;
        }
        return TypeUtil.hasSimpleInternalVertexKeyIndex((TitanProperty)rel);
    }

    public static boolean hasSimpleInternalVertexKeyIndex(TitanProperty prop) {
        return TypeUtil.hasSimpleInternalVertexKeyIndex(prop.getPropertyKey());
    }

    public static boolean hasSimpleInternalVertexKeyIndex(PropertyKey key) {
        InternalRelationType type = (InternalRelationType)((Object)key);
        for (IndexType index : type.getKeyIndexes()) {
            if (index.getElement() != ElementCategory.VERTEX || !index.isCompositeIndex() || !index.indexesKey(key)) continue;
            return true;
        }
        return false;
    }

    public static InternalRelationType getBaseType(InternalRelationType type) {
        InternalRelationType baseType = type.getBaseType();
        if (baseType == null) {
            return type;
        }
        return baseType;
    }

    public static Set<PropertyKey> getIndexedKeys(IndexType index) {
        HashSet s = Sets.newHashSet();
        for (IndexField f : index.getFieldKeys()) {
            s.add(f.getFieldKey());
        }
        return s;
    }

    public static List<CompositeIndexType> getUniqueIndexes(PropertyKey key) {
        ArrayList<CompositeIndexType> indexes = new ArrayList<CompositeIndexType>();
        for (IndexType index : ((InternalRelationType)((Object)key)).getKeyIndexes()) {
            if (!index.isCompositeIndex()) continue;
            CompositeIndexType iIndex = (CompositeIndexType)index;
            assert (index.indexesKey(key));
            if (iIndex.getCardinality() != Cardinality.SINGLE) continue;
            assert (iIndex.getElement() == ElementCategory.VERTEX);
            indexes.add(iIndex);
        }
        return indexes;
    }

    private static <T> T getTypeModifier(SchemaSource schema, ModifierType modifierType, T defaultValue) {
        for (SchemaSource.Entry entry : schema.getRelated(TypeDefinitionCategory.TYPE_MODIFIER, Direction.OUT)) {
            Object value = entry.getSchemaType().getDefinition().getValue(modifierType.getCategory());
            if (null == value) continue;
            return (T)value;
        }
        return defaultValue;
    }

    public static ConsistencyModifier getConsistencyModifier(SchemaSource schema) {
        return TypeUtil.getTypeModifier(schema, ModifierType.CONSISTENCY, ConsistencyModifier.DEFAULT);
    }

    public static int getTTL(SchemaSource schema) {
        return TypeUtil.getTypeModifier(schema, ModifierType.TTL, 0);
    }
}

