/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.cassandra;

import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.cassandra.CassandraTransaction;
import com.thinkaurelius.titan.diskstorage.common.DistributedStoreManager;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StandardStoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.PreInitializeConfigOptions;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public abstract class AbstractCassandraStoreManager
extends DistributedStoreManager
implements KeyColumnValueStoreManager {
    public static final ConfigNamespace CASSANDRA_NS = new ConfigNamespace(GraphDatabaseConfiguration.STORAGE_NS, "cassandra", "Cassandra storage backend options");
    public static final ConfigOption<String> CASSANDRA_KEYSPACE = new ConfigOption(CASSANDRA_NS, "keyspace", "The name of Titan's keyspace.  It will be created if it does not exist.", ConfigOption.Type.LOCAL, (Object)"titan");
    public static final ConfigOption<String> CASSANDRA_READ_CONSISTENCY = new ConfigOption(CASSANDRA_NS, "read-consistency-level", "The consistency level of read operations against Cassandra", ConfigOption.Type.MASKABLE, (Object)"QUORUM");
    public static final ConfigOption<String> CASSANDRA_WRITE_CONSISTENCY = new ConfigOption(CASSANDRA_NS, "write-consistency-level", "The consistency level of write operations against Cassandra", ConfigOption.Type.MASKABLE, (Object)"QUORUM");
    public static final ConfigOption<Boolean> ATOMIC_BATCH_MUTATE = new ConfigOption(CASSANDRA_NS, "atomic-batch-mutate", "True to use Cassandra atomic batch mutation, false to use non-atomic batches", ConfigOption.Type.MASKABLE, (Object)true);
    public static final ConfigOption<Integer> REPLICATION_FACTOR = new ConfigOption(CASSANDRA_NS, "replication-factor", "The number of data replicas (including the original copy) that should be kept. This is only meaningful for storage backends that natively support data replication.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)1);
    public static final ConfigOption<String> REPLICATION_STRATEGY = new ConfigOption(CASSANDRA_NS, "replication-strategy-class", "The replication strategy to use for Titan keyspace", ConfigOption.Type.FIXED, (Object)"org.apache.cassandra.locator.SimpleStrategy");
    public static final ConfigOption<String[]> REPLICATION_OPTIONS = new ConfigOption(CASSANDRA_NS, "replication-strategy-options", "Replication strategy options, e.g. factor or replicas per datacenter.  This list is interpreted as a map.  It must have an even number of elements in [key,val,key,val,...] form.  A replication_factor set here takes precedence over one set with " + ConfigElement.getPath(REPLICATION_FACTOR, (String[])new String[0]), ConfigOption.Type.FIXED, String[].class);
    public static final ConfigOption<Boolean> CF_COMPRESSION = new ConfigOption(CASSANDRA_NS, "compression", "Whether the storage backend should use compression when storing the data", ConfigOption.Type.FIXED, (Object)true);
    public static final ConfigOption<String> CF_COMPRESSION_TYPE = new ConfigOption(CASSANDRA_NS, "compression-type", "The sstable_compression value Titan uses when creating column families. This accepts any value allowed by Cassandra's sstable_compression option. Leave this unset to disable sstable_compression on Titan-created CFs.", ConfigOption.Type.MASKABLE, (Object)"LZ4Compressor");
    public static final ConfigOption<Integer> CF_COMPRESSION_BLOCK_SIZE = new ConfigOption(CASSANDRA_NS, "compression-block-size", "The size of the compression blocks in kilobytes", ConfigOption.Type.FIXED, (Object)64);
    public static final ConfigNamespace SSL_NS = new ConfigNamespace(CASSANDRA_NS, "ssl", "Configuration options for SSL");
    public static final ConfigNamespace SSL_TRUSTSTORE_NS = new ConfigNamespace(SSL_NS, "truststore", "Configuration options for SSL Truststore.");
    public static final ConfigOption<Boolean> SSL_ENABLED = new ConfigOption(SSL_NS, "enabled", "Controls use of the SSL connection to Cassandra", ConfigOption.Type.LOCAL, (Object)false);
    public static final ConfigOption<String> SSL_TRUSTSTORE_LOCATION = new ConfigOption(SSL_TRUSTSTORE_NS, "location", "Marks the location of the SSL Truststore.", ConfigOption.Type.LOCAL, (Object)"");
    public static final ConfigOption<String> SSL_TRUSTSTORE_PASSWORD = new ConfigOption(SSL_TRUSTSTORE_NS, "password", "The password to access SSL Truststore.", ConfigOption.Type.LOCAL, (Object)"");
    public static final int PORT_DEFAULT = 9160;
    public static final String SYSTEM_KS = "system";
    protected final String keySpaceName;
    protected final Map<String, String> strategyOptions;
    protected final boolean compressionEnabled;
    protected final int compressionChunkSizeKB;
    protected final String compressionClass;
    protected final boolean atomicBatch;
    private volatile StoreFeatures features = null;
    private Partitioner partitioner = null;
    private static final Logger log = LoggerFactory.getLogger(AbstractCassandraStoreManager.class);

    public AbstractCassandraStoreManager(Configuration config) {
        super(config, 9160);
        this.keySpaceName = (String)config.get(CASSANDRA_KEYSPACE, new String[0]);
        this.compressionEnabled = (Boolean)config.get(CF_COMPRESSION, new String[0]);
        this.compressionChunkSizeKB = (Integer)config.get(CF_COMPRESSION_BLOCK_SIZE, new String[0]);
        this.compressionClass = (String)config.get(CF_COMPRESSION_TYPE, new String[0]);
        this.atomicBatch = (Boolean)config.get(ATOMIC_BATCH_MUTATE, new String[0]);
        if (((Boolean)config.get(SSL_ENABLED, new String[0])).booleanValue() && ((String)config.get(SSL_TRUSTSTORE_LOCATION, new String[0])).isEmpty()) {
            throw new IllegalArgumentException(SSL_TRUSTSTORE_LOCATION.getName() + " could not be empty when SSL is enabled.");
        }
        if (config.has(REPLICATION_OPTIONS, new String[0])) {
            String[] options = (String[])config.get(REPLICATION_OPTIONS, new String[0]);
            if (options.length % 2 != 0) {
                throw new IllegalArgumentException(REPLICATION_OPTIONS.getName() + " should have even number of elements.");
            }
            HashMap<String, String> converted = new HashMap<String, String>(options.length / 2);
            for (int i = 0; i < options.length; i += 2) {
                converted.put(options[i], options[i + 1]);
            }
            this.strategyOptions = ImmutableMap.copyOf(converted);
        } else {
            this.strategyOptions = ImmutableMap.of((Object)"replication_factor", (Object)String.valueOf(config.get(REPLICATION_FACTOR, new String[0])));
        }
    }

    public final Partitioner getPartitioner() {
        if (this.partitioner == null) {
            try {
                this.partitioner = Partitioner.getPartitioner(this.getCassandraPartitioner());
            }
            catch (BackendException e) {
                throw new TitanException("Could not connect to Cassandra to read partitioner information. Please check the connection", (Throwable)e);
            }
        }
        assert (this.partitioner != null);
        return this.partitioner;
    }

    public abstract IPartitioner<? extends Token<?>> getCassandraPartitioner() throws BackendException;

    public StoreTransaction beginTransaction(BaseTransactionConfig config) {
        return new CassandraTransaction(config);
    }

    public String toString() {
        return "[" + this.keySpaceName + "@" + super.toString() + "]";
    }

    public StoreFeatures getFeatures() {
        if (this.features == null) {
            boolean keyOrdered;
            ModifiableConfiguration global = GraphDatabaseConfiguration.buildConfiguration().set(CASSANDRA_READ_CONSISTENCY, (Object)"QUORUM", new String[0]).set(CASSANDRA_WRITE_CONSISTENCY, (Object)"QUORUM", new String[0]).set(GraphDatabaseConfiguration.METRICS_PREFIX, (Object)"com.thinkaurelius.titan.sys", new String[0]);
            ModifiableConfiguration local = GraphDatabaseConfiguration.buildConfiguration().set(CASSANDRA_READ_CONSISTENCY, (Object)"LOCAL_QUORUM", new String[0]).set(CASSANDRA_WRITE_CONSISTENCY, (Object)"LOCAL_QUORUM", new String[0]).set(GraphDatabaseConfiguration.METRICS_PREFIX, (Object)"com.thinkaurelius.titan.sys", new String[0]);
            StandardStoreFeatures.Builder fb = new StandardStoreFeatures.Builder();
            fb.batchMutation(true).distributed(true);
            fb.timestamps(true).cellTTL(true);
            fb.keyConsistent((Configuration)global, (Configuration)local);
            switch (this.getPartitioner()) {
                case RANDOM: {
                    keyOrdered = false;
                    fb.keyOrdered(keyOrdered).orderedScan(false).unorderedScan(true);
                    break;
                }
                case BYTEORDER: {
                    keyOrdered = true;
                    fb.keyOrdered(keyOrdered).orderedScan(true).unorderedScan(false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized partitioner: " + (Object)((Object)this.getPartitioner()));
                }
            }
            switch (this.getDeployment()) {
                case REMOTE: {
                    fb.multiQuery(true);
                    break;
                }
                case LOCAL: {
                    fb.multiQuery(true).localKeyPartition(keyOrdered);
                    break;
                }
                case EMBEDDED: {
                    fb.multiQuery(false).localKeyPartition(keyOrdered);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized deployment mode: " + this.getDeployment());
                }
            }
            this.features = fb.build();
        }
        return this.features;
    }

    public abstract Map<String, String> getCompressionOptions(String var1) throws BackendException;

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName() + this.keySpaceName;
    }

    public static enum Partitioner {
        RANDOM,
        BYTEORDER;


        public static Partitioner getPartitioner(IPartitioner<?> partitioner) {
            return Partitioner.getPartitioner(partitioner.getClass().getSimpleName());
        }

        public static Partitioner getPartitioner(String className) {
            if (className.endsWith("RandomPartitioner") || className.endsWith("Murmur3Partitioner")) {
                return RANDOM;
            }
            if (className.endsWith("ByteOrderedPartitioner")) {
                return BYTEORDER;
            }
            throw new IllegalArgumentException("Unsupported partitioner: " + className);
        }
    }
}

