/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.qjournal.client.QuorumJournalManager;
import org.apache.hadoop.hdfs.qjournal.server.Journal;
import org.apache.hadoop.hdfs.qjournal.server.JournalNodeHttpServer;
import org.apache.hadoop.hdfs.qjournal.server.JournalNodeMXBean;
import org.apache.hadoop.hdfs.qjournal.server.JournalNodeRpcServer;
import org.apache.hadoop.hdfs.server.common.StorageErrorReporter;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.mortbay.util.ajax.JSON;

@InterfaceAudience.Private
public class JournalNode
implements Tool,
Configurable,
JournalNodeMXBean {
    public static final Log LOG = LogFactory.getLog(JournalNode.class);
    private Configuration conf;
    private JournalNodeRpcServer rpcServer;
    private JournalNodeHttpServer httpServer;
    private Map<String, Journal> journalsById = Maps.newHashMap();
    private ObjectName journalNodeInfoBeanName;
    private String httpServerURI;
    private File localDir;
    private int resultCode = 0;

    synchronized Journal getOrCreateJournal(String jid) throws IOException {
        QuorumJournalManager.checkJournalId(jid);
        Journal journal = this.journalsById.get(jid);
        if (journal == null) {
            File logDir = this.getLogDir(jid);
            LOG.info((Object)("Initializing journal in directory " + logDir));
            journal = new Journal(this.conf, logDir, jid, new ErrorReporter());
            this.journalsById.put(jid, journal);
        }
        return journal;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.localDir = new File(conf.get("dfs.journalnode.edits.dir", "/tmp/hadoop/dfs/journalnode/").trim());
    }

    private static void validateAndCreateJournalDir(File dir) throws IOException {
        if (!dir.isAbsolute()) {
            throw new IllegalArgumentException("Journal dir '" + dir + "' should be an absolute path");
        }
        DiskChecker.checkDir((File)dir);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public int run(String[] args) throws Exception {
        this.start();
        return this.join();
    }

    public void start() throws IOException {
        Preconditions.checkState((!this.isStarted() ? 1 : 0) != 0, (Object)"JN already running");
        JournalNode.validateAndCreateJournalDir(this.localDir);
        DefaultMetricsSystem.initialize((String)"JournalNode");
        JvmMetrics.create((String)"JournalNode", (String)this.conf.get("dfs.metrics.session-id"), (MetricsSystem)DefaultMetricsSystem.instance());
        InetSocketAddress socAddr = JournalNodeRpcServer.getAddress(this.conf);
        SecurityUtil.login((Configuration)this.conf, (String)"dfs.journalnode.keytab.file", (String)"dfs.journalnode.kerberos.principal", (String)socAddr.getHostName());
        this.registerJNMXBean();
        this.httpServer = new JournalNodeHttpServer(this.conf, this);
        this.httpServer.start();
        this.httpServerURI = this.httpServer.getServerURI().toString();
        this.rpcServer = new JournalNodeRpcServer(this.conf, this);
        this.rpcServer.start();
    }

    public boolean isStarted() {
        return this.rpcServer != null;
    }

    public InetSocketAddress getBoundIpcAddress() {
        return this.rpcServer.getAddress();
    }

    @Deprecated
    public InetSocketAddress getBoundHttpAddress() {
        return this.httpServer.getAddress();
    }

    public String getHttpServerURI() {
        return this.httpServerURI;
    }

    public void stop(int rc) {
        this.resultCode = rc;
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
        if (this.httpServer != null) {
            try {
                this.httpServer.stop();
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Unable to stop HTTP server for " + this), (Throwable)ioe);
            }
        }
        for (Journal j : this.journalsById.values()) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{j});
        }
        if (this.journalNodeInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.journalNodeInfoBeanName);
            this.journalNodeInfoBeanName = null;
        }
    }

    int join() throws InterruptedException {
        if (this.rpcServer != null) {
            this.rpcServer.join();
        }
        return this.resultCode;
    }

    public void stopAndJoin(int rc) throws InterruptedException {
        this.stop(rc);
        this.join();
    }

    private File getLogDir(String jid) {
        String dir = this.conf.get("dfs.journalnode.edits.dir", "/tmp/hadoop/dfs/journalnode/");
        Preconditions.checkArgument((jid != null && !jid.isEmpty() ? 1 : 0) != 0, (String)"bad journal identifier: %s", (Object[])new Object[]{jid});
        return new File(new File(dir), jid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJournalsStatus() {
        File[] journalDirs;
        HashMap status = new HashMap();
        JournalNode journalNode = this;
        synchronized (journalNode) {
            for (Map.Entry<String, Journal> entry : this.journalsById.entrySet()) {
                HashMap<String, String> jMap = new HashMap<String, String>();
                jMap.put("Formatted", Boolean.toString(entry.getValue().isFormatted()));
                status.put(entry.getKey(), jMap);
            }
        }
        for (File journalDir : journalDirs = this.localDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            String jid = journalDir.getName();
            if (status.containsKey(jid)) continue;
            HashMap<String, String> jMap = new HashMap<String, String>();
            jMap.put("Formatted", "true");
            status.put(jid, jMap);
        }
        return JSON.toString(status);
    }

    private void registerJNMXBean() {
        this.journalNodeInfoBeanName = MBeans.register((String)"JournalNode", (String)"JournalNodeInfo", (Object)this);
    }

    public static void main(String[] args) throws Exception {
        StringUtils.startupShutdownMessage(JournalNode.class, (String[])args, (Log)LOG);
        System.exit(ToolRunner.run((Tool)new JournalNode(), (String[])args));
    }

    static {
        HdfsConfiguration.init();
    }

    private class ErrorReporter
    implements StorageErrorReporter {
        private ErrorReporter() {
        }

        @Override
        public void reportErrorOnFile(File f) {
            LOG.fatal((Object)("Error reported on file " + f + "... exiting"), (Throwable)new Exception());
            JournalNode.this.stop(1);
        }
    }
}

