/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class IncorrectVersionException
extends IOException {
    private static final long serialVersionUID = 1L;

    public IncorrectVersionException(String message) {
        super(message);
    }

    public IncorrectVersionException(String minimumVersion, String reportedVersion, String remoteDaemon, String thisDaemon) {
        this("The reported " + remoteDaemon + " version is too low to communicate" + " with this " + thisDaemon + ". " + remoteDaemon + " version: '" + reportedVersion + "' Minimum " + remoteDaemon + " version: '" + minimumVersion + "'");
    }

    public IncorrectVersionException(int versionReported, String ofWhat) {
        this(versionReported, ofWhat, HdfsConstants.LAYOUT_VERSION);
    }

    public IncorrectVersionException(int versionReported, String ofWhat, int versionExpected) {
        this("Unexpected version " + (ofWhat == null ? "" : "of " + ofWhat) + ". Reported: " + versionReported + ". Expecting = " + versionExpected + ".");
    }
}

