/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.EdgeInfo;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.util.ConvertingIterable;

public class EdgeVertexPair {
    private final Edge edge;
    private final Vertex vertex;

    public EdgeVertexPair(Edge edge, Vertex vertex) {
        this.edge = edge;
        this.vertex = vertex;
    }

    public Edge getEdge() {
        return this.edge;
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    public String toString() {
        return "EdgeVertexPair{edge=" + this.edge + ", vertex=" + this.vertex + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EdgeVertexPair that = (EdgeVertexPair)o;
        if (!this.edge.equals(that.edge)) {
            return false;
        }
        return this.vertex.equals(that.vertex);
    }

    public int hashCode() {
        int result = this.edge.hashCode();
        result = 31 * result + this.vertex.hashCode();
        return result;
    }

    public static Iterable<EdgeVertexPair> getEdgeVertexPairs(Graph graph, final String sourceVertexId, Iterable<EdgeInfo> edgeInfos, EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        HashSet<String> edgeIdsToFetch = new HashSet<String>();
        HashSet<String> vertexIdsToFetch = new HashSet<String>();
        for (EdgeInfo edgeInfo : edgeInfos) {
            edgeIdsToFetch.add(edgeInfo.getEdgeId());
            vertexIdsToFetch.add(edgeInfo.getVertexId());
        }
        final HashMap<String, Vertex> vertices = new HashMap<String, Vertex>();
        for (Vertex v : graph.getVertices(vertexIdsToFetch, fetchHints, endTime, authorizations)) {
            vertices.put(v.getId(), v);
        }
        Iterable<Edge> iterable = graph.getEdges(edgeIdsToFetch, fetchHints, endTime, authorizations);
        return new ConvertingIterable<Edge, EdgeVertexPair>(iterable){

            @Override
            protected EdgeVertexPair convert(Edge edge) {
                String otherVertexId = edge.getOtherVertexId(sourceVertexId);
                Vertex otherVertex = (Vertex)vertices.get(otherVertexId);
                if (otherVertex == null) {
                    throw new VertexiumException("Found an edge " + edge.getId() + ", but could not find the vertex on the other end: " + otherVertexId);
                }
                return new EdgeVertexPair(edge, otherVertex);
            }
        };
    }
}

