/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium;

import java.util.EnumSet;
import java.util.Map;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilder;
import org.vertexium.EdgeBuilderByVertexId;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.GraphBase;
import org.vertexium.GraphConfiguration;
import org.vertexium.GraphMetadataEntry;
import org.vertexium.GraphMetadataStore;
import org.vertexium.GraphWithSearchIndex;
import org.vertexium.PropertyDefinition;
import org.vertexium.SearchIndexSecurityGranularity;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.id.IdGenerator;
import org.vertexium.query.GraphQuery;
import org.vertexium.query.MultiVertexQuery;
import org.vertexium.query.SimilarToGraphQuery;
import org.vertexium.search.SearchIndex;
import org.vertexium.search.SearchIndexWithVertexPropertyCountByValue;

public abstract class GraphBaseWithSearchIndex
extends GraphBase
implements Graph,
GraphWithSearchIndex {
    public static final String METADATA_ID_GENERATOR_CLASSNAME = "idGenerator.classname";
    private final GraphConfiguration configuration;
    private final IdGenerator idGenerator;
    private SearchIndex searchIndex;
    private boolean foundIdGeneratorClassnameInMetadata;

    protected GraphBaseWithSearchIndex(GraphConfiguration configuration) {
        super(configuration.isStrictTyping());
        this.configuration = configuration;
        this.searchIndex = configuration.createSearchIndex(this);
        this.idGenerator = configuration.createIdGenerator(this);
    }

    protected GraphBaseWithSearchIndex(GraphConfiguration configuration, IdGenerator idGenerator, SearchIndex searchIndex) {
        super(configuration.isStrictTyping());
        this.configuration = configuration;
        this.searchIndex = searchIndex;
        this.idGenerator = idGenerator;
    }

    protected void setup() {
        this.setupGraphMetadata();
    }

    protected void setupGraphMetadata() {
        this.foundIdGeneratorClassnameInMetadata = false;
        for (GraphMetadataEntry graphMetadataEntry : this.getMetadata()) {
            this.setupGraphMetadata(graphMetadataEntry);
        }
        if (!this.foundIdGeneratorClassnameInMetadata) {
            this.setMetadata(METADATA_ID_GENERATOR_CLASSNAME, this.idGenerator.getClass().getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setupGraphMetadata(GraphMetadataEntry graphMetadataEntry) {
        if (graphMetadataEntry.getKey().startsWith("defineProperty.")) {
            if (!(graphMetadataEntry.getValue() instanceof PropertyDefinition)) throw new VertexiumException("Invalid property definition metadata: " + graphMetadataEntry.getKey() + " expected " + PropertyDefinition.class.getName() + " found " + graphMetadataEntry.getValue().getClass().getName());
            this.addToPropertyDefinitionCache((PropertyDefinition)graphMetadataEntry.getValue());
            return;
        } else {
            if (!graphMetadataEntry.getKey().equals(METADATA_ID_GENERATOR_CLASSNAME)) return;
            if (!(graphMetadataEntry.getValue() instanceof String)) throw new VertexiumException("Invalid idGenerator.classname expected String found " + graphMetadataEntry.getValue().getClass().getName());
            String idGeneratorClassname = (String)graphMetadataEntry.getValue();
            if (!idGeneratorClassname.equals(this.idGenerator.getClass().getName())) return;
            this.foundIdGeneratorClassnameInMetadata = true;
        }
    }

    @Override
    public GraphQuery query(Authorizations authorizations) {
        return this.getSearchIndex().queryGraph(this, null, authorizations);
    }

    @Override
    public GraphQuery query(String queryString, Authorizations authorizations) {
        return this.getSearchIndex().queryGraph(this, queryString, authorizations);
    }

    @Override
    public MultiVertexQuery query(String[] vertexIds, String queryString, Authorizations authorizations) {
        return this.getSearchIndex().queryGraph(this, vertexIds, queryString, authorizations);
    }

    @Override
    public MultiVertexQuery query(String[] vertexIds, Authorizations authorizations) {
        return this.getSearchIndex().queryGraph(this, vertexIds, null, authorizations);
    }

    @Override
    public boolean isQuerySimilarToTextSupported() {
        return this.getSearchIndex().isQuerySimilarToTextSupported();
    }

    @Override
    public SimilarToGraphQuery querySimilarTo(String[] fields, String text, Authorizations authorizations) {
        return this.getSearchIndex().querySimilarTo(this, fields, text, authorizations);
    }

    @Override
    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public GraphConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public SearchIndex getSearchIndex() {
        return this.searchIndex;
    }

    @Override
    public void reindex(Authorizations authorizations) {
        this.reindexVertices(authorizations);
        this.reindexEdges(authorizations);
    }

    protected void reindexVertices(Authorizations authorizations) {
        this.searchIndex.addElements(this, this.getVertices(authorizations), authorizations);
    }

    private void reindexEdges(Authorizations authorizations) {
        this.searchIndex.addElements(this, this.getEdges(authorizations), authorizations);
    }

    @Override
    public void flush() {
        if (this.getSearchIndex() != null) {
            this.searchIndex.flush(this);
        }
    }

    @Override
    public void shutdown() {
        this.flush();
        if (this.getSearchIndex() != null) {
            this.searchIndex.shutdown();
            this.searchIndex = null;
        }
    }

    @Override
    public abstract void drop();

    @Override
    public boolean isFieldBoostSupported() {
        return this.getSearchIndex().isFieldBoostSupported();
    }

    @Override
    public SearchIndexSecurityGranularity getSearchIndexSecurityGranularity() {
        return this.getSearchIndex().getSearchIndexSecurityGranularity();
    }

    @Override
    public Map<Object, Long> getVertexPropertyCountByValue(String propertyName, Authorizations authorizations) {
        if (this.getSearchIndex() instanceof SearchIndexWithVertexPropertyCountByValue) {
            return ((SearchIndexWithVertexPropertyCountByValue)((Object)this.getSearchIndex())).getVertexPropertyCountByValue(this, propertyName, authorizations);
        }
        return super.getVertexPropertyCountByValue(propertyName, authorizations);
    }

    @Override
    public abstract VertexBuilder prepareVertex(String var1, Long var2, Visibility var3);

    @Override
    public abstract Iterable<Vertex> getVertices(EnumSet<FetchHint> var1, Long var2, Authorizations var3);

    @Override
    public abstract EdgeBuilder prepareEdge(String var1, Vertex var2, Vertex var3, String var4, Long var5, Visibility var6);

    @Override
    public abstract EdgeBuilderByVertexId prepareEdge(String var1, String var2, String var3, String var4, Long var5, Visibility var6);

    @Override
    public abstract void softDeleteVertex(Vertex var1, Long var2, Authorizations var3);

    @Override
    public abstract void softDeleteEdge(Edge var1, Long var2, Authorizations var3);

    @Override
    public abstract Iterable<Edge> getEdges(EnumSet<FetchHint> var1, Long var2, Authorizations var3);

    @Override
    protected abstract GraphMetadataStore getGraphMetadataStore();

    @Override
    public abstract void deleteVertex(Vertex var1, Authorizations var2);

    @Override
    public abstract void deleteEdge(Edge var1, Authorizations var2);

    @Override
    public abstract boolean isVisibilityValid(Visibility var1, Authorizations var2);

    @Override
    public abstract void truncate();

    @Override
    public abstract void markVertexHidden(Vertex var1, Visibility var2, Authorizations var3);

    @Override
    public abstract void markVertexVisible(Vertex var1, Visibility var2, Authorizations var3);

    @Override
    public abstract void markEdgeHidden(Edge var1, Visibility var2, Authorizations var3);

    @Override
    public abstract void markEdgeVisible(Edge var1, Visibility var2, Authorizations var3);

    @Override
    public abstract Authorizations createAuthorizations(String ... var1);
}

