/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.property;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.vertexium.VertexiumException;
import org.vertexium.property.PropertyValue;
import org.vertexium.util.StreamUtils;

public class StreamingPropertyValue
extends PropertyValue
implements Serializable {
    static final long serialVersionUID = 42L;
    private final transient InputStream inputStream;
    private final Class valueType;
    private final long length;

    public StreamingPropertyValue() {
        this(null, null);
    }

    public StreamingPropertyValue(InputStream inputStream, Class valueType) {
        this(inputStream, valueType, -1L);
    }

    public StreamingPropertyValue(InputStream inputStream, Class valueType, long length) {
        this.inputStream = inputStream;
        this.valueType = valueType;
        this.length = length;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Class getValueType() {
        return this.valueType;
    }

    public long getLength() {
        return this.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readToString() {
        try (InputStream in = this.getInputStream();){
            String string = StreamUtils.toString(in);
            return string;
        }
        catch (IOException e) {
            throw new VertexiumException("Could not read streaming property value into string", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readToString(long offset, long limit) {
        try (InputStream in = this.getInputStream();){
            String string = StreamUtils.toString(in, offset, limit);
            return string;
        }
        catch (IOException e) {
            throw new VertexiumException("Could not read streaming property value into string", e);
        }
    }

    public static StreamingPropertyValue create(String value) {
        ByteArrayInputStream data = new ByteArrayInputStream(value.getBytes());
        return new StreamingPropertyValue(data, String.class);
    }

    public String toString() {
        return "StreamingPropertyValue{valueType=" + this.valueType + ", length=" + this.length + '}';
    }
}

