/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.FetchHint;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.query.Aggregation;
import org.vertexium.query.Predicate;
import org.vertexium.query.Query;
import org.vertexium.query.QueryResultsIterable;
import org.vertexium.query.QueryResultsSelectManyIterable;
import org.vertexium.query.SortDirection;
import org.vertexium.util.SelectManyIterable;

public class CompositeGraphQuery
implements Query {
    private final List<Query> queries;

    public CompositeGraphQuery(Query ... queries) {
        this(Arrays.asList(queries));
    }

    public CompositeGraphQuery(Collection<Query> queries) {
        this.queries = new ArrayList<Query>(queries);
    }

    @Override
    public QueryResultsIterable<Vertex> vertices() {
        return this.vertices(FetchHint.ALL);
    }

    @Override
    public QueryResultsIterable<Vertex> vertices(final EnumSet<FetchHint> fetchHints) {
        final HashSet seenIds = new HashSet();
        return new QueryResultsSelectManyIterable<Vertex>(this.queries){

            @Override
            public Iterable<Vertex> getIterable(Query query) {
                return query.vertices(fetchHints);
            }

            @Override
            protected boolean isIncluded(Vertex vertex) {
                if (seenIds.contains(vertex.getId())) {
                    return false;
                }
                seenIds.add(vertex.getId());
                return super.isIncluded(vertex);
            }
        };
    }

    @Override
    public QueryResultsIterable<Edge> edges() {
        return this.edges(FetchHint.ALL);
    }

    @Override
    public QueryResultsIterable<Edge> edges(final EnumSet<FetchHint> fetchHints) {
        final HashSet seenIds = new HashSet();
        return new QueryResultsSelectManyIterable<Edge>(this.queries){

            @Override
            public Iterable<Edge> getIterable(Query query) {
                return query.edges(fetchHints);
            }

            @Override
            protected boolean isIncluded(Edge edge) {
                if (seenIds.contains(edge.getId())) {
                    return false;
                }
                seenIds.add(edge.getId());
                return super.isIncluded(edge);
            }
        };
    }

    @Override
    @Deprecated
    public QueryResultsIterable<Edge> edges(String label) {
        this.hasEdgeLabel(label);
        return this.edges(FetchHint.ALL);
    }

    @Override
    @Deprecated
    public QueryResultsIterable<Edge> edges(String label, EnumSet<FetchHint> fetchHints) {
        this.hasEdgeLabel(label);
        return this.edges(fetchHints);
    }

    @Override
    public QueryResultsIterable<Element> elements() {
        return this.elements(FetchHint.ALL);
    }

    @Override
    public QueryResultsIterable<Element> elements(final EnumSet<FetchHint> fetchHints) {
        final HashSet seenIds = new HashSet();
        return new QueryResultsSelectManyIterable<Element>(this.queries){

            @Override
            public Iterable<Element> getIterable(Query query) {
                return query.elements(fetchHints);
            }

            @Override
            protected boolean isIncluded(Element element) {
                if (seenIds.contains(element.getId())) {
                    return false;
                }
                seenIds.add(element.getId());
                return super.isIncluded(element);
            }
        };
    }

    @Override
    public <T> Query range(String propertyName, T startValue, T endValue) {
        for (Query query : this.queries) {
            query.range(propertyName, startValue, endValue);
        }
        return this;
    }

    @Override
    public <T> Query range(String propertyName, T startValue, boolean inclusiveStartValue, T endValue, boolean inclusiveEndValue) {
        for (Query query : this.queries) {
            query.range(propertyName, startValue, inclusiveStartValue, endValue, inclusiveEndValue);
        }
        return this;
    }

    @Override
    public <T> Query hasEdgeLabel(String ... edgeLabels) {
        for (Query query : this.queries) {
            query.hasEdgeLabel(edgeLabels);
        }
        return this;
    }

    @Override
    public <T> Query hasEdgeLabel(Collection<String> edgeLabels) {
        for (Query query : this.queries) {
            query.hasEdgeLabel(edgeLabels);
        }
        return this;
    }

    @Override
    public <T> Query has(String propertyName, T value) {
        for (Query query : this.queries) {
            query.has(propertyName, value);
        }
        return this;
    }

    @Override
    public <T> Query hasNot(String propertyName, T value) {
        for (Query query : this.queries) {
            query.hasNot(propertyName, value);
        }
        return this;
    }

    @Override
    public <T> Query has(String propertyName, Predicate predicate, T value) {
        for (Query query : this.queries) {
            query.has(propertyName, predicate, value);
        }
        return this;
    }

    @Override
    public Query has(String propertyName) {
        for (Query query : this.queries) {
            query.has(propertyName);
        }
        return this;
    }

    @Override
    public Query hasNot(String propertyName) {
        for (Query query : this.queries) {
            query.hasNot(propertyName);
        }
        return this;
    }

    @Override
    public Query skip(int count) {
        for (Query query : this.queries) {
            query.skip(count);
        }
        return this;
    }

    @Override
    public Query limit(Integer count) {
        for (Query query : this.queries) {
            query.limit(count);
        }
        return this;
    }

    @Override
    public Query limit(Long count) {
        for (Query query : this.queries) {
            query.limit(count);
        }
        return this;
    }

    @Override
    public Query sort(String propertyName, SortDirection direction) {
        for (Query query : this.queries) {
            query.sort(propertyName, direction);
        }
        return this;
    }

    @Override
    public boolean isAggregationSupported(Aggregation aggregation) {
        for (Query query : this.queries) {
            if (query.isAggregationSupported(aggregation)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Query addAggregation(Aggregation aggregation) {
        for (Query query : this.queries) {
            if (query.isAggregationSupported(aggregation)) continue;
            throw new VertexiumException(query.getClass().getName() + " does not support aggregation of type " + aggregation.getClass().getName());
        }
        for (Query query : this.queries) {
            query.addAggregation(aggregation);
        }
        return this;
    }

    @Override
    public Iterable<Aggregation> getAggregations() {
        return new SelectManyIterable<Query, Aggregation>(this.queries){

            @Override
            protected Iterable<? extends Aggregation> getIterable(Query query) {
                return query.getAggregations();
            }
        };
    }
}

