/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.query;

import java.util.Collection;
import org.vertexium.Property;
import org.vertexium.PropertyDefinition;
import org.vertexium.VertexiumException;
import org.vertexium.query.Compare;
import org.vertexium.query.Predicate;

public enum Contains implements Predicate
{
    IN,
    NOT_IN;


    @Override
    public boolean evaluate(Iterable<Property> properties, Object second, Collection<PropertyDefinition> propertyDefinitions) {
        for (Property property : properties) {
            PropertyDefinition propertyDefinition;
            if (!this.evaluate(property, second, propertyDefinition = PropertyDefinition.findPropertyDefinition(propertyDefinitions, property.getName()))) continue;
            return true;
        }
        return false;
    }

    private boolean evaluate(Property property, Object second, PropertyDefinition propertyDefinition) {
        if (second instanceof Iterable) {
            switch (this) {
                case IN: {
                    return this.evaluateInIterable(property, (Iterable)second, propertyDefinition);
                }
                case NOT_IN: {
                    return !this.evaluateInIterable(property, (Iterable)second, propertyDefinition);
                }
            }
            throw new VertexiumException("Not implemented: " + this);
        }
        if (second.getClass().isArray()) {
            switch (this) {
                case IN: {
                    return this.evaluateInIterable(property, (Object[])second, propertyDefinition);
                }
                case NOT_IN: {
                    return !this.evaluateInIterable(property, (Object[])second, propertyDefinition);
                }
            }
            throw new VertexiumException("Not implemented: " + this);
        }
        throw new VertexiumException("Not implemented 'Contains' type. Expected Iterable found " + second.getClass().getName());
    }

    private boolean evaluateInIterable(Property property, Iterable second, PropertyDefinition propertyDefinition) {
        Object first = property.getValue();
        for (Object o : second) {
            if (!Compare.evaluate(first, Compare.EQUAL, o, propertyDefinition)) continue;
            return true;
        }
        return false;
    }

    private boolean evaluateInIterable(Property property, Object[] second, PropertyDefinition propertyDefinition) {
        Object first = property.getValue();
        for (Object o : second) {
            if (!Compare.evaluate(first, Compare.EQUAL, o, propertyDefinition)) continue;
            return true;
        }
        return false;
    }
}

