/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.query;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Property;
import org.vertexium.VertexiumException;
import org.vertexium.query.AggregationResult;
import org.vertexium.query.QueryBase;
import org.vertexium.query.QueryParameters;
import org.vertexium.query.QueryResultsIterable;
import org.vertexium.query.QueryStringQueryParameters;
import org.vertexium.query.SortContainersComparator;
import org.vertexium.util.CloseableIterator;
import org.vertexium.util.CloseableUtils;
import org.vertexium.util.IterableUtils;

public class DefaultGraphQueryIterable<T extends Element>
implements Iterable<T>,
QueryResultsIterable<T> {
    private final QueryParameters parameters;
    private final Iterable<T> iterable;
    private final boolean evaluateQueryString;
    private final boolean evaluateHasContainers;

    public DefaultGraphQueryIterable(QueryParameters parameters, Iterable<T> iterable, boolean evaluateQueryString, boolean evaluateHasContainers, boolean evaluateSortContainers) {
        this.parameters = parameters;
        this.evaluateQueryString = evaluateQueryString;
        this.evaluateHasContainers = evaluateHasContainers;
        this.iterable = evaluateSortContainers && this.parameters.getSortContainers().size() > 0 ? this.sort(iterable, parameters.getSortContainers()) : iterable;
    }

    private Iterable<T> sort(Iterable<T> iterable, List<QueryBase.SortContainer> sortContainers) {
        List<T> list = IterableUtils.toList(iterable);
        Collections.sort(list, new SortContainersComparator(sortContainers));
        return list;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(false);
    }

    protected Iterator<T> iterator(final boolean iterateAll) {
        final Iterator<T> it = this.iterable.iterator();
        return new CloseableIterator<T>(){
            public T next;
            public T current;
            public long count;

            @Override
            public boolean hasNext() {
                this.loadNext();
                if (this.next == null) {
                    this.close();
                }
                return this.next != null;
            }

            @Override
            public T next() {
                this.loadNext();
                this.current = this.next;
                this.next = null;
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                CloseableUtils.closeQuietly(it);
                DefaultGraphQueryIterable.this.close();
            }

            private void loadNext() {
                if (this.next != null) {
                    return;
                }
                if (!iterateAll && DefaultGraphQueryIterable.this.parameters.getLimit() != null && this.count >= DefaultGraphQueryIterable.this.parameters.getSkip() + DefaultGraphQueryIterable.this.parameters.getLimit()) {
                    return;
                }
                while (it.hasNext()) {
                    Element elem = (Element)it.next();
                    boolean match = true;
                    if (DefaultGraphQueryIterable.this.evaluateHasContainers) {
                        for (QueryBase.HasContainer has : DefaultGraphQueryIterable.this.parameters.getHasContainers()) {
                            if (has.isMatch(elem)) continue;
                            match = false;
                            break;
                        }
                        if (elem instanceof Edge && DefaultGraphQueryIterable.this.parameters.getEdgeLabels().size() > 0) {
                            Edge edge = (Edge)elem;
                            if (!DefaultGraphQueryIterable.this.parameters.getEdgeLabels().contains(edge.getLabel())) {
                                match = false;
                            }
                        }
                    }
                    if (!match || DefaultGraphQueryIterable.this.evaluateQueryString && DefaultGraphQueryIterable.this.parameters instanceof QueryStringQueryParameters && ((QueryStringQueryParameters)DefaultGraphQueryIterable.this.parameters).getQueryString() != null && !DefaultGraphQueryIterable.this.evaluateQueryString(elem, ((QueryStringQueryParameters)DefaultGraphQueryIterable.this.parameters).getQueryString())) continue;
                    ++this.count;
                    if (!iterateAll && this.count <= DefaultGraphQueryIterable.this.parameters.getSkip()) continue;
                    this.next = elem;
                    break;
                }
            }
        };
    }

    protected boolean evaluateQueryString(Element elem, String queryString) {
        for (Property property : elem.getProperties()) {
            if (!this.evaluateQueryStringOnValue(property.getValue(), queryString)) continue;
            return true;
        }
        return false;
    }

    private boolean evaluateQueryStringOnValue(Object value, String queryString) {
        if (value == null) {
            return false;
        }
        if (queryString.equals("*")) {
            return true;
        }
        String valueString = value.toString().toLowerCase();
        return valueString.contains(queryString.toLowerCase());
    }

    @Override
    public long getTotalHits() {
        return IterableUtils.count(this.iterator(true));
    }

    @Override
    public void close() {
        CloseableUtils.closeQuietly(this.iterable);
    }

    @Override
    public <TResult extends AggregationResult> TResult getAggregationResult(String name, Class<? extends TResult> resultType) {
        throw new VertexiumException("Could not find aggregation with name: " + name);
    }
}

