/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.type;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.vertexium.VertexiumException;
import org.vertexium.type.GeoShape;

public class GeoPoint
implements Serializable,
GeoShape,
Comparable<GeoPoint> {
    private static final long serialVersionUID = 1L;
    private static final double COMPARE_TOLERANCE = 1.0E-5;
    private static double EARTH_RADIUS = 6371.0;
    private static final Pattern HOUR_MIN_SECOND_PATTERN = Pattern.compile("\\s*(-)?([0-9\\.]+)\u00b0(\\s*([0-9\\.]+)'(\\s*([0-9\\.]+)\")?)?");
    private static final Pattern WITH_DESCRIPTION_PATTERN = Pattern.compile("(.*)\\[(.*)\\]");
    private double latitude;
    private double longitude;
    private Double altitude;
    private String description;

    protected GeoPoint() {
        this.latitude = 0.0;
        this.longitude = 0.0;
        this.altitude = null;
        this.description = null;
    }

    public GeoPoint(double latitude, double longitude, Double altitude, String description) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.description = description;
    }

    public GeoPoint(double latitude, double longitude, Double altitude) {
        this(latitude, longitude, altitude, null);
    }

    public GeoPoint(double latitude, double longitude) {
        this(latitude, longitude, null, null);
    }

    public GeoPoint(double latitude, double longitude, String description) {
        this(latitude, longitude, null, description);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "(" + this.getLatitude() + ", " + this.getLongitude() + ")";
    }

    @Override
    public boolean within(GeoShape geoShape) {
        throw new VertexiumException("Not implemented for argument type " + geoShape.getClass().getName());
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.latitude) ^ Double.doubleToLongBits(this.latitude) >>> 32);
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.longitude) ^ Double.doubleToLongBits(this.longitude) >>> 32);
        hash = 47 * hash + (this.altitude != null ? this.altitude.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoPoint other = (GeoPoint)obj;
        if (Math.abs(GeoPoint.distanceBetween(this, other)) > 1.0E-4) {
            return false;
        }
        return this.altitude == other.altitude || this.altitude != null && this.altitude.equals(other.altitude);
    }

    public static double distanceBetween(GeoPoint geoPoint1, GeoPoint geoPoint2) {
        return GeoPoint.distanceBetween(geoPoint1.getLatitude(), geoPoint1.getLongitude(), geoPoint2.getLatitude(), geoPoint2.getLongitude());
    }

    public static double distanceBetween(double latitude1, double longitude1, double latitude2, double longitude2) {
        double dLat = GeoPoint.toRadians(latitude2 - latitude1);
        double dLon = GeoPoint.toRadians(longitude2 - longitude1);
        latitude1 = GeoPoint.toRadians(latitude1);
        latitude2 = GeoPoint.toRadians(latitude2);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0) * Math.cos(latitude1) * Math.cos(latitude2);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return EARTH_RADIUS * c;
    }

    private static double toRadians(double v) {
        return v * Math.PI / 180.0;
    }

    @Override
    public int compareTo(GeoPoint other) {
        int i = GeoPoint.compare(this.getLatitude(), other.getLatitude());
        if (i != 0) {
            return i;
        }
        i = GeoPoint.compare(this.getLongitude(), other.getLongitude());
        if (i != 0) {
            return i;
        }
        if (this.getAltitude() != null && other.getAltitude() != null) {
            return GeoPoint.compare(this.getAltitude(), other.getAltitude());
        }
        if (this.getAltitude() != null) {
            return 1;
        }
        if (other.getAltitude() != null) {
            return -1;
        }
        return 0;
    }

    private static int compare(double d1, double d2) {
        if (Math.abs(d1 - d2) < 1.0E-5) {
            return 0;
        }
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        return 0;
    }

    public static GeoPoint parse(String str) {
        String description;
        Matcher m = WITH_DESCRIPTION_PATTERN.matcher(str);
        if (m.matches()) {
            description = m.group(1).trim();
            str = m.group(2).trim();
        } else {
            description = null;
        }
        String[] parts = str.split(",");
        if (parts.length < 2) {
            throw new VertexiumException("Too few parts to GeoPoint string. Expected at least 2 found " + parts.length + " for string: " + str);
        }
        if (parts.length >= 4) {
            throw new VertexiumException("Too many parts to GeoPoint string. Expected less than or equal to 3 found " + parts.length + " for string: " + str);
        }
        double latitude = GeoPoint.parsePart(parts[0]);
        double longitude = GeoPoint.parsePart(parts[1]);
        Double altitude = null;
        if (parts.length >= 3) {
            altitude = Double.parseDouble(parts[2]);
        }
        return new GeoPoint(latitude, longitude, altitude, description);
    }

    private static double parsePart(String part) {
        Matcher m = HOUR_MIN_SECOND_PATTERN.matcher(part);
        if (m.matches()) {
            String deg = m.group(2);
            double result = Double.parseDouble(deg);
            if (m.groupCount() >= 4) {
                String minutes = m.group(4);
                result += Double.parseDouble(minutes) / 60.0;
                if (m.groupCount() >= 6) {
                    String seconds = m.group(6);
                    result += Double.parseDouble(seconds) / 3600.0;
                }
            }
            if (m.group(1) != null && m.group(1).equals("-")) {
                result = -result;
            }
            return result;
        }
        return Double.parseDouble(part);
    }

    public boolean isSouthEastOf(GeoPoint pt) {
        return this.isSouthOf(pt) && this.isEastOf(pt);
    }

    private boolean isEastOf(GeoPoint pt) {
        return this.longitudinalDistanceTo(pt) > 0.0;
    }

    public boolean isSouthOf(GeoPoint pt) {
        return this.getLatitude() < pt.getLatitude();
    }

    public boolean isNorthWestOf(GeoPoint pt) {
        return this.isNorthOf(pt) && this.isWestOf(pt);
    }

    private boolean isWestOf(GeoPoint pt) {
        return this.longitudinalDistanceTo(pt) < 0.0;
    }

    public double longitudinalDistanceTo(GeoPoint pt) {
        double them;
        double result;
        double me = this.getLongitude();
        double d = result = Math.abs(me - (them = pt.getLongitude())) > 180.0 ? them - me : me - them;
        if (result > 180.0) {
            result -= 360.0;
        }
        if (result < -180.0) {
            result += 360.0;
        }
        return result;
    }

    public boolean isNorthOf(GeoPoint pt) {
        return this.getLatitude() > pt.getLatitude();
    }

    public static GeoPoint calculateCenter(List<GeoPoint> geoPoints) {
        double totalLat = 0.0;
        double totalLon = 0.0;
        double totalAlt = 0.0;
        int altitudeCount = 0;
        for (GeoPoint geoPoint : geoPoints) {
            totalLat += geoPoint.getLatitude();
            totalLon += geoPoint.getLongitude();
            if (geoPoint.getAltitude() == null) continue;
            totalAlt += geoPoint.getAltitude().doubleValue();
            ++altitudeCount;
        }
        return new GeoPoint(totalLat / (double)geoPoints.size(), totalLon / (double)geoPoints.size(), totalAlt / (double)altitudeCount);
    }
}

