/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.type;

import org.vertexium.VertexiumException;
import org.vertexium.type.GeoPoint;
import org.vertexium.type.GeoShape;

public class GeoRect
implements GeoShape {
    private final GeoPoint northWest;
    private final GeoPoint southEast;

    public GeoRect(GeoPoint northWest, GeoPoint southEast) {
        this.northWest = northWest;
        this.southEast = southEast;
    }

    @Override
    public boolean within(GeoShape geoShape) {
        if (geoShape instanceof GeoPoint) {
            GeoPoint pt = (GeoPoint)geoShape;
            return pt.isSouthEastOf(this.getNorthWest()) && pt.isNorthWestOf(this.getSouthEast());
        }
        throw new VertexiumException("Not implemented for argument type " + geoShape.getClass().getName());
    }

    public GeoPoint getNorthWest() {
        return this.northWest;
    }

    public GeoPoint getSouthEast() {
        return this.southEast;
    }

    public String toString() {
        return "[" + this.getNorthWest() + "," + this.getSouthEast() + "]";
    }

    public boolean intersects(GeoShape geoShape) {
        if (geoShape instanceof GeoRect) {
            GeoRect rect = (GeoRect)geoShape;
            return this.getNorthWest().isNorthWestOf(rect.getSouthEast()) && this.getSouthEast().isSouthEastOf(rect.getNorthWest());
        }
        throw new VertexiumException("Not implemented for argument type " + geoShape.getClass().getName());
    }
}

