/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.warmer.get;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;

public class GetWarmersResponse
extends ActionResponse {
    private ImmutableOpenMap<String, ImmutableList<IndexWarmersMetaData.Entry>> warmers = ImmutableOpenMap.of();

    GetWarmersResponse(ImmutableOpenMap<String, ImmutableList<IndexWarmersMetaData.Entry>> warmers) {
        this.warmers = warmers;
    }

    GetWarmersResponse() {
    }

    public ImmutableOpenMap<String, ImmutableList<IndexWarmersMetaData.Entry>> warmers() {
        return this.warmers;
    }

    public ImmutableOpenMap<String, ImmutableList<IndexWarmersMetaData.Entry>> getWarmers() {
        return this.warmers();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        ImmutableOpenMap.Builder<String, ImmutableCollection> indexMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ImmutableList.Builder warmerEntryBuilder = ImmutableList.builder();
            for (int j = 0; j < valueSize; ++j) {
                String name = in.readString();
                String[] types = in.readStringArray();
                BytesReference source = in.readBytesReference();
                Boolean queryCache = null;
                if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
                    queryCache = in.readOptionalBoolean();
                }
                warmerEntryBuilder.add(new IndexWarmersMetaData.Entry(name, types, queryCache, source));
            }
            indexMapBuilder.put(key, warmerEntryBuilder.build());
        }
        this.warmers = indexMapBuilder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.warmers.size());
        for (ObjectObjectCursor<String, ImmutableList<IndexWarmersMetaData.Entry>> objectObjectCursor : this.warmers) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((ImmutableList)objectObjectCursor.value).size());
            for (IndexWarmersMetaData.Entry warmerEntry : (ImmutableList)objectObjectCursor.value) {
                out.writeString(warmerEntry.name());
                out.writeStringArray(warmerEntry.types());
                out.writeBytesReference(warmerEntry.source());
                if (!out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) continue;
                out.writeOptionalBoolean(warmerEntry.queryCache());
            }
        }
    }
}

