/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.HashSet;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ElasticsearchWrapperException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.TransportShardReplicationOperationAction;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class TransportShardBulkAction
extends TransportShardReplicationOperationAction<BulkShardRequest, BulkShardRequest, BulkShardResponse> {
    private static final String OP_TYPE_UPDATE = "update";
    private static final String OP_TYPE_DELETE = "delete";
    public static final String ACTION_NAME = "indices:data/write/bulk[s]";
    private final MappingUpdatedAction mappingUpdatedAction;
    private final UpdateHelper updateHelper;
    private final boolean allowIdGeneration;

    @Inject
    public TransportShardBulkAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, MappingUpdatedAction mappingUpdatedAction, UpdateHelper updateHelper, ActionFilters actionFilters) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters);
        this.mappingUpdatedAction = mappingUpdatedAction;
        this.updateHelper = updateHelper;
        this.allowIdGeneration = settings.getAsBoolean("action.allow_id_generation", (Boolean)true);
    }

    @Override
    protected String executor() {
        return "bulk";
    }

    @Override
    protected boolean checkWriteConsistency() {
        return true;
    }

    @Override
    protected TransportRequestOptions transportOptions() {
        return BulkAction.INSTANCE.transportOptions(this.settings);
    }

    @Override
    protected BulkShardRequest newRequestInstance() {
        return new BulkShardRequest();
    }

    @Override
    protected BulkShardRequest newReplicaRequestInstance() {
        return new BulkShardRequest();
    }

    @Override
    protected BulkShardResponse newResponseInstance() {
        return new BulkShardResponse();
    }

    @Override
    protected boolean resolveIndex() {
        return false;
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, TransportShardReplicationOperationAction.InternalRequest request) {
        return clusterState.routingTable().index(request.concreteIndex()).shard(((BulkShardRequest)request.request()).shardId()).shardsIt();
    }

    @Override
    protected TransportShardReplicationOperationAction.PrimaryResponse<BulkShardResponse, BulkShardRequest> shardOperationOnPrimary(ClusterState clusterState, TransportShardReplicationOperationAction.PrimaryOperationRequest shardRequest) {
        BulkShardRequest request = (BulkShardRequest)shardRequest.request;
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        IndexShard indexShard = indexService.shardSafe(shardRequest.shardId.id());
        Engine.IndexingOperation[] ops = null;
        HashSet<String> mappingTypesToUpdate = Sets.newHashSet();
        long[] preVersions = new long[request.items().length];
        VersionType[] preVersionTypes = new VersionType[request.items().length];
        for (int requestIndex = 0; requestIndex < request.items().length; ++requestIndex) {
            BulkItemRequest item;
            block58: {
                item = request.items()[requestIndex];
                if (item.request() instanceof IndexRequest) {
                    IndexRequest indexRequest = (IndexRequest)item.request();
                    preVersions[requestIndex] = indexRequest.version();
                    preVersionTypes[requestIndex] = indexRequest.versionType();
                    try {
                        try {
                            WriteResult result = this.shardIndexOperation(request, indexRequest, clusterState, indexShard, true);
                            IndexResponse indexResponse = (IndexResponse)result.response();
                            this.setResponse(item, new BulkItemResponse(item.id(), indexRequest.opType().lowercase(), indexResponse));
                            if (result.mappingTypeToUpdate != null) {
                                mappingTypesToUpdate.add(result.mappingTypeToUpdate);
                            }
                            if (result.op == null) break block58;
                            if (ops == null) {
                                ops = new Engine.IndexingOperation[request.items().length];
                            }
                            ops[requestIndex] = result.op;
                        }
                        catch (WriteFailure e) {
                            if (e.mappingTypeToUpdate != null) {
                                mappingTypesToUpdate.add(e.mappingTypeToUpdate);
                            }
                            throw e.getCause();
                        }
                    }
                    catch (Throwable e) {
                        if (this.retryPrimaryException(e)) {
                            for (int j = 0; j < requestIndex; ++j) {
                                this.applyVersion(request.items()[j], preVersions[j], preVersionTypes[j]);
                            }
                            for (String mappingTypeToUpdate : mappingTypesToUpdate) {
                                DocumentMapper docMapper = indexService.mapperService().documentMapper(mappingTypeToUpdate);
                                if (docMapper == null) continue;
                                this.mappingUpdatedAction.updateMappingOnMaster(indexService.index().name(), docMapper, indexService.indexUUID());
                            }
                            throw (ElasticsearchException)e;
                        }
                        if (e instanceof ElasticsearchException && ((ElasticsearchException)e).status() == RestStatus.CONFLICT) {
                            this.logger.trace("{} failed to execute bulk item (index) {}", e, shardRequest.shardId, indexRequest);
                        } else {
                            this.logger.debug("{} failed to execute bulk item (index) {}", e, shardRequest.shardId, indexRequest);
                        }
                        if (item.getPrimaryResponse() != null && this.isConflictException(e)) {
                            this.setResponse(item, item.getPrimaryResponse());
                            break block58;
                        }
                        this.setResponse(item, new BulkItemResponse(item.id(), indexRequest.opType().lowercase(), new BulkItemResponse.Failure(request.index(), indexRequest.type(), indexRequest.id(), e)));
                    }
                } else if (item.request() instanceof DeleteRequest) {
                    DeleteRequest deleteRequest = (DeleteRequest)item.request();
                    preVersions[requestIndex] = deleteRequest.version();
                    preVersionTypes[requestIndex] = deleteRequest.versionType();
                    try {
                        DeleteResponse deleteResponse = (DeleteResponse)this.shardDeleteOperation(request, deleteRequest, indexShard).response();
                        this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_DELETE, deleteResponse));
                    }
                    catch (Throwable e) {
                        if (this.retryPrimaryException(e)) {
                            for (int j = 0; j < requestIndex; ++j) {
                                this.applyVersion(request.items()[j], preVersions[j], preVersionTypes[j]);
                            }
                            throw (ElasticsearchException)e;
                        }
                        if (e instanceof ElasticsearchException && ((ElasticsearchException)e).status() == RestStatus.CONFLICT) {
                            this.logger.trace("{} failed to execute bulk item (delete) {}", e, shardRequest.shardId, deleteRequest);
                        } else {
                            this.logger.debug("{} failed to execute bulk item (delete) {}", e, shardRequest.shardId, deleteRequest);
                        }
                        if (item.getPrimaryResponse() != null && this.isConflictException(e)) {
                            this.setResponse(item, item.getPrimaryResponse());
                            break block58;
                        }
                        this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_DELETE, new BulkItemResponse.Failure(request.index(), deleteRequest.type(), deleteRequest.id(), e)));
                    }
                } else if (item.request() instanceof UpdateRequest) {
                    UpdateRequest updateRequest = (UpdateRequest)item.request();
                    preVersions[requestIndex] = updateRequest.version();
                    preVersionTypes[requestIndex] = updateRequest.versionType();
                    for (int updateAttemptsCount = 0; updateAttemptsCount <= updateRequest.retryOnConflict(); ++updateAttemptsCount) {
                        IndexRequest indexRequest;
                        UpdateResult updateResult;
                        try {
                            updateResult = this.shardUpdateOperation(clusterState, request, updateRequest, indexShard);
                        }
                        catch (Throwable t) {
                            updateResult = new UpdateResult(null, null, false, t, null);
                        }
                        if (updateResult.success()) {
                            switch (updateResult.result.operation()) {
                                case UPSERT: 
                                case INDEX: {
                                    WriteResult result = updateResult.writeResult;
                                    indexRequest = (IndexRequest)updateResult.request();
                                    BytesReference indexSourceAsBytes = indexRequest.source();
                                    IndexResponse indexResponse = (IndexResponse)result.response();
                                    UpdateResponse updateResponse = new UpdateResponse(indexResponse.getIndex(), indexResponse.getType(), indexResponse.getId(), indexResponse.getVersion(), indexResponse.isCreated());
                                    if (updateRequest.fields() != null && updateRequest.fields().length > 0) {
                                        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(indexSourceAsBytes, true);
                                        updateResponse.setGetResult(this.updateHelper.extractGetResult(updateRequest, ((BulkShardRequest)shardRequest.request).index(), indexResponse.getVersion(), sourceAndContent.v2(), sourceAndContent.v1(), indexSourceAsBytes));
                                    }
                                    BulkItemRequest bulkItemRequest = new BulkItemRequest(request.items()[requestIndex].id(), indexRequest);
                                    request.items()[requestIndex] = bulkItemRequest;
                                    item = bulkItemRequest;
                                    this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, updateResponse));
                                    if (result.mappingTypeToUpdate != null) {
                                        mappingTypesToUpdate.add(result.mappingTypeToUpdate);
                                    }
                                    if (result.op == null) break;
                                    if (ops == null) {
                                        ops = new Engine.IndexingOperation[request.items().length];
                                    }
                                    ops[requestIndex] = result.op;
                                    break;
                                }
                                case DELETE: {
                                    DeleteResponse response = (DeleteResponse)updateResult.writeResult.response();
                                    DeleteRequest deleteRequest = (DeleteRequest)updateResult.request();
                                    UpdateResponse updateResponse = new UpdateResponse(response.getIndex(), response.getType(), response.getId(), response.getVersion(), false);
                                    updateResponse.setGetResult(this.updateHelper.extractGetResult(updateRequest, ((BulkShardRequest)shardRequest.request).index(), response.getVersion(), updateResult.result.updatedSourceAsMap(), updateResult.result.updateSourceContentType(), null));
                                    BulkItemRequest bulkItemRequest = new BulkItemRequest(request.items()[requestIndex].id(), deleteRequest);
                                    request.items()[requestIndex] = bulkItemRequest;
                                    item = bulkItemRequest;
                                    this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, updateResponse));
                                    break;
                                }
                                case NONE: {
                                    this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, updateResult.noopResult));
                                    item.setIgnoreOnReplica();
                                }
                            }
                            break;
                        }
                        if (!updateResult.failure()) continue;
                        Throwable t = updateResult.error;
                        if (updateResult.retry) {
                            if (updateAttemptsCount < updateRequest.retryOnConflict()) continue;
                            this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, new BulkItemResponse.Failure(request.index(), updateRequest.type(), updateRequest.id(), t)));
                            continue;
                        }
                        if (this.retryPrimaryException(t)) {
                            for (int j = 0; j < requestIndex; ++j) {
                                this.applyVersion(request.items()[j], preVersions[j], preVersionTypes[j]);
                            }
                            throw (ElasticsearchException)t;
                        }
                        if (item.getPrimaryResponse() != null && this.isConflictException(t)) {
                            this.setResponse(item, item.getPrimaryResponse());
                            break;
                        }
                        if (updateResult.result == null) {
                            this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, new BulkItemResponse.Failure(((BulkShardRequest)shardRequest.request).index(), updateRequest.type(), updateRequest.id(), t)));
                            break;
                        }
                        switch (updateResult.result.operation()) {
                            case UPSERT: 
                            case INDEX: {
                                indexRequest = (IndexRequest)updateResult.request();
                                if (t instanceof ElasticsearchException && ((ElasticsearchException)t).status() == RestStatus.CONFLICT) {
                                    this.logger.trace("{} failed to execute bulk item (index) {}", t, shardRequest.shardId, indexRequest);
                                } else {
                                    this.logger.debug("{} failed to execute bulk item (index) {}", t, shardRequest.shardId, indexRequest);
                                }
                                this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, new BulkItemResponse.Failure(request.index(), indexRequest.type(), indexRequest.id(), t)));
                                break;
                            }
                            case DELETE: {
                                DeleteRequest deleteRequest = (DeleteRequest)updateResult.request();
                                if (t instanceof ElasticsearchException && ((ElasticsearchException)t).status() == RestStatus.CONFLICT) {
                                    this.logger.trace("{} failed to execute bulk item (delete) {}", t, shardRequest.shardId, deleteRequest);
                                } else {
                                    this.logger.debug("{} failed to execute bulk item (delete) {}", t, shardRequest.shardId, deleteRequest);
                                }
                                this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_DELETE, new BulkItemResponse.Failure(request.index(), deleteRequest.type(), deleteRequest.id(), t)));
                            }
                        }
                        break;
                    }
                }
            }
            assert (item.getPrimaryResponse() != null);
            assert (preVersionTypes[requestIndex] != null);
        }
        for (String mappingTypToUpdate : mappingTypesToUpdate) {
            DocumentMapper docMapper = indexService.mapperService().documentMapper(mappingTypToUpdate);
            if (docMapper == null) continue;
            this.mappingUpdatedAction.updateMappingOnMaster(indexService.index().name(), docMapper, indexService.indexUUID());
        }
        if (request.refresh()) {
            try {
                indexShard.refresh(new Engine.Refresh("refresh_flag_bulk").force(false));
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        BulkItemResponse[] responses = new BulkItemResponse[request.items().length];
        BulkItemRequest[] items = request.items();
        for (int i = 0; i < items.length; ++i) {
            responses[i] = items[i].getPrimaryResponse();
        }
        BulkShardResponse response = new BulkShardResponse(shardRequest.shardId, responses);
        return new TransportShardReplicationOperationAction.PrimaryResponse<BulkShardResponse, BulkShardRequest>((BulkShardRequest)shardRequest.request, response, ops);
    }

    private void setResponse(BulkItemRequest request, BulkItemResponse response) {
        request.setPrimaryResponse(response);
        if (response.isFailed()) {
            request.setIgnoreOnReplica();
        }
    }

    private WriteResult shardIndexOperation(BulkShardRequest request, IndexRequest indexRequest, ClusterState clusterState, IndexShard indexShard, boolean processed) {
        boolean created;
        Engine.IndexingOperation op;
        long version;
        MappingMetaData mappingMd = clusterState.metaData().index(request.index()).mappingOrDefault(indexRequest.type());
        if (mappingMd != null && mappingMd.routing().required() && indexRequest.routing() == null) {
            throw new RoutingMissingException(request.index(), indexRequest.type(), indexRequest.id());
        }
        if (!processed) {
            indexRequest.process(clusterState.metaData(), mappingMd, this.allowIdGeneration, request.index());
        }
        SourceToParse sourceToParse = SourceToParse.source(SourceToParse.Origin.PRIMARY, indexRequest.source()).type(indexRequest.type()).id(indexRequest.id()).routing(indexRequest.routing()).parent(indexRequest.parent()).timestamp(indexRequest.timestamp()).ttl(indexRequest.ttl());
        String mappingTypeToUpdate = null;
        try {
            if (indexRequest.opType() == IndexRequest.OpType.INDEX) {
                Engine.Index index = indexShard.prepareIndex(sourceToParse, indexRequest.version(), indexRequest.versionType(), Engine.Operation.Origin.PRIMARY, request.canHaveDuplicates() || indexRequest.canHaveDuplicates());
                if (index.parsedDoc().mappingsModified()) {
                    mappingTypeToUpdate = indexRequest.type();
                }
                indexShard.index(index);
                version = index.version();
                op = index;
                created = index.created();
            } else {
                Engine.Create create = indexShard.prepareCreate(sourceToParse, indexRequest.version(), indexRequest.versionType(), Engine.Operation.Origin.PRIMARY, request.canHaveDuplicates() || indexRequest.canHaveDuplicates(), indexRequest.autoGeneratedId());
                if (create.parsedDoc().mappingsModified()) {
                    mappingTypeToUpdate = indexRequest.type();
                }
                indexShard.create(create);
                version = create.version();
                op = create;
                created = true;
            }
            indexRequest.versionType(indexRequest.versionType().versionTypeForReplicationAndRecovery());
            indexRequest.version(version);
        }
        catch (Throwable t) {
            throw new WriteFailure(t, mappingTypeToUpdate);
        }
        assert (indexRequest.versionType().validateVersionForWrites(indexRequest.version()));
        IndexResponse indexResponse = new IndexResponse(request.index(), indexRequest.type(), indexRequest.id(), version, created);
        return new WriteResult(indexResponse, mappingTypeToUpdate, op);
    }

    private WriteResult shardDeleteOperation(BulkShardRequest request, DeleteRequest deleteRequest, IndexShard indexShard) {
        Engine.Delete delete = indexShard.prepareDelete(deleteRequest.type(), deleteRequest.id(), deleteRequest.version(), deleteRequest.versionType(), Engine.Operation.Origin.PRIMARY);
        indexShard.delete(delete);
        deleteRequest.versionType(delete.versionType().versionTypeForReplicationAndRecovery());
        deleteRequest.version(delete.version());
        assert (deleteRequest.versionType().validateVersionForWrites(deleteRequest.version()));
        DeleteResponse deleteResponse = new DeleteResponse(request.index(), deleteRequest.type(), deleteRequest.id(), delete.version(), delete.found());
        return new WriteResult(deleteResponse, null, null);
    }

    private UpdateResult shardUpdateOperation(ClusterState clusterState, BulkShardRequest bulkShardRequest, UpdateRequest updateRequest, IndexShard indexShard) {
        UpdateHelper.Result translate = this.updateHelper.prepare(updateRequest, indexShard);
        switch (translate.operation()) {
            case UPSERT: 
            case INDEX: {
                IndexRequest indexRequest = (IndexRequest)translate.action();
                try {
                    WriteResult result = this.shardIndexOperation(bulkShardRequest, indexRequest, clusterState, indexShard, false);
                    return new UpdateResult(translate, indexRequest, result);
                }
                catch (Throwable t) {
                    t = ExceptionsHelper.unwrapCause(t);
                    boolean retry = false;
                    if (t instanceof VersionConflictEngineException || t instanceof DocumentAlreadyExistsException && translate.operation() == UpdateHelper.Operation.UPSERT) {
                        retry = true;
                    }
                    return new UpdateResult(translate, indexRequest, retry, t, null);
                }
            }
            case DELETE: {
                DeleteRequest deleteRequest = (DeleteRequest)translate.action();
                try {
                    WriteResult result = this.shardDeleteOperation(bulkShardRequest, deleteRequest, indexShard);
                    return new UpdateResult(translate, deleteRequest, result);
                }
                catch (Throwable t) {
                    t = ExceptionsHelper.unwrapCause(t);
                    boolean retry = false;
                    if (t instanceof VersionConflictEngineException) {
                        retry = true;
                    }
                    return new UpdateResult(translate, deleteRequest, retry, t, null);
                }
            }
            case NONE: {
                UpdateResponse updateResponse = (UpdateResponse)translate.action();
                indexShard.indexingService().noopUpdate(updateRequest.type());
                return new UpdateResult(translate, updateResponse);
            }
        }
        throw new ElasticsearchIllegalStateException("Illegal update operation " + (Object)((Object)translate.operation()));
    }

    @Override
    protected void shardOperationOnReplica(TransportShardReplicationOperationAction.ReplicaOperationRequest shardRequest) {
        IndexShard indexShard = this.indicesService.indexServiceSafe(shardRequest.shardId.getIndex()).shardSafe(shardRequest.shardId.id());
        BulkShardRequest request = (BulkShardRequest)shardRequest.request;
        for (int i = 0; i < request.items().length; ++i) {
            BulkItemRequest item = request.items()[i];
            if (item == null || item.isIgnoreOnReplica()) continue;
            if (item.request() instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)item.request();
                try {
                    SourceToParse sourceToParse = SourceToParse.source(SourceToParse.Origin.REPLICA, indexRequest.source()).type(indexRequest.type()).id(indexRequest.id()).routing(indexRequest.routing()).parent(indexRequest.parent()).timestamp(indexRequest.timestamp()).ttl(indexRequest.ttl());
                    if (indexRequest.opType() == IndexRequest.OpType.INDEX) {
                        Engine.Index index = indexShard.prepareIndex(sourceToParse, indexRequest.version(), indexRequest.versionType(), Engine.Operation.Origin.REPLICA, request.canHaveDuplicates() || indexRequest.canHaveDuplicates());
                        indexShard.index(index);
                        continue;
                    }
                    Engine.Create create = indexShard.prepareCreate(sourceToParse, indexRequest.version(), indexRequest.versionType(), Engine.Operation.Origin.REPLICA, request.canHaveDuplicates() || indexRequest.canHaveDuplicates(), indexRequest.autoGeneratedId());
                    indexShard.create(create);
                    continue;
                }
                catch (Throwable e) {
                    if (this.ignoreReplicaException(e)) continue;
                    throw e;
                }
            }
            if (!(item.request() instanceof DeleteRequest)) continue;
            DeleteRequest deleteRequest = (DeleteRequest)item.request();
            try {
                Engine.Delete delete = indexShard.prepareDelete(deleteRequest.type(), deleteRequest.id(), deleteRequest.version(), deleteRequest.versionType(), Engine.Operation.Origin.REPLICA);
                indexShard.delete(delete);
                continue;
            }
            catch (Throwable e) {
                if (this.ignoreReplicaException(e)) continue;
                throw e;
            }
        }
        if (request.refresh()) {
            try {
                indexShard.refresh(new Engine.Refresh("refresh_flag_bulk").force(false));
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    private void applyVersion(BulkItemRequest item, long version, VersionType versionType) {
        if (item.request() instanceof IndexRequest) {
            ((IndexRequest)item.request()).version(version).versionType(versionType);
        } else if (item.request() instanceof DeleteRequest) {
            ((DeleteRequest)item.request()).version(version).versionType();
        } else if (item.request() instanceof UpdateRequest) {
            ((UpdateRequest)item.request()).version(version).versionType();
        }
    }

    static class UpdateResult {
        final UpdateHelper.Result result;
        final ActionRequest actionRequest;
        final boolean retry;
        final Throwable error;
        final WriteResult writeResult;
        final UpdateResponse noopResult;

        UpdateResult(UpdateHelper.Result result, ActionRequest actionRequest, boolean retry, Throwable error, WriteResult writeResult) {
            this.result = result;
            this.actionRequest = actionRequest;
            this.retry = retry;
            this.error = error;
            this.writeResult = writeResult;
            this.noopResult = null;
        }

        UpdateResult(UpdateHelper.Result result, ActionRequest actionRequest, WriteResult writeResult) {
            this.result = result;
            this.actionRequest = actionRequest;
            this.writeResult = writeResult;
            this.retry = false;
            this.error = null;
            this.noopResult = null;
        }

        public UpdateResult(UpdateHelper.Result result, UpdateResponse updateResponse) {
            this.result = result;
            this.noopResult = updateResponse;
            this.actionRequest = null;
            this.writeResult = null;
            this.retry = false;
            this.error = null;
        }

        boolean failure() {
            return this.error != null;
        }

        boolean success() {
            return this.noopResult != null || this.writeResult != null;
        }

        <T extends ActionRequest> T request() {
            return (T)this.actionRequest;
        }
    }

    static class WriteFailure
    extends ElasticsearchException
    implements ElasticsearchWrapperException {
        @Nullable
        final String mappingTypeToUpdate;

        WriteFailure(Throwable cause, String mappingTypeToUpdate) {
            super(null, cause);
            assert (cause != null);
            this.mappingTypeToUpdate = mappingTypeToUpdate;
        }
    }

    static class WriteResult {
        final Object response;
        final String mappingTypeToUpdate;
        final Engine.IndexingOperation op;

        WriteResult(Object response, String mappingTypeToUpdate, Engine.IndexingOperation op) {
            this.response = response;
            this.mappingTypeToUpdate = mappingTypeToUpdate;
            this.op = op;
        }

        <T> T response() {
            return (T)this.response;
        }
    }
}

