/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;

public class SettingsFilter
extends AbstractComponent {
    private final CopyOnWriteArrayList<Filter> filters = new CopyOnWriteArrayList();

    @Inject
    public SettingsFilter(Settings settings) {
        super(settings);
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(Filter filter) {
        this.filters.remove(filter);
    }

    public Settings filterSettings(Settings settings) {
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().put(settings);
        for (Filter filter : this.filters) {
            filter.filter(builder);
        }
        return builder.build();
    }

    public static interface Filter {
        public void filter(ImmutableSettings.Builder var1);
    }
}

