/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.search.lookup.IndexFieldTerm;
import org.elasticsearch.search.lookup.TermPosition;

public class PositionIterator
implements Iterator<TermPosition> {
    private static final DocsAndPositionsEnum EMPTY = new EmptyDocsAndPosEnum();
    private boolean resetted = false;
    protected IndexFieldTerm indexFieldTerm;
    protected int freq = -1;
    private int currentPos;
    protected final TermPosition termPosition = new TermPosition();
    private DocsAndPositionsEnum docsAndPos;

    public PositionIterator(IndexFieldTerm indexFieldTerm) {
        this.indexFieldTerm = indexFieldTerm;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove anything from TermPosition iterator.");
    }

    @Override
    public boolean hasNext() {
        return this.currentPos < this.freq;
    }

    @Override
    public TermPosition next() {
        try {
            this.termPosition.position = this.docsAndPos.nextPosition();
            this.termPosition.startOffset = this.docsAndPos.startOffset();
            this.termPosition.endOffset = this.docsAndPos.endOffset();
            this.termPosition.payload = this.docsAndPos.getPayload();
        }
        catch (IOException ex) {
            throw new ElasticsearchException("can not advance iterator", ex);
        }
        ++this.currentPos;
        return this.termPosition;
    }

    public void nextDoc() throws IOException {
        this.resetted = false;
        this.currentPos = 0;
        this.freq = this.indexFieldTerm.tf();
        this.docsAndPos = this.indexFieldTerm.docsEnum instanceof DocsAndPositionsEnum ? (DocsAndPositionsEnum)this.indexFieldTerm.docsEnum : EMPTY;
    }

    public Iterator<TermPosition> reset() {
        if (this.resetted) {
            throw new ElasticsearchException("Cannot iterate twice! If you want to iterate more that once, add _CACHE explicitely.");
        }
        this.resetted = true;
        return this;
    }

    private static final class EmptyDocsAndPosEnum
    extends DocsAndPositionsEnum {
        private EmptyDocsAndPosEnum() {
        }

        public int nextPosition() throws IOException {
            return -1;
        }

        public int startOffset() throws IOException {
            return -1;
        }

        public int endOffset() throws IOException {
            return -1;
        }

        public BytesRef getPayload() throws IOException {
            return null;
        }

        public int freq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public int docID() {
            throw new UnsupportedOperationException();
        }

        public int nextDoc() throws IOException {
            throw new UnsupportedOperationException();
        }

        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long cost() {
            throw new UnsupportedOperationException();
        }
    }
}

