/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.search.suggest.Suggester;

public class SuggestionSearchContext {
    private final Map<String, SuggestionContext> suggestions = new LinkedHashMap<String, SuggestionContext>(4);

    public void addSuggestion(String name, SuggestionContext suggestion) {
        this.suggestions.put(name, suggestion);
    }

    public Map<String, SuggestionContext> suggestions() {
        return this.suggestions;
    }

    public static class SuggestionContext {
        private BytesRef text;
        private final Suggester suggester;
        private String field;
        private Analyzer analyzer;
        private int size = 5;
        private int shardSize = -1;
        private int shardId;
        private String index;

        public BytesRef getText() {
            return this.text;
        }

        public void setText(BytesRef text) {
            this.text = text;
        }

        public SuggestionContext(Suggester suggester) {
            this.suggester = suggester;
        }

        public Suggester<SuggestionContext> getSuggester() {
            return this.suggester;
        }

        public Analyzer getAnalyzer() {
            return this.analyzer;
        }

        public void setAnalyzer(Analyzer analyzer) {
            this.analyzer = analyzer;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            if (size <= 0) {
                throw new ElasticsearchIllegalArgumentException("Size must be positive but was: " + size);
            }
            this.size = size;
        }

        public Integer getShardSize() {
            return this.shardSize;
        }

        public void setShardSize(int shardSize) {
            if (shardSize <= 0) {
                throw new ElasticsearchIllegalArgumentException("ShardSize must be positive but was: " + shardSize);
            }
            this.shardSize = shardSize;
        }

        public void setShard(int shardId) {
            this.shardId = shardId;
        }

        public void setIndex(String index) {
            this.index = index;
        }

        public String getIndex() {
            return this.index;
        }

        public int getShard() {
            return this.shardId;
        }
    }
}

