/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.config;

import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryConfigSchema;
import org.openrdf.repository.config.RepositoryImplConfig;
import org.openrdf.repository.config.RepositoryImplConfigBase;

public class RepositoryConfig {
    private String id;
    private String title;
    private RepositoryImplConfig implConfig;

    public RepositoryConfig() {
    }

    public RepositoryConfig(String id) {
        this();
        this.setID(id);
    }

    public RepositoryConfig(String id, RepositoryImplConfig implConfig) {
        this(id);
        this.setRepositoryImplConfig(implConfig);
    }

    public RepositoryConfig(String id, String title) {
        this(id);
        this.setTitle(title);
    }

    public RepositoryConfig(String id, String title, RepositoryImplConfig implConfig) {
        this(id, title);
        this.setRepositoryImplConfig(implConfig);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public RepositoryImplConfig getRepositoryImplConfig() {
        return this.implConfig;
    }

    public void setRepositoryImplConfig(RepositoryImplConfig implConfig) {
        this.implConfig = implConfig;
    }

    public void validate() throws RepositoryConfigException {
        if (this.id == null) {
            throw new RepositoryConfigException("Repository ID missing");
        }
        if (this.implConfig == null) {
            throw new RepositoryConfigException("Repository implementation for repository missing");
        }
        this.implConfig.validate();
    }

    public void export(Graph graph) {
        ValueFactory vf = graph.getValueFactory();
        BNode repositoryNode = vf.createBNode();
        graph.add((Resource)repositoryNode, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY, new Resource[0]);
        if (this.id != null) {
            graph.add((Resource)repositoryNode, RepositoryConfigSchema.REPOSITORYID, (Value)vf.createLiteral(this.id), new Resource[0]);
        }
        if (this.title != null) {
            graph.add((Resource)repositoryNode, RDFS.LABEL, (Value)vf.createLiteral(this.title), new Resource[0]);
        }
        if (this.implConfig != null) {
            Resource implNode = this.implConfig.export(graph);
            graph.add((Resource)repositoryNode, RepositoryConfigSchema.REPOSITORYIMPL, (Value)implNode, new Resource[0]);
        }
    }

    public void parse(Graph graph, Resource repositoryNode) throws RepositoryConfigException {
        try {
            Resource implNode;
            Literal titleLit;
            Literal idLit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)repositoryNode, (URI)RepositoryConfigSchema.REPOSITORYID);
            if (idLit != null) {
                this.setID(idLit.getLabel());
            }
            if ((titleLit = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)repositoryNode, (URI)RDFS.LABEL)) != null) {
                this.setTitle(titleLit.getLabel());
            }
            if ((implNode = GraphUtil.getOptionalObjectResource((Graph)graph, (Resource)repositoryNode, (URI)RepositoryConfigSchema.REPOSITORYIMPL)) != null) {
                this.setRepositoryImplConfig(RepositoryImplConfigBase.create(graph, implNode));
            }
        }
        catch (GraphUtilException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }

    public static RepositoryConfig create(Graph graph, Resource repositoryNode) throws RepositoryConfigException {
        RepositoryConfig config = new RepositoryConfig();
        config.parse(graph, repositoryNode);
        return config;
    }
}

