/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.migration.HRegionInfo090x;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;

public class MetaMigrationRemovingHTD {
    private static final Log LOG = LogFactory.getLog(MetaMigrationRemovingHTD.class);

    public static Set<HTableDescriptor> updateMetaWithNewRegionInfo(MasterServices masterServices) throws IOException {
        MigratingVisitor v = new MigratingVisitor(masterServices);
        MetaReader.fullScan(masterServices.getCatalogTracker(), v);
        MetaMigrationRemovingHTD.updateRootWithMetaMigrationStatus(masterServices.getCatalogTracker());
        return v.htds;
    }

    static Set<HTableDescriptor> updateRootWithNewRegionInfo(MasterServices masterServices) throws IOException {
        MigratingVisitor v = new MigratingVisitor(masterServices);
        MetaReader.fullScan(masterServices.getCatalogTracker(), (MetaReader.Visitor)v, null, true);
        return v.htds;
    }

    static void checkSplit(Result r, Put p, byte[] which) throws IOException {
        byte[] hriSplitBytes = MetaMigrationRemovingHTD.getBytes(r, which);
        if (!MetaMigrationRemovingHTD.isMigrated(hriSplitBytes)) {
            HRegionInfo hri = Writables.getHRegionInfo(hriSplitBytes);
            p.add(HConstants.CATALOG_FAMILY, which, Writables.getBytes((Writable)hri));
        }
    }

    static byte[] getBytes(Result r, byte[] qualifier) {
        byte[] hriBytes = r.getValue(HConstants.CATALOG_FAMILY, qualifier);
        if (hriBytes == null || hriBytes.length <= 0) {
            return null;
        }
        return hriBytes;
    }

    static HRegionInfo090x get090HRI(Result r, byte[] qualifier) throws IOException {
        byte[] hriBytes = r.getValue(HConstants.CATALOG_FAMILY, qualifier);
        if (hriBytes == null || hriBytes.length <= 0) {
            return null;
        }
        if (MetaMigrationRemovingHTD.isMigrated(hriBytes)) {
            return null;
        }
        return MetaMigrationRemovingHTD.getHRegionInfo090x(hriBytes);
    }

    static boolean isMigrated(byte[] hriBytes) {
        if (hriBytes == null || hriBytes.length <= 0) {
            return true;
        }
        if (hriBytes[0] == 1) {
            return true;
        }
        if (hriBytes[0] == 0) {
            return false;
        }
        assert (false) : "Unexpected version; bytes=" + Bytes.toStringBinary(hriBytes);
        return true;
    }

    public static void migrateRootAndMeta(MasterServices masterServices) throws IOException {
        MetaMigrationRemovingHTD.updateRootWithNewRegionInfo(masterServices);
        MetaMigrationRemovingHTD.updateMetaWithNewRegionInfo(masterServices);
    }

    public static void updateRootWithMetaMigrationStatus(CatalogTracker catalogTracker) throws IOException {
        Put p = new Put(HRegionInfo.FIRST_META_REGIONINFO.getRegionName());
        MetaEditor.putToRootTable(catalogTracker, MetaMigrationRemovingHTD.setMetaVersion(p));
        LOG.info((Object)"Updated -ROOT- meta version=0");
    }

    static Put setMetaVersion(Put p) {
        p.add(HConstants.CATALOG_FAMILY, HConstants.META_VERSION_QUALIFIER, Bytes.toBytes((short)0));
        return p;
    }

    public static boolean isMetaHRIUpdated(MasterServices services) throws IOException {
        List<Result> results = MetaReader.fullScanOfRoot(services.getCatalogTracker());
        if (results == null || results.isEmpty()) {
            LOG.info((Object)"Not migrated");
            return false;
        }
        Result r = results.get(0);
        short version = MetaMigrationRemovingHTD.getMetaVersion(r);
        boolean migrated = version >= 0;
        LOG.info((Object)("Meta version=" + version + "; migrated=" + migrated));
        return migrated;
    }

    static short getMetaVersion(Result r) {
        byte[] value = r.getValue(HConstants.CATALOG_FAMILY, HConstants.META_VERSION_QUALIFIER);
        return value == null || value.length <= 0 ? (short)-1 : Bytes.toShort(value);
    }

    public static boolean updateMetaWithNewHRI(MasterServices services) throws IOException {
        if (MetaMigrationRemovingHTD.isMetaHRIUpdated(services)) {
            LOG.info((Object)"ROOT/Meta already up-to date with new HRI.");
            return true;
        }
        LOG.info((Object)"Meta has HRI with HTDs. Updating meta now.");
        try {
            MetaMigrationRemovingHTD.migrateRootAndMeta(services);
            LOG.info((Object)"ROOT and Meta updated with new HRI.");
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException("Update ROOT/Meta with new HRI failed.Master startup aborted.");
        }
    }

    public static HRegionInfo090x getHRegionInfo090x(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        HRegionInfo090x hri = null;
        try {
            hri = (HRegionInfo090x)Writables.getWritable(bytes, (Writable)new HRegionInfo090x());
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Failed deserialize as a 090 HRegionInfo); bytes=" + Bytes.toStringBinary(bytes)), (Throwable)ioe);
        }
        return hri;
    }

    static class MigratingVisitor
    implements MetaReader.Visitor {
        private final MasterServices services;
        final Set<HTableDescriptor> htds = new HashSet<HTableDescriptor>();

        MigratingVisitor(MasterServices services) {
            this.services = services;
        }

        @Override
        public boolean visit(Result r) throws IOException {
            if (r == null || r.isEmpty()) {
                return true;
            }
            byte[] hriBytes = MetaMigrationRemovingHTD.getBytes(r, HConstants.REGIONINFO_QUALIFIER);
            if (MetaMigrationRemovingHTD.isMigrated(hriBytes)) {
                return true;
            }
            HRegionInfo090x hri090 = MetaMigrationRemovingHTD.getHRegionInfo090x(hriBytes);
            HTableDescriptor htd = hri090.getTableDesc();
            if (htd == null) {
                LOG.warn((Object)("A 090 HRI has null HTD? Continuing; " + hri090.toString()));
                return true;
            }
            if (!this.htds.contains(htd)) {
                this.services.getMasterFileSystem().createTableDescriptor(htd);
                this.htds.add(htd);
            }
            HRegionInfo hri = new HRegionInfo(hri090);
            Put p = new Put(hri.getRegionName());
            p.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
            MetaMigrationRemovingHTD.checkSplit(r, p, HConstants.SPLITA_QUALIFIER);
            MetaMigrationRemovingHTD.checkSplit(r, p, HConstants.SPLITB_QUALIFIER);
            MetaEditor.putToCatalogTable(this.services.getCatalogTracker(), p);
            LOG.info((Object)("Migrated " + Bytes.toString(p.getRow())));
            return true;
        }
    }
}

