/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class FuzzyRowFilter
extends FilterBase {
    private List<Pair<byte[], byte[]>> fuzzyKeysData;
    private boolean done = false;

    public FuzzyRowFilter() {
    }

    public FuzzyRowFilter(List<Pair<byte[], byte[]>> fuzzyKeysData) {
        this.fuzzyKeysData = fuzzyKeysData;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue kv) {
        byte[] rowKey = kv.getRow();
        SatisfiesCode bestOption = SatisfiesCode.NO_NEXT;
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            SatisfiesCode satisfiesCode = FuzzyRowFilter.satisfies(rowKey, fuzzyData.getFirst(), fuzzyData.getSecond());
            if (satisfiesCode == SatisfiesCode.YES) {
                return Filter.ReturnCode.INCLUDE;
            }
            if (satisfiesCode != SatisfiesCode.NEXT_EXISTS) continue;
            bestOption = SatisfiesCode.NEXT_EXISTS;
        }
        if (bestOption == SatisfiesCode.NEXT_EXISTS) {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        this.done = true;
        return Filter.ReturnCode.NEXT_ROW;
    }

    @Override
    public KeyValue getNextKeyHint(KeyValue currentKV) {
        byte[] rowKey = currentKV.getRow();
        byte[] nextRowKey = null;
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            byte[] nextRowKeyCandidate = FuzzyRowFilter.getNextForFuzzyRule(rowKey, fuzzyData.getFirst(), fuzzyData.getSecond());
            if (nextRowKeyCandidate == null || nextRowKey != null && Bytes.compareTo(nextRowKeyCandidate, nextRowKey) >= 0) continue;
            nextRowKey = nextRowKeyCandidate;
        }
        if (nextRowKey == null) {
            throw new IllegalStateException("No next row key that satisfies fuzzy exists when getNextKeyHint() is invoked. Filter: " + this.toString() + " currentKV: " + currentKV.toString());
        }
        return KeyValue.createFirstOnRow(nextRowKey);
    }

    @Override
    public boolean filterAllRemaining() {
        return this.done;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.fuzzyKeysData.size());
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            Bytes.writeByteArray(dataOutput, fuzzyData.getFirst());
            Bytes.writeByteArray(dataOutput, fuzzyData.getSecond());
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        int count = dataInput.readInt();
        this.fuzzyKeysData = new ArrayList<Pair<byte[], byte[]>>(count);
        for (int i = 0; i < count; ++i) {
            byte[] keyBytes = Bytes.readByteArray(dataInput);
            byte[] keyMeta = Bytes.readByteArray(dataInput);
            this.fuzzyKeysData.add(new Pair<byte[], byte[]>(keyBytes, keyMeta));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FuzzyRowFilter");
        sb.append("{fuzzyKeysData=");
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            sb.append('{').append(Bytes.toStringBinary(fuzzyData.getFirst())).append(":");
            sb.append(Bytes.toStringBinary(fuzzyData.getSecond())).append('}');
        }
        sb.append("}, ");
        return sb.toString();
    }

    static SatisfiesCode satisfies(byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.satisfies(row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    private static SatisfiesCode satisfies(byte[] row, int offset, int length, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        if (row == null) {
            return SatisfiesCode.YES;
        }
        boolean nextRowKeyCandidateExists = false;
        for (int i = 0; i < fuzzyKeyMeta.length && i < length; ++i) {
            boolean fixedByteIncorrect;
            boolean byteAtPositionFixed = fuzzyKeyMeta[i] == 0;
            boolean bl = fixedByteIncorrect = byteAtPositionFixed && fuzzyKeyBytes[i] != row[i + offset];
            if (fixedByteIncorrect) {
                if (nextRowKeyCandidateExists) {
                    return SatisfiesCode.NEXT_EXISTS;
                }
                boolean rowByteLessThanFixed = (row[i + offset] & 0xFF) < (fuzzyKeyBytes[i] & 0xFF);
                return rowByteLessThanFixed ? SatisfiesCode.NEXT_EXISTS : SatisfiesCode.NO_NEXT;
            }
            if (fuzzyKeyMeta[i] != 1 || FuzzyRowFilter.isMax(fuzzyKeyBytes[i])) continue;
            nextRowKeyCandidateExists = true;
        }
        return SatisfiesCode.YES;
    }

    private static boolean isMax(byte fuzzyKeyByte) {
        return (fuzzyKeyByte & 0xFF) == 255;
    }

    static byte[] getNextForFuzzyRule(byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.getNextForFuzzyRule(row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    private static byte[] getNextForFuzzyRule(byte[] row, int offset, int length, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        int i;
        byte[] result = Arrays.copyOf(fuzzyKeyBytes, length > fuzzyKeyBytes.length ? length : fuzzyKeyBytes.length);
        int toInc = -1;
        boolean increased = false;
        for (i = 0; i < result.length; ++i) {
            if (i >= fuzzyKeyMeta.length || fuzzyKeyMeta[i] == 1) {
                result[i] = row[offset + i];
                if (FuzzyRowFilter.isMax(row[i])) continue;
                toInc = i;
                continue;
            }
            if (i >= fuzzyKeyMeta.length || fuzzyKeyMeta[i] != 0) continue;
            if ((row[i + offset] & 0xFF) < (fuzzyKeyBytes[i] & 0xFF)) {
                increased = true;
                break;
            }
            if ((row[i + offset] & 0xFF) > (fuzzyKeyBytes[i] & 0xFF)) break;
        }
        if (!increased) {
            if (toInc < 0) {
                return null;
            }
            int n = toInc;
            result[n] = (byte)(result[n] + 1);
            for (i = toInc + 1; i < result.length; ++i) {
                if (i < fuzzyKeyMeta.length && fuzzyKeyMeta[i] != 1) continue;
                result[i] = 0;
            }
        }
        return result;
    }

    static enum SatisfiesCode {
        YES,
        NEXT_EXISTS,
        NO_NEXT;

    }
}

