/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.FileLink;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
public class HLogLink
extends FileLink {
    public HLogLink(Configuration conf, String serverName, String logName) throws IOException {
        this(FSUtils.getRootDir(conf), serverName, logName);
    }

    public HLogLink(Path rootDir, String serverName, String logName) {
        Path oldLogDir = new Path(rootDir, ".oldlogs");
        Path logDir = new Path(new Path(rootDir, ".logs"), serverName);
        this.setLocations(new Path(logDir, logName), new Path(oldLogDir, logName));
    }

    public HLogLink(Path originPath, Path archivePath) {
        this.setLocations(originPath, archivePath);
    }
}

