/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.Maps;
import com.google.common.collect.MutableClassToInstanceMap;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.ObjectName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.HealthCheckChore;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaMigrationRemovingHTD;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.coprocessor.Exec;
import org.apache.hadoop.hbase.client.coprocessor.ExecResult;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.HMasterRegionInterface;
import org.apache.hadoop.hbase.ipc.ProtocolSignature;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.ActiveMasterManager;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.HMasterCommandLine;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.LoadBalancerFactory;
import org.apache.hadoop.hbase.master.MXBeanImpl;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterDumpServlet;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MasterStatusServlet;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.master.cleaner.LogCleaner;
import org.apache.hadoop.hbase.master.handler.CreateTableHandler;
import org.apache.hadoop.hbase.master.handler.DeleteTableHandler;
import org.apache.hadoop.hbase.master.handler.DisableTableHandler;
import org.apache.hadoop.hbase.master.handler.EnableTableHandler;
import org.apache.hadoop.hbase.master.handler.ModifyTableHandler;
import org.apache.hadoop.hbase.master.handler.ServerShutdownHandler;
import org.apache.hadoop.hbase.master.handler.TableAddFamilyHandler;
import org.apache.hadoop.hbase.master.handler.TableDeleteFamilyHandler;
import org.apache.hadoop.hbase.master.handler.TableModifyFamilyHandler;
import org.apache.hadoop.hbase.master.metrics.MasterMetrics;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.monitoring.MemoryBoundedLogMessageBuffer;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.snapshot.HSnapshotDescription;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.InfoServer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Sleeper;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ClusterId;
import org.apache.hadoop.hbase.zookeeper.ClusterStatusTracker;
import org.apache.hadoop.hbase.zookeeper.DrainingServerTracker;
import org.apache.hadoop.hbase.zookeeper.RegionServerTracker;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.util.VersionInfo;
import org.apache.zookeeper.KeeperException;

public class HMaster
extends HasThread
implements HMasterInterface,
HMasterRegionInterface,
MasterServices,
Server {
    private static final Log LOG = LogFactory.getLog((String)HMaster.class.getName());
    public static final String MASTER = "master";
    private final Configuration conf;
    private InfoServer infoServer;
    private ZooKeeperWatcher zooKeeper;
    private ActiveMasterManager activeMasterManager;
    private RegionServerTracker regionServerTracker;
    private DrainingServerTracker drainingServerTracker;
    private final RpcServer rpcServer;
    private final InetSocketAddress isa;
    private final MasterMetrics metrics;
    private MasterFileSystem fileSystemManager;
    private ServerManager serverManager;
    AssignmentManager assignmentManager;
    private CatalogTracker catalogTracker;
    private ClusterStatusTracker clusterStatusTracker;
    private MemoryBoundedLogMessageBuffer rsFatals;
    private volatile boolean stopped = false;
    private volatile boolean abort = false;
    private volatile boolean isActiveMaster = false;
    volatile boolean initialized = false;
    private volatile boolean serverShutdownHandlerEnabled = false;
    private volatile boolean shouldSplitMetaSeparately;
    org.apache.hadoop.hbase.executor.ExecutorService executorService;
    private LoadBalancer balancer;
    private Thread balancerChore;
    private volatile boolean balanceSwitch = true;
    private CatalogJanitor catalogJanitorChore;
    private LogCleaner logCleaner;
    private HFileCleaner hfileCleaner;
    private MasterCoprocessorHost cpHost;
    private final ServerName serverName;
    private TableDescriptors tableDescriptors;
    private long masterStartTime;
    private long masterActiveTime;
    private SnapshotManager snapshotManager;
    private ObjectName mxBean = null;
    private ClassToInstanceMap<CoprocessorProtocol> protocolHandlers = MutableClassToInstanceMap.create();
    private Map<String, Class<? extends CoprocessorProtocol>> protocolHandlerNames = Maps.newHashMap();
    private HealthCheckChore healthCheckChore;
    private boolean waitingOnLogSplitting = false;
    private volatile boolean initializationBeforeMetaAssignment = false;
    private List<ZooKeeperListener> registeredZKListenersBeforeRecovery;
    private Sleeper stopSleeper = new Sleeper(1000, this);

    public HMaster(Configuration conf) throws IOException, KeeperException, InterruptedException {
        this.conf = new Configuration(conf);
        this.conf.setFloat("hfile.block.cache.size", 0.0f);
        HConnectionManager.setServerSideHConnectionRetries(this.conf, LOG);
        String hostname = Strings.domainNamePointerToHostName(DNS.getDefaultHost((String)conf.get("hbase.master.dns.interface", "default"), (String)conf.get("hbase.master.dns.nameserver", "default")));
        int port = conf.getInt("hbase.master.port", 60000);
        InetSocketAddress initialIsa = new InetSocketAddress(hostname, port);
        if (initialIsa.getAddress() == null) {
            throw new IllegalArgumentException("Failed resolve of hostname " + initialIsa);
        }
        String bindAddress = conf.get("hbase.master.ipc.address");
        if (bindAddress != null && (initialIsa = new InetSocketAddress(bindAddress, port)).getAddress() == null) {
            throw new IllegalArgumentException("Failed resolve of bind address " + initialIsa);
        }
        int numHandlers = conf.getInt("hbase.master.handler.count", conf.getInt("hbase.regionserver.handler.count", 25));
        this.rpcServer = HBaseRPC.getServer(this, new Class[]{HMasterInterface.class, HMasterRegionInterface.class}, initialIsa.getHostName(), initialIsa.getPort(), numHandlers, 0, conf.getBoolean("hbase.rpc.verbose", false), conf, 0);
        this.isa = this.rpcServer.getListenerAddress();
        this.serverName = new ServerName(hostname, this.isa.getPort(), System.currentTimeMillis());
        this.rsFatals = new MemoryBoundedLogMessageBuffer(conf.getLong("hbase.master.buffer.for.rs.fatals", 0x100000L));
        ZKUtil.loginClient(this.conf, "hbase.zookeeper.client.keytab.file", "hbase.zookeeper.client.kerberos.principal", this.isa.getHostName());
        User.login(conf, "hbase.master.keytab.file", "hbase.master.kerberos.principal", this.isa.getHostName());
        this.setName("master-" + this.serverName.toString());
        Replication.decorateMasterConfiguration(this.conf);
        if (this.conf.get("mapred.task.id") == null) {
            this.conf.set("mapred.task.id", "hb_m_" + this.serverName.toString());
        }
        this.zooKeeper = new ZooKeeperWatcher(conf, "master:" + this.isa.getPort(), this, true);
        this.rpcServer.startThreads();
        this.metrics = new MasterMetrics(this.getServerName().toString());
        int sleepTime = this.conf.getInt("hbase.node.health.script.frequency", 10000);
        if (this.isHealthCheckerConfigured()) {
            this.healthCheckChore = new HealthCheckChore(sleepTime, this, this.getConfiguration());
        }
        this.shouldSplitMetaSeparately = conf.getBoolean("hbase.regionserver.separate.hlog.for.meta", false);
        this.waitingOnLogSplitting = this.conf.getBoolean("hbase.master.wait.for.log.splitting", false);
    }

    private static void stallIfBackupMaster(Configuration c, ActiveMasterManager amm) throws InterruptedException {
        if (!c.getBoolean("hbase.master.backup", false)) {
            return;
        }
        LOG.debug((Object)"HMaster started in backup mode.  Stalling until master znode is written.");
        while (!amm.isActiveMaster()) {
            LOG.debug((Object)"Waiting for master address ZNode to be written (Also watching cluster state node)");
            Thread.sleep(c.getInt("zookeeper.session.timeout", 180000));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MonitoredTask startupStatus = TaskMonitor.get().createStatus("Master startup");
        startupStatus.setDescription("Master startup");
        this.masterStartTime = System.currentTimeMillis();
        try {
            this.registeredZKListenersBeforeRecovery = this.zooKeeper.getListeners();
            int port = this.conf.getInt("hbase.master.info.port", 60010);
            if (port >= 0) {
                String a = this.conf.get("hbase.master.info.bindAddress", "0.0.0.0");
                this.infoServer = new InfoServer(MASTER, a, port, false, this.conf);
                this.infoServer.addServlet("status", "/master-status", MasterStatusServlet.class);
                this.infoServer.addServlet("dump", "/dump", MasterDumpServlet.class);
                this.infoServer.setAttribute(MASTER, this);
                this.infoServer.start();
            }
            this.becomeActiveMaster(startupStatus);
            if (!this.stopped) {
                this.finishInitialization(startupStatus, false);
                this.loop();
            }
        }
        catch (Throwable t) {
            if (t instanceof NoClassDefFoundError && t.getMessage().contains("org/apache/hadoop/hdfs/protocol/FSConstants$SafeModeAction")) {
                this.abort("HBase is having a problem with its Hadoop jars.  You may need to recompile HBase against Hadoop version " + VersionInfo.getVersion() + " or change your hadoop jars to start properly", t);
            } else {
                this.abort("Unhandled exception. Starting shutdown.", t);
            }
        }
        finally {
            startupStatus.cleanup();
            this.stopChores();
            if (!this.abort && this.serverManager != null && this.serverManager.isClusterShutdown()) {
                this.serverManager.letRegionServersShutdown();
            }
            this.stopServiceThreads();
            if (this.activeMasterManager != null) {
                this.activeMasterManager.stop();
            }
            if (this.catalogTracker != null) {
                this.catalogTracker.stop();
            }
            if (this.serverManager != null) {
                this.serverManager.stop();
            }
            if (this.assignmentManager != null) {
                this.assignmentManager.stop();
            }
            if (this.fileSystemManager != null) {
                this.fileSystemManager.stop();
            }
            if (this.snapshotManager != null) {
                this.snapshotManager.stop("server shutting down.");
            }
            this.zooKeeper.close();
        }
        LOG.info((Object)"HMaster main thread exiting");
    }

    private boolean becomeActiveMaster(MonitoredTask startupStatus) throws InterruptedException {
        this.activeMasterManager = new ActiveMasterManager(this.zooKeeper, this.serverName, this);
        this.zooKeeper.registerListener(this.activeMasterManager);
        HMaster.stallIfBackupMaster(this.conf, this.activeMasterManager);
        this.clusterStatusTracker = new ClusterStatusTracker(this.getZooKeeper(), this);
        this.clusterStatusTracker.start();
        return this.activeMasterManager.blockUntilBecomingActiveMaster(startupStatus, this.clusterStatusTracker);
    }

    private void initializeZKBasedSystemTrackers() throws IOException, InterruptedException, KeeperException {
        this.catalogTracker = new CatalogTracker(this.zooKeeper, this.conf, this);
        this.catalogTracker.start();
        this.balancer = LoadBalancerFactory.getLoadBalancer(this.conf);
        this.assignmentManager = new AssignmentManager(this, this.serverManager, this.catalogTracker, this.balancer, this.executorService);
        this.zooKeeper.registerListenerFirst(this.assignmentManager);
        this.regionServerTracker = new RegionServerTracker(this.zooKeeper, this, this.serverManager);
        this.regionServerTracker.start();
        this.drainingServerTracker = new DrainingServerTracker(this.zooKeeper, this, this.serverManager);
        this.drainingServerTracker.start();
        boolean wasUp = this.clusterStatusTracker.isClusterUp();
        if (!wasUp) {
            this.clusterStatusTracker.setClusterUp();
        }
        LOG.info((Object)("Server active/primary master; " + this.serverName + ", sessionid=0x" + Long.toHexString(this.zooKeeper.getRecoverableZooKeeper().getSessionId()) + ", cluster-up flag was=" + wasUp));
        this.snapshotManager = new SnapshotManager(this, this.metrics);
    }

    private void loop() {
        while (!this.stopped) {
            this.stopSleeper.sleep();
        }
    }

    private void finishInitialization(MonitoredTask status, boolean masterRecovery) throws IOException, InterruptedException, KeeperException {
        ServerName preRootServer;
        this.isActiveMaster = true;
        status.setStatus("Initializing Master file system");
        this.masterActiveTime = System.currentTimeMillis();
        this.fileSystemManager = new MasterFileSystem(this, this, this.metrics, masterRecovery);
        this.tableDescriptors = new FSTableDescriptors(this.fileSystemManager.getFileSystem(), this.fileSystemManager.getRootDir());
        status.setStatus("Publishing Cluster ID in ZooKeeper");
        ClusterId.setClusterId(this.zooKeeper, this.fileSystemManager.getClusterId());
        if (!masterRecovery) {
            this.executorService = new org.apache.hadoop.hbase.executor.ExecutorService(this.getServerName().toString());
            this.serverManager = new ServerManager(this, this);
        }
        status.setStatus("Initializing ZK system trackers");
        this.initializeZKBasedSystemTrackers();
        if (!masterRecovery) {
            status.setStatus("Initializing master coprocessors");
            this.cpHost = new MasterCoprocessorHost(this, this.conf);
            status.setStatus("Initializing master service threads");
            this.startServiceThreads();
        }
        this.serverManager.waitForRegionServers(status);
        for (ServerName sn : this.regionServerTracker.getOnlineServers()) {
            if (this.serverManager.isServerOnline(sn)) continue;
            LOG.info((Object)("Registering server found up in zk but who has not yet reported in: " + sn));
            this.serverManager.recordNewServer(sn, HServerLoad.EMPTY_HSERVERLOAD);
        }
        if (!masterRecovery) {
            this.assignmentManager.startTimeOutMonitor();
        }
        Set<ServerName> failedServers = this.fileSystemManager.getFailedServersFromLogFolders();
        if (this.waitingOnLogSplitting) {
            ArrayList<ServerName> servers = new ArrayList<ServerName>(failedServers);
            this.fileSystemManager.splitAllLogs(servers);
            failedServers.clear();
        }
        if ((preRootServer = this.catalogTracker.getRootLocation()) != null && failedServers.contains(preRootServer)) {
            this.fileSystemManager.splitAllLogs(preRootServer);
            failedServers.remove(preRootServer);
        }
        this.initializationBeforeMetaAssignment = true;
        if (!this.assignRoot(status)) {
            return;
        }
        this.serverManager.enableSSHForRoot();
        ServerName preMetaServer = this.catalogTracker.getMetaLocationOrReadLocationFromRoot();
        if (preMetaServer != null && failedServers.contains(preMetaServer)) {
            this.fileSystemManager.splitAllLogs(preMetaServer);
            failedServers.remove(preMetaServer);
        }
        if (!this.assignMeta(status, masterRecovery ? null : preMetaServer, preRootServer)) {
            return;
        }
        this.enableServerShutdownHandler();
        status.setStatus("Submit log splitting work of non-meta region servers");
        for (ServerName curServer : failedServers) {
            this.serverManager.expireServer(curServer);
        }
        MetaMigrationRemovingHTD.updateMetaWithNewHRI(this);
        status.setStatus("Starting assignment manager");
        this.assignmentManager.joinCluster();
        this.balancer.setClusterStatus(this.getClusterStatus());
        this.balancer.setMasterServices(this);
        status.setStatus("Fixing up missing daughters");
        this.fixupDaughters(status);
        if (!masterRecovery) {
            status.setStatus("Starting balancer and catalog janitor");
            this.balancerChore = HMaster.getAndStartBalancerChore(this);
            this.catalogJanitorChore = new CatalogJanitor(this, this);
            this.startCatalogJanitorChore();
            this.registerMBean();
        }
        status.markComplete("Initialization successful");
        LOG.info((Object)"Master has completed initialization");
        this.initialized = true;
        this.serverManager.clearDeadServersWithSameHostNameAndPortOfOnlineServer();
        if (!masterRecovery && this.cpHost != null) {
            try {
                this.cpHost.postStartMaster();
            }
            catch (IOException ioe) {
                LOG.error((Object)"Coprocessor postStartMaster() hook failed", (Throwable)ioe);
            }
        }
    }

    private void enableServerShutdownHandler() throws IOException {
        if (!this.serverShutdownHandlerEnabled) {
            this.serverShutdownHandlerEnabled = true;
            this.serverManager.expireDeadNotExpiredServers();
        }
    }

    protected void startCatalogJanitorChore() {
        Threads.setDaemonThreadRunning(this.catalogJanitorChore.getThread());
    }

    private boolean assignRoot(MonitoredTask status) throws InterruptedException, IOException, KeeperException {
        int assigned = 0;
        long timeout = this.conf.getLong("hbase.catalog.verification.timeout", 1000L);
        status.setStatus("Assigning ROOT region");
        boolean rit = this.assignmentManager.processRegionInTransitionAndBlockUntilAssigned(HRegionInfo.ROOT_REGIONINFO);
        ServerName currentRootServer = null;
        boolean rootRegionLocation = this.catalogTracker.verifyRootRegionLocation(timeout);
        if (!rit && !rootRegionLocation) {
            currentRootServer = this.catalogTracker.getRootLocation();
            this.splitLogAndExpireIfOnline(currentRootServer);
            this.assignmentManager.assignRoot();
            this.waitForRootAssignment();
            if (!this.assignmentManager.isRegionAssigned(HRegionInfo.ROOT_REGIONINFO) || this.stopped) {
                return false;
            }
            ++assigned;
        } else if (rit && !rootRegionLocation) {
            this.waitForRootAssignment();
            if (!this.assignmentManager.isRegionAssigned(HRegionInfo.ROOT_REGIONINFO) || this.stopped) {
                return false;
            }
            ++assigned;
        } else {
            this.assignmentManager.regionOnline(HRegionInfo.ROOT_REGIONINFO, this.catalogTracker.getRootLocation());
        }
        this.enableCatalogTables(Bytes.toString(HConstants.ROOT_TABLE_NAME));
        LOG.info((Object)("-ROOT- assigned=" + assigned + ", rit=" + rit + ", location=" + this.catalogTracker.getRootLocation()));
        status.setStatus("ROOT assigned.");
        return true;
    }

    private boolean assignMeta(MonitoredTask status, ServerName previousMetaServer, ServerName previousRootServer) throws InterruptedException, IOException, KeeperException {
        int assigned = 0;
        long timeout = this.conf.getLong("hbase.catalog.verification.timeout", 1000L);
        status.setStatus("Assigning META region");
        boolean rit = this.assignmentManager.processRegionInTransitionAndBlockUntilAssigned(HRegionInfo.FIRST_META_REGIONINFO);
        boolean metaRegionLocation = this.catalogTracker.verifyMetaRegionLocation(timeout);
        if (!rit && !metaRegionLocation) {
            ServerName currentMetaServer;
            ServerName serverName = currentMetaServer = previousMetaServer != null ? previousMetaServer : this.catalogTracker.getMetaLocationOrReadLocationFromRoot();
            if (currentMetaServer != null && !currentMetaServer.equals(previousRootServer)) {
                this.fileSystemManager.splitAllLogs(currentMetaServer);
                if (this.serverManager.isServerOnline(currentMetaServer)) {
                    this.serverManager.expireServer(currentMetaServer);
                }
            }
            this.assignmentManager.assignMeta();
            this.enableSSHandWaitForMeta();
            if (!this.assignmentManager.isRegionAssigned(HRegionInfo.FIRST_META_REGIONINFO) || this.stopped) {
                return false;
            }
            ++assigned;
        } else if (rit && !metaRegionLocation) {
            this.enableSSHandWaitForMeta();
            if (!this.assignmentManager.isRegionAssigned(HRegionInfo.FIRST_META_REGIONINFO) || this.stopped) {
                return false;
            }
            ++assigned;
        } else {
            this.assignmentManager.regionOnline(HRegionInfo.FIRST_META_REGIONINFO, this.catalogTracker.getMetaLocation());
        }
        this.enableCatalogTables(Bytes.toString(HConstants.META_TABLE_NAME));
        LOG.info((Object)(".META. assigned=" + assigned + ", rit=" + rit + ", location=" + this.catalogTracker.getMetaLocation()));
        status.setStatus("META assigned.");
        return true;
    }

    private void enableSSHandWaitForMeta() throws IOException, InterruptedException {
        this.enableServerShutdownHandler();
        this.catalogTracker.waitForMeta();
        this.assignmentManager.waitForAssignment(HRegionInfo.FIRST_META_REGIONINFO);
    }

    private void waitForRootAssignment() throws InterruptedException, IOException {
        this.serverManager.enableSSHForRoot();
        this.catalogTracker.waitForRoot();
        this.assignmentManager.waitForAssignment(HRegionInfo.ROOT_REGIONINFO);
    }

    private void enableCatalogTables(String catalogTableName) {
        if (!this.assignmentManager.getZKTable().isEnabledTable(catalogTableName)) {
            this.assignmentManager.setEnabledTable(catalogTableName);
        }
    }

    void fixupDaughters(MonitoredTask status) throws IOException, KeeperException {
        final HashMap offlineSplitParents = new HashMap();
        MetaReader.Visitor visitor = new MetaReader.Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                HRegionInfo info = MetaReader.parseHRegionInfoFromCatalogResult(r, HConstants.REGIONINFO_QUALIFIER);
                if (info == null) {
                    return true;
                }
                if (info.isOffline() && info.isSplit()) {
                    offlineSplitParents.put(info, r);
                }
                return true;
            }
        };
        MetaReader.fullScan(this.catalogTracker, visitor);
        int fixups = 0;
        for (Map.Entry e : offlineSplitParents.entrySet()) {
            String node = ZKAssign.getNodeName(this.zooKeeper, ((HRegionInfo)((Object)e.getKey())).getEncodedName());
            byte[] data = ZKUtil.getData(this.zooKeeper, node);
            if (data != null) continue;
            fixups += ServerShutdownHandler.fixupDaughters((Result)e.getValue(), this.assignmentManager, this.catalogTracker);
        }
        if (fixups != 0) {
            LOG.info((Object)("Scanned the catalog and fixed up " + fixups + " missing daughter region(s)"));
        }
    }

    private void splitLogAndExpireIfOnline(ServerName sn) throws IOException {
        if (sn == null || !this.serverManager.isServerOnline(sn)) {
            return;
        }
        LOG.info((Object)("Forcing splitLog and expire of " + sn));
        if (this.shouldSplitMetaSeparately) {
            this.fileSystemManager.splitMetaLog(sn);
            this.fileSystemManager.splitLog(sn);
        } else {
            this.fileSystemManager.splitAllLogs(sn);
        }
        this.serverManager.expireServer(sn);
    }

    @Override
    public ProtocolSignature getProtocolSignature(String protocol, long version, int clientMethodsHashCode) throws IOException {
        if (HMasterInterface.class.getName().equals(protocol)) {
            return new ProtocolSignature(29L, null);
        }
        if (HMasterRegionInterface.class.getName().equals(protocol)) {
            return new ProtocolSignature(29L, null);
        }
        throw new IOException("Unknown protocol: " + protocol);
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) {
        if (HMasterInterface.class.getName().equals(protocol)) {
            return 29L;
        }
        if (HMasterRegionInterface.class.getName().equals(protocol)) {
            return 29L;
        }
        LOG.warn((Object)("Version requested for unimplemented protocol: " + protocol));
        return -1L;
    }

    @Override
    public TableDescriptors getTableDescriptors() {
        return this.tableDescriptors;
    }

    public InfoServer getInfoServer() {
        return this.infoServer;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public ServerManager getServerManager() {
        return this.serverManager;
    }

    @Override
    public org.apache.hadoop.hbase.executor.ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public MasterFileSystem getMasterFileSystem() {
        return this.fileSystemManager;
    }

    public ZooKeeperWatcher getZooKeeperWatcher() {
        return this.zooKeeper;
    }

    public ActiveMasterManager getActiveMasterManager() {
        return this.activeMasterManager;
    }

    private void startServiceThreads() throws IOException {
        this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_OPEN_REGION, this.conf.getInt("hbase.master.executor.openregion.threads", 5));
        this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_CLOSE_REGION, this.conf.getInt("hbase.master.executor.closeregion.threads", 5));
        this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_SERVER_OPERATIONS, this.conf.getInt("hbase.master.executor.serverops.threads", 3));
        this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_META_SERVER_OPERATIONS, this.conf.getInt("hbase.master.executor.serverops.threads", 5));
        this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_TABLE_OPERATIONS, 1);
        String n = Thread.currentThread().getName();
        int cleanerInterval = this.conf.getInt("hbase.master.cleaner.interval", 60000);
        this.logCleaner = new LogCleaner(cleanerInterval, this, this.conf, this.getMasterFileSystem().getFileSystem(), this.getMasterFileSystem().getOldLogDir());
        Threads.setDaemonThreadRunning(this.logCleaner.getThread(), n + ".oldLogCleaner");
        Path archiveDir = HFileArchiveUtil.getArchivePath(this.conf);
        this.hfileCleaner = new HFileCleaner(cleanerInterval, this, this.conf, this.getMasterFileSystem().getFileSystem(), archiveDir);
        Threads.setDaemonThreadRunning(this.hfileCleaner.getThread(), n + ".archivedHFileCleaner");
        if (this.healthCheckChore != null) {
            Threads.setDaemonThreadRunning(this.healthCheckChore.getThread(), n + ".healthChecker");
        }
        this.rpcServer.openServer();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Started service threads");
        }
    }

    private void stopServiceThreads() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping service threads");
        }
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
        if (this.logCleaner != null) {
            this.logCleaner.interrupt();
        }
        if (this.hfileCleaner != null) {
            this.hfileCleaner.interrupt();
        }
        if (this.infoServer != null) {
            LOG.info((Object)"Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.healthCheckChore != null) {
            this.healthCheckChore.interrupt();
        }
    }

    private static Thread getAndStartBalancerChore(final HMaster master) {
        String name = master.getServerName() + "-BalancerChore";
        int balancerPeriod = master.getConfiguration().getInt("hbase.balancer.period", 300000);
        Chore chore = new Chore(name, balancerPeriod, master){

            @Override
            protected void chore() {
                master.balance();
            }
        };
        return Threads.setDaemonThreadRunning(chore.getThread());
    }

    private void stopChores() {
        if (this.balancerChore != null) {
            this.balancerChore.interrupt();
        }
        if (this.catalogJanitorChore != null) {
            this.catalogJanitorChore.interrupt();
        }
    }

    @Override
    public MapWritable regionServerStartup(int port, long serverStartCode, long serverCurrentTime) throws IOException {
        InetAddress ia = HBaseServer.getRemoteIp();
        ServerName rs = this.serverManager.regionServerStartup(ia, port, serverStartCode, serverCurrentTime);
        MapWritable mw = this.createConfigurationSubset();
        mw.put((Writable)new Text("hbase.regionserver.hostname.seen.by.master"), (Writable)new Text(rs.getHostname()));
        return mw;
    }

    protected MapWritable createConfigurationSubset() {
        MapWritable mw = this.addConfig(new MapWritable(), "hbase.rootdir");
        return this.addConfig(mw, "fs.default.name");
    }

    private MapWritable addConfig(MapWritable mw, String key) {
        mw.put((Writable)new Text(key), (Writable)new Text(this.conf.get(key)));
        return mw;
    }

    @Override
    public void regionServerReport(byte[] sn, HServerLoad hsl) throws IOException {
        this.serverManager.regionServerReport(ServerName.parseVersionedServerName(sn), hsl);
        if (hsl != null && this.metrics != null) {
            this.metrics.incrementRequests(hsl.getTotalNumberOfRequests());
        }
    }

    @Override
    public void reportRSFatalError(byte[] sn, String errorText) {
        String msg = "Region server " + Bytes.toString(sn) + " reported a fatal error:\n" + errorText;
        LOG.error((Object)msg);
        this.rsFatals.add(msg);
    }

    @Override
    public boolean isMasterRunning() {
        return !this.isStopped();
    }

    private int getBalancerCutoffTime() {
        int balancerPeriod;
        int balancerCutoffTime = this.getConfiguration().getInt("hbase.balancer.max.balancing", -1);
        if (balancerCutoffTime == -1 && (balancerCutoffTime = (balancerPeriod = this.getConfiguration().getInt("hbase.balancer.period", 300000)) / 2) <= 0) {
            balancerCutoffTime = balancerPeriod;
        }
        return balancerCutoffTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean balance() {
        boolean balancerRan;
        if (!this.initialized) {
            LOG.debug((Object)"Master has not been initialized, don't run balancer.");
            return false;
        }
        if (!this.balanceSwitch) {
            return false;
        }
        int maximumBalanceTime = this.getBalancerCutoffTime();
        long cutoffTime = System.currentTimeMillis() + (long)maximumBalanceTime;
        LoadBalancer loadBalancer = this.balancer;
        synchronized (loadBalancer) {
            if (this.assignmentManager.isRegionsInTransition()) {
                LOG.debug((Object)("Not running balancer because " + this.assignmentManager.getRegionsInTransition().size() + " region(s) in transition: " + StringUtils.abbreviate((String)this.assignmentManager.getRegionsInTransition().toString(), (int)256)));
                return false;
            }
            if (this.serverManager.areDeadServersInProgress()) {
                LOG.debug((Object)("Not running balancer because processing dead regionserver(s): " + this.serverManager.getDeadServers()));
                return false;
            }
            if (this.cpHost != null) {
                try {
                    if (this.cpHost.preBalance()) {
                        LOG.debug((Object)"Coprocessor bypassing balancer request");
                        return false;
                    }
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Error invoking master coprocessor preBalance()", (Throwable)ioe);
                    return false;
                }
            }
            Map<String, Map<ServerName, List<HRegionInfo>>> assignmentsByTable = this.assignmentManager.getAssignmentsByTable();
            ArrayList<RegionPlan> plans = new ArrayList<RegionPlan>();
            for (Map<ServerName, List<HRegionInfo>> assignments : assignmentsByTable.values()) {
                List<RegionPlan> partialPlans = this.balancer.balanceCluster(assignments);
                if (partialPlans == null) continue;
                plans.addAll(partialPlans);
            }
            int rpCount = 0;
            long totalRegPlanExecTime = 0L;
            boolean bl = balancerRan = plans != null;
            if (plans != null && !plans.isEmpty()) {
                for (RegionPlan plan : plans) {
                    LOG.info((Object)("balance " + plan));
                    long balStartTime = System.currentTimeMillis();
                    this.assignmentManager.balance(plan);
                    if (++rpCount >= plans.size() || System.currentTimeMillis() + (totalRegPlanExecTime += System.currentTimeMillis() - balStartTime) / (long)rpCount <= cutoffTime) continue;
                    LOG.debug((Object)("No more balancing till next balance run; maximumBalanceTime=" + maximumBalanceTime));
                    break;
                }
            }
            if (this.cpHost != null) {
                try {
                    this.cpHost.postBalance();
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Error invoking master coprocessor postBalance()", (Throwable)ioe);
                }
            }
        }
        return balancerRan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean switchBalancer(boolean b, BalanceSwitchMode mode) {
        boolean oldValue = this.balanceSwitch;
        boolean newValue = b;
        try {
            if (this.cpHost != null) {
                newValue = this.cpHost.preBalanceSwitch(newValue);
            }
            if (mode == BalanceSwitchMode.SYNC) {
                LoadBalancer loadBalancer = this.balancer;
                synchronized (loadBalancer) {
                    this.balanceSwitch = newValue;
                }
            } else {
                this.balanceSwitch = newValue;
            }
            LOG.info((Object)("BalanceSwitch=" + newValue));
            if (this.cpHost != null) {
                this.cpHost.postBalanceSwitch(oldValue, newValue);
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Error flipping balance switch", (Throwable)ioe);
        }
        return oldValue;
    }

    @Override
    public boolean synchronousBalanceSwitch(boolean b) {
        return this.switchBalancer(b, BalanceSwitchMode.SYNC);
    }

    @Override
    public boolean balanceSwitch(boolean b) {
        return this.switchBalancer(b, BalanceSwitchMode.ASYNC);
    }

    public void setCatalogJanitorEnabled(boolean b) {
        this.catalogJanitorChore.setEnabled(b);
    }

    @Override
    public void move(byte[] encodedRegionName, byte[] destServerName) throws UnknownRegionException {
        Pair<HRegionInfo, ServerName> p = this.assignmentManager.getAssignment(encodedRegionName);
        if (p == null) {
            throw new UnknownRegionException(Bytes.toStringBinary(encodedRegionName));
        }
        ServerName dest = null;
        if (destServerName == null || destServerName.length == 0) {
            LOG.info((Object)"Passed destination servername is null or empty so choosing a server at random");
            List<ServerName> destServers = this.serverManager.getOnlineServersList();
            destServers.remove(p.getSecond());
            dest = this.balancer.randomAssignment(destServers);
        } else {
            dest = new ServerName(Bytes.toString(destServerName));
        }
        RegionPlan rp = new RegionPlan(p.getFirst(), p.getSecond(), dest);
        try {
            this.checkInitialized();
            if (this.cpHost != null && this.cpHost.preMove(p.getFirst(), p.getSecond(), dest)) {
                return;
            }
            LOG.info((Object)("Added move plan " + rp + ", running balancer"));
            this.assignmentManager.balance(rp);
            if (this.cpHost != null) {
                this.cpHost.postMove(p.getFirst(), p.getSecond(), dest);
            }
        }
        catch (IOException ioe) {
            UnknownRegionException ure = new UnknownRegionException(Bytes.toStringBinary(encodedRegionName));
            ure.initCause(ioe);
            throw ure;
        }
    }

    @Override
    public void createTable(HTableDescriptor hTableDescriptor, byte[][] splitKeys) throws IOException {
        if (!this.isMasterRunning()) {
            throw new MasterNotRunningException();
        }
        HRegionInfo[] newRegions = this.getHRegionInfos(hTableDescriptor, splitKeys);
        this.checkInitialized();
        if (this.cpHost != null) {
            this.cpHost.preCreateTable(hTableDescriptor, newRegions);
        }
        this.executorService.submit(new CreateTableHandler(this, this.fileSystemManager, this.serverManager, hTableDescriptor, this.conf, newRegions, this.catalogTracker, this.assignmentManager));
        if (this.cpHost != null) {
            this.cpHost.postCreateTable(hTableDescriptor, newRegions);
        }
    }

    private HRegionInfo[] getHRegionInfos(HTableDescriptor hTableDescriptor, byte[][] splitKeys) {
        HRegionInfo[] hRegionInfos = null;
        if (splitKeys == null || splitKeys.length == 0) {
            hRegionInfos = new HRegionInfo[]{new HRegionInfo(hTableDescriptor.getName(), null, null)};
        } else {
            int numRegions = splitKeys.length + 1;
            hRegionInfos = new HRegionInfo[numRegions];
            byte[] startKey = null;
            byte[] endKey = null;
            for (int i = 0; i < numRegions; ++i) {
                endKey = i == splitKeys.length ? null : splitKeys[i];
                hRegionInfos[i] = new HRegionInfo(hTableDescriptor.getName(), startKey, endKey);
                startKey = endKey;
            }
        }
        return hRegionInfos;
    }

    private static boolean isCatalogTable(byte[] tableName) {
        return Bytes.equals(tableName, HConstants.ROOT_TABLE_NAME) || Bytes.equals(tableName, HConstants.META_TABLE_NAME);
    }

    @Override
    public void deleteTable(byte[] tableName) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null) {
            this.cpHost.preDeleteTable(tableName);
        }
        this.executorService.submit(new DeleteTableHandler(tableName, this, this));
        if (this.cpHost != null) {
            this.cpHost.postDeleteTable(tableName);
        }
    }

    @Override
    public Pair<Integer, Integer> getAlterStatus(byte[] tableName) throws IOException {
        return this.assignmentManager.getReopenStatus(tableName);
    }

    @Override
    public void addColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null && this.cpHost.preAddColumn(tableName, column)) {
            return;
        }
        new TableAddFamilyHandler(tableName, column, (Server)this, (MasterServices)this).process();
        if (this.cpHost != null) {
            this.cpHost.postAddColumn(tableName, column);
        }
    }

    @Override
    public void modifyColumn(byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null && this.cpHost.preModifyColumn(tableName, descriptor)) {
            return;
        }
        new TableModifyFamilyHandler(tableName, descriptor, (Server)this, (MasterServices)this).process();
        if (this.cpHost != null) {
            this.cpHost.postModifyColumn(tableName, descriptor);
        }
    }

    @Override
    public void deleteColumn(byte[] tableName, byte[] c) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null && this.cpHost.preDeleteColumn(tableName, c)) {
            return;
        }
        new TableDeleteFamilyHandler(tableName, c, (Server)this, (MasterServices)this).process();
        if (this.cpHost != null) {
            this.cpHost.postDeleteColumn(tableName, c);
        }
    }

    @Override
    public void enableTable(byte[] tableName) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null) {
            this.cpHost.preEnableTable(tableName);
        }
        this.executorService.submit(new EnableTableHandler(this, tableName, this.catalogTracker, this.assignmentManager, false));
        if (this.cpHost != null) {
            this.cpHost.postEnableTable(tableName);
        }
    }

    @Override
    public void disableTable(byte[] tableName) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null) {
            this.cpHost.preDisableTable(tableName);
        }
        this.executorService.submit(new DisableTableHandler(this, tableName, this.catalogTracker, this.assignmentManager, false));
        if (this.cpHost != null) {
            this.cpHost.postDisableTable(tableName);
        }
    }

    Pair<HRegionInfo, ServerName> getTableRegionForRow(final byte[] tableName, byte[] rowKey) throws IOException {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

            @Override
            public boolean processRow(Result data) throws IOException {
                if (data == null || data.size() <= 0) {
                    return true;
                }
                Pair<HRegionInfo, ServerName> pair = MetaReader.parseCatalogResult(data);
                if (pair == null) {
                    return false;
                }
                if (!Bytes.equals(pair.getFirst().getTableName(), tableName)) {
                    return false;
                }
                result.set(pair);
                return true;
            }
        };
        MetaScanner.metaScan(this.conf, visitor, tableName, rowKey, 1);
        return result.get();
    }

    @Override
    public void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null) {
            this.cpHost.preModifyTable(tableName, htd);
        }
        ModifyTableHandler tblHandler = new ModifyTableHandler(tableName, htd, (Server)this, (MasterServices)this);
        this.executorService.submit(tblHandler);
        tblHandler.waitForEventBeingHandled();
        if (this.cpHost != null) {
            this.cpHost.postModifyTable(tableName, htd);
        }
    }

    @Override
    public void checkTableModifiable(byte[] tableName) throws IOException {
        String tableNameStr = Bytes.toString(tableName);
        if (HMaster.isCatalogTable(tableName)) {
            throw new IOException("Can't modify catalog tables");
        }
        if (!MetaReader.tableExists(this.getCatalogTracker(), tableNameStr)) {
            throw new TableNotFoundException(tableNameStr);
        }
        if (!this.getAssignmentManager().getZKTable().isDisabledTable(Bytes.toString(tableName))) {
            throw new TableNotDisabledException(tableName);
        }
    }

    public void clearFromTransition(HRegionInfo hri) {
        if (this.assignmentManager.isRegionInTransition(hri) != null) {
            this.assignmentManager.regionOffline(hri);
        }
    }

    @Override
    public ClusterStatus getClusterStatus() {
        List<String> backupMasterStrings;
        try {
            backupMasterStrings = ZKUtil.listChildrenNoWatch(this.zooKeeper, this.zooKeeper.backupMasterAddressesZNode);
        }
        catch (KeeperException e) {
            LOG.warn((Object)this.zooKeeper.prefix("Unable to list backup servers"), (Throwable)e);
            backupMasterStrings = new ArrayList<String>(0);
        }
        ArrayList<ServerName> backupMasters = new ArrayList<ServerName>(backupMasterStrings.size());
        for (String s : backupMasterStrings) {
            try {
                byte[] bytes = ZKUtil.getData(this.zooKeeper, ZKUtil.joinZNode(this.zooKeeper.backupMasterAddressesZNode, s));
                if (bytes == null) continue;
                backupMasters.add(ServerName.parseVersionedServerName(bytes));
            }
            catch (KeeperException e) {
                LOG.warn((Object)this.zooKeeper.prefix("Unable to get information about backup servers"), (Throwable)e);
            }
        }
        Collections.sort(backupMasters, new Comparator<ServerName>(){

            @Override
            public int compare(ServerName s1, ServerName s2) {
                return s1.getServerName().compareTo(s2.getServerName());
            }
        });
        return new ClusterStatus(org.apache.hadoop.hbase.util.VersionInfo.getVersion(), this.fileSystemManager.getClusterId(), this.serverManager.getOnlineServers(), this.serverManager.getDeadServers(), this.serverName, backupMasters, this.assignmentManager.getRegionsInTransition(), this.getCoprocessors());
    }

    public String getClusterId() {
        return this.fileSystemManager == null ? null : this.fileSystemManager.getClusterId();
    }

    public static String getLoadedCoprocessors() {
        return CoprocessorHost.getLoadedCoprocessors().toString();
    }

    public long getMasterStartTime() {
        return this.masterStartTime;
    }

    public long getMasterActiveTime() {
        return this.masterActiveTime;
    }

    public String[] getCoprocessors() {
        MasterCoprocessorHost cp = this.getCoprocessorHost();
        String[] cpList = new String[]{};
        if (cp == null) {
            return cpList;
        }
        Set<String> masterCoprocessors = cp.getCoprocessors();
        return masterCoprocessors.toArray(cpList);
    }

    @Override
    public void abort(String msg, Throwable t) {
        if (this.cpHost != null) {
            LOG.fatal((Object)("Master server abort: loaded coprocessors are: " + HMaster.getLoadedCoprocessors()));
        }
        if (this.abortNow(msg, t)) {
            if (t != null) {
                LOG.fatal((Object)msg, t);
            } else {
                LOG.fatal((Object)msg);
            }
            this.abort = true;
            this.stop("Aborting");
        }
    }

    private boolean tryRecoveringExpiredZKSession() throws InterruptedException, IOException, KeeperException, ExecutionException {
        Boolean recovered;
        this.zooKeeper.unregisterAllListeners();
        if (this.registeredZKListenersBeforeRecovery != null) {
            for (ZooKeeperListener curListener : this.registeredZKListenersBeforeRecovery) {
                this.zooKeeper.registerListener(curListener);
            }
        }
        this.zooKeeper.reconnectAfterExpiration();
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws InterruptedException, IOException, KeeperException {
                MonitoredTask status = TaskMonitor.get().createStatus("Recovering expired ZK session");
                try {
                    if (!HMaster.this.becomeActiveMaster(status)) {
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    HMaster.this.serverManager.disableSSHForRoot();
                    HMaster.this.serverShutdownHandlerEnabled = false;
                    HMaster.this.initialized = false;
                    HMaster.this.finishInitialization(status, true);
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                finally {
                    status.cleanup();
                }
            }
        };
        long timeout = this.conf.getLong("hbase.master.zksession.recover.timeout", 300000L);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Boolean> result = executor.submit(callable);
        executor.shutdown();
        if (executor.awaitTermination(timeout, TimeUnit.MILLISECONDS) && result.isDone() && (recovered = result.get()) != null) {
            return recovered;
        }
        executor.shutdownNow();
        return false;
    }

    private boolean abortNow(String msg, Throwable t) {
        if (!this.isActiveMaster || this.stopped) {
            return true;
        }
        boolean failFast = this.conf.getBoolean("fail.fast.expired.active.master", false);
        if (t != null && t instanceof KeeperException.SessionExpiredException && !failFast) {
            try {
                LOG.info((Object)"Primary Master trying to recover from ZooKeeper session expiry.");
                return !this.tryRecoveringExpiredZKSession();
            }
            catch (Throwable newT) {
                LOG.error((Object)"Primary master encountered unexpected exception while trying to recover from ZooKeeper session expiry. Proceeding with server abort.", newT);
            }
        }
        return true;
    }

    @Override
    public ZooKeeperWatcher getZooKeeper() {
        return this.zooKeeper;
    }

    @Override
    public MasterCoprocessorHost getCoprocessorHost() {
        return this.cpHost;
    }

    @Override
    public ServerName getServerName() {
        return this.serverName;
    }

    @Override
    public CatalogTracker getCatalogTracker() {
        return this.catalogTracker;
    }

    @Override
    public AssignmentManager getAssignmentManager() {
        return this.assignmentManager;
    }

    public MemoryBoundedLogMessageBuffer getRegionServerFatalLogBuffer() {
        return this.rsFatals;
    }

    @Override
    public void shutdown() {
        if (this.cpHost != null) {
            try {
                this.cpHost.preShutdown();
            }
            catch (IOException ioe) {
                LOG.error((Object)"Error call master coprocessor preShutdown()", (Throwable)ioe);
            }
        }
        if (this.mxBean != null) {
            MBeanUtil.unregisterMBean((ObjectName)this.mxBean);
            this.mxBean = null;
        }
        if (this.assignmentManager != null) {
            this.assignmentManager.shutdown();
        }
        if (this.serverManager != null) {
            this.serverManager.shutdownCluster();
        }
        try {
            if (this.clusterStatusTracker != null) {
                this.clusterStatusTracker.setClusterDown();
            }
        }
        catch (KeeperException e) {
            if (e instanceof KeeperException.SessionExpiredException) {
                LOG.warn((Object)"ZK session expired. Retry a new connection...");
                try {
                    this.zooKeeper.reconnectAfterExpiration();
                    this.clusterStatusTracker.setClusterDown();
                }
                catch (Exception ex) {
                    LOG.error((Object)"Retry setClusterDown failed", (Throwable)ex);
                }
            }
            LOG.error((Object)"ZooKeeper exception trying to set cluster as down in ZK", (Throwable)e);
        }
    }

    @Override
    public void stopMaster() {
        if (this.cpHost != null) {
            try {
                this.cpHost.preStopMaster();
            }
            catch (IOException ioe) {
                LOG.error((Object)"Error call master coprocessor preStopMaster()", (Throwable)ioe);
            }
        }
        this.stop("Stopped by " + Thread.currentThread().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(String why) {
        LOG.info((Object)why);
        this.stopped = true;
        this.stopSleeper.skipSleepCycle();
        if (this.activeMasterManager != null) {
            AtomicBoolean atomicBoolean = this.activeMasterManager.clusterHasActiveMaster;
            synchronized (atomicBoolean) {
                this.activeMasterManager.clusterHasActiveMaster.notifyAll();
            }
        }
        if (this.catalogTracker != null && this.serverManager.getOnlineServers().isEmpty()) {
            this.catalogTracker.stop();
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public boolean isAborted() {
        return this.abort;
    }

    void checkInitialized() throws PleaseHoldException {
        if (!this.initialized) {
            throw new PleaseHoldException("Master is initializing");
        }
    }

    public boolean isActiveMaster() {
        return this.isActiveMaster;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isServerShutdownHandlerEnabled() {
        return this.serverShutdownHandlerEnabled;
    }

    @Override
    public boolean shouldSplitMetaSeparately() {
        return this.shouldSplitMetaSeparately;
    }

    public boolean isInitializationStartsMetaRegoinAssignment() {
        return this.initializationBeforeMetaAssignment;
    }

    @Override
    @Deprecated
    public void assign(byte[] regionName, boolean force) throws IOException {
        this.assign(regionName);
    }

    @Override
    public void assign(byte[] regionName) throws IOException {
        this.checkInitialized();
        Pair<HRegionInfo, ServerName> pair = MetaReader.getRegion(this.catalogTracker, regionName);
        if (pair == null) {
            throw new UnknownRegionException(Bytes.toString(regionName));
        }
        if (this.cpHost != null && this.cpHost.preAssign(pair.getFirst())) {
            return;
        }
        this.assignRegion(pair.getFirst());
        if (this.cpHost != null) {
            this.cpHost.postAssign(pair.getFirst());
        }
    }

    public void assignRegion(HRegionInfo hri) {
        this.assignmentManager.assign(hri, true);
    }

    @Override
    public void unassign(byte[] regionName, boolean force) throws IOException {
        this.checkInitialized();
        Pair<HRegionInfo, ServerName> pair = MetaReader.getRegion(this.catalogTracker, regionName);
        if (pair == null) {
            throw new UnknownRegionException(Bytes.toString(regionName));
        }
        HRegionInfo hri = pair.getFirst();
        if (this.cpHost != null && this.cpHost.preUnassign(hri, force)) {
            return;
        }
        if (force) {
            this.assignmentManager.regionOffline(hri);
            this.assignRegion(hri);
        } else {
            this.assignmentManager.unassign(hri, force);
        }
        if (this.cpHost != null) {
            this.cpHost.postUnassign(hri, force);
        }
    }

    @Override
    public HTableDescriptor[] getHTableDescriptors(List<String> tableNames) throws IOException {
        ArrayList<HTableDescriptor> descriptors = new ArrayList<HTableDescriptor>(tableNames.size());
        boolean bypass = false;
        if (this.cpHost != null) {
            bypass = this.cpHost.preGetTableDescriptors(tableNames, descriptors);
        }
        if (!bypass) {
            for (String s : tableNames) {
                HTableDescriptor htd = null;
                try {
                    htd = this.tableDescriptors.get(s);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed getting descriptor for " + s), (Throwable)e);
                }
                if (htd == null) continue;
                descriptors.add(htd);
            }
        }
        if (this.cpHost != null) {
            this.cpHost.postGetTableDescriptors(descriptors);
        }
        return descriptors.toArray(new HTableDescriptor[0]);
    }

    @Override
    public <T extends CoprocessorProtocol> boolean registerProtocol(Class<T> protocol, T handler) {
        if (this.protocolHandlers.containsKey(protocol)) {
            LOG.error((Object)("Protocol " + protocol.getName() + " already registered, rejecting request from " + handler));
            return false;
        }
        this.protocolHandlers.putInstance(protocol, handler);
        this.protocolHandlerNames.put(protocol.getName(), protocol);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registered master protocol handler: protocol=" + protocol.getName()));
        }
        return true;
    }

    @Override
    public ExecResult execCoprocessor(Exec call) throws IOException {
        Object value;
        Class<? extends CoprocessorProtocol> protocol = call.getProtocol();
        if (protocol == null) {
            String protocolName = call.getProtocolName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Received dynamic protocol exec call with protocolName " + protocolName));
            }
            if ((protocol = this.protocolHandlerNames.get(protocolName)) == null) {
                throw new HBaseRPC.UnknownProtocolException(protocol, "No matching handler for master protocol " + protocolName);
            }
        }
        if (!this.protocolHandlers.containsKey(protocol)) {
            throw new HBaseRPC.UnknownProtocolException(protocol, "No matching handler for protocol ");
        }
        CoprocessorProtocol handler = (CoprocessorProtocol)this.protocolHandlers.getInstance(protocol);
        try {
            Method method = protocol.getMethod(call.getMethodName(), call.getParameterClasses());
            method.setAccessible(true);
            value = method.invoke((Object)handler, call.getParameters());
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            IOException ioe = new IOException(target.toString());
            ioe.setStackTrace(target.getStackTrace());
            throw ioe;
        }
        catch (Throwable e) {
            if (!(e instanceof IOException)) {
                LOG.error((Object)"Unexpected throwable object ", e);
            }
            IOException ioe = new IOException(e.toString());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
        return new ExecResult(value);
    }

    @Override
    public HTableDescriptor[] getHTableDescriptors() throws IOException {
        ArrayList<HTableDescriptor> descriptors = new ArrayList<HTableDescriptor>();
        boolean bypass = false;
        if (this.cpHost != null) {
            bypass = this.cpHost.preGetTableDescriptors(null, descriptors);
        }
        if (!bypass) {
            descriptors.addAll(this.tableDescriptors.getAll().values());
        }
        if (this.cpHost != null) {
            this.cpHost.postGetTableDescriptors(descriptors);
        }
        return descriptors.toArray(new HTableDescriptor[0]);
    }

    public double getAverageLoad() {
        return this.assignmentManager.getAverageLoad();
    }

    @Override
    public void offline(byte[] regionName) throws IOException {
        Pair<HRegionInfo, ServerName> pair = MetaReader.getRegion(this.catalogTracker, regionName);
        if (pair == null) {
            throw new UnknownRegionException(Bytes.toStringBinary(regionName));
        }
        HRegionInfo hri = pair.getFirst();
        this.assignmentManager.regionOffline(hri);
    }

    public static HMaster constructMaster(Class<? extends HMaster> masterClass, Configuration conf) {
        try {
            Constructor<? extends HMaster> c = masterClass.getConstructor(Configuration.class);
            return c.newInstance(conf);
        }
        catch (InvocationTargetException ite) {
            Throwable target;
            Throwable throwable = target = ite.getTargetException() != null ? ite.getTargetException() : ite;
            if (target.getCause() != null) {
                target = target.getCause();
            }
            throw new RuntimeException("Failed construction of Master: " + masterClass.toString(), target);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed construction of Master: " + masterClass.toString() + (e.getCause() != null ? e.getCause().getMessage() : ""), e);
        }
    }

    public static void main(String[] args) throws Exception {
        org.apache.hadoop.hbase.util.VersionInfo.logVersion();
        new HMasterCommandLine(HMaster.class).doMain(args);
    }

    void registerMBean() {
        MXBeanImpl mxBeanInfo = MXBeanImpl.init(this);
        MBeanUtil.registerMBean((String)"Master", (String)"Master", (Object)mxBeanInfo);
        LOG.info((Object)"Registered HMaster MXBean");
    }

    public HFileCleaner getHFileCleaner() {
        return this.hfileCleaner;
    }

    private boolean isHealthCheckerConfigured() {
        String healthScriptLocation = this.conf.get("hbase.node.health.script.location");
        return StringUtils.isNotBlank((String)healthScriptLocation);
    }

    public SnapshotManager getSnapshotManagerForTesting() {
        return this.snapshotManager;
    }

    @Override
    public long snapshot(HSnapshotDescription request) throws IOException {
        LOG.debug((Object)("Submitting snapshot request for:" + SnapshotDescriptionUtils.toString(request.getProto())));
        try {
            this.snapshotManager.checkSnapshotSupport();
        }
        catch (UnsupportedOperationException e) {
            throw new IOException(e);
        }
        HBaseProtos.SnapshotDescription snapshot = SnapshotDescriptionUtils.validate(request.getProto(), this.conf);
        this.snapshotManager.takeSnapshot(snapshot);
        long waitTime = SnapshotDescriptionUtils.getMaxMasterTimeout(this.conf, snapshot.getType(), 60000L);
        return waitTime;
    }

    @Override
    public List<HSnapshotDescription> getCompletedSnapshots() throws IOException {
        ArrayList<HSnapshotDescription> availableSnapshots = new ArrayList<HSnapshotDescription>();
        List<HBaseProtos.SnapshotDescription> snapshots = this.snapshotManager.getCompletedSnapshots();
        for (HBaseProtos.SnapshotDescription snapshot : snapshots) {
            availableSnapshots.add(new HSnapshotDescription(snapshot));
        }
        return availableSnapshots;
    }

    @Override
    public void deleteSnapshot(HSnapshotDescription request) throws IOException {
        try {
            this.snapshotManager.checkSnapshotSupport();
        }
        catch (UnsupportedOperationException e) {
            throw new IOException(e);
        }
        this.snapshotManager.deleteSnapshot(request.getProto());
    }

    @Override
    public boolean isSnapshotDone(HSnapshotDescription request) throws IOException {
        LOG.debug((Object)("Checking to see if snapshot from request:" + SnapshotDescriptionUtils.toString(request.getProto()) + " is done"));
        return this.snapshotManager.isSnapshotDone(request.getProto());
    }

    @Override
    public void restoreSnapshot(HSnapshotDescription request) throws IOException {
        try {
            this.snapshotManager.checkSnapshotSupport();
        }
        catch (UnsupportedOperationException e) {
            throw new IOException(e);
        }
        this.snapshotManager.restoreSnapshot(request.getProto());
    }

    @Override
    public boolean isRestoreSnapshotDone(HSnapshotDescription request) throws IOException {
        return this.snapshotManager.isRestoreDone(request.getProto());
    }

    @Override
    public String[] getTableNames() throws IOException {
        Collection<HTableDescriptor> descriptors = this.tableDescriptors.getAll().values();
        Iterator<HTableDescriptor> iter = descriptors.iterator();
        String[] names = new String[descriptors.size()];
        int i = 0;
        while (iter.hasNext()) {
            names[i++] = iter.next().getNameAsString();
        }
        return names;
    }

    static enum BalanceSwitchMode {
        SYNC,
        ASYNC;

    }
}

