/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseFileSystem;
import org.apache.hadoop.hbase.regionserver.wal.HLog;

public class HLogFileSystem
extends HBaseFileSystem {
    public static final Log LOG = LogFactory.getLog(HLogFileSystem.class);

    public HLogFileSystem(Configuration conf) {
        HLogFileSystem.setRetryCounts(conf);
    }

    public HLog.Writer createWriter(FileSystem fs, Configuration conf, Path hlogFile) throws IOException {
        int i = 0;
        IOException lastIOE = null;
        while (true) {
            try {
                return HLog.createWriter(fs, hlogFile, conf);
            }
            catch (IOException ioe) {
                lastIOE = ioe;
                HLogFileSystem.sleepBeforeRetry("Create Writer", i + 1);
                if (++i <= hdfsClientRetriesNumber) continue;
                throw new IOException("Exception in createWriter", lastIOE);
            }
            break;
        }
    }
}

