/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.MetaUtils;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class Merge
extends Configured
implements Tool {
    static final Log LOG = LogFactory.getLog(Merge.class);
    private Path rootdir;
    private volatile MetaUtils utils;
    private byte[] tableName;
    private volatile byte[] region1;
    private volatile byte[] region2;
    private volatile boolean isMetaTable;
    private volatile HRegionInfo mergeInfo;

    public Merge() {
    }

    public Merge(Configuration conf) {
        this.mergeInfo = null;
        this.setConf(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        if (this.parseArgs(args) != 0) {
            return -1;
        }
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        LOG.info((Object)"Verifying that file system is available...");
        try {
            FSUtils.checkFileSystemAvailable(fs);
        }
        catch (IOException e) {
            LOG.fatal((Object)"File system is not available", (Throwable)e);
            return -1;
        }
        LOG.info((Object)"Verifying that HBase is not running...");
        try {
            HBaseAdmin.checkHBaseAvailable(this.getConf());
            LOG.fatal((Object)"HBase cluster must be off-line.");
            return -1;
        }
        catch (ZooKeeperConnectionException zkce) {
        }
        catch (MasterNotRunningException e) {
            // empty catch block
        }
        this.utils = new MetaUtils(this.getConf());
        this.rootdir = FSUtils.getRootDir(this.getConf());
        try {
            if (this.isMetaTable) {
                this.mergeTwoMetaRegions();
            } else {
                this.mergeTwoRegions();
            }
            int e = 0;
            return e;
        }
        catch (Exception e) {
            LOG.fatal((Object)"Merge failed", (Throwable)e);
            this.utils.scanMetaRegion(HRegionInfo.FIRST_META_REGIONINFO, new MetaUtils.ScannerListener(){

                @Override
                public boolean processRow(HRegionInfo info) {
                    System.err.println(info.toString());
                    return true;
                }
            });
            int n = -1;
            return n;
        }
        finally {
            if (this.utils != null) {
                this.utils.shutdown();
            }
        }
    }

    HRegionInfo getMergedHRegionInfo() {
        return this.mergeInfo;
    }

    private void mergeTwoMetaRegions() throws IOException {
        HRegion rootRegion = this.utils.getRootRegion();
        Get get2 = new Get(this.region1);
        get2.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        List<KeyValue> cells1 = rootRegion.get(get2, null).list();
        HRegionInfo info1 = Writables.getHRegionInfo(cells1 == null ? null : cells1.get(0).getValue());
        get2 = new Get(this.region2);
        get2.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        List<KeyValue> cells2 = rootRegion.get(get2, null).list();
        HRegionInfo info2 = Writables.getHRegionInfo(cells2 == null ? null : cells2.get(0).getValue());
        HRegion merged = this.merge(HTableDescriptor.META_TABLEDESC, info1, rootRegion, info2, rootRegion);
        LOG.info((Object)("Adding " + (Object)((Object)merged.getRegionInfo()) + " to " + (Object)((Object)rootRegion.getRegionInfo())));
        HRegion.addRegionToMETA(rootRegion, merged);
        merged.close();
    }

    private void mergeTwoRegions() throws IOException {
        LOG.info((Object)("Merging regions " + Bytes.toStringBinary(this.region1) + " and " + Bytes.toStringBinary(this.region2) + " in table " + Bytes.toString(this.tableName)));
        MetaScannerListener listener = new MetaScannerListener(this.region1, this.region2);
        this.utils.scanRootRegion(listener);
        HRegionInfo meta1 = listener.getMeta1();
        if (meta1 == null) {
            throw new IOException("Could not find meta region for " + Bytes.toStringBinary(this.region1));
        }
        HRegionInfo meta2 = listener.getMeta2();
        if (meta2 == null) {
            throw new IOException("Could not find meta region for " + Bytes.toStringBinary(this.region2));
        }
        LOG.info((Object)("Found meta for region1 " + Bytes.toStringBinary(meta1.getRegionName()) + ", meta for region2 " + Bytes.toStringBinary(meta2.getRegionName())));
        HRegion metaRegion1 = this.utils.getMetaRegion(meta1);
        Get get2 = new Get(this.region1);
        get2.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        List<KeyValue> cells1 = metaRegion1.get(get2, null).list();
        HRegionInfo info1 = Writables.getHRegionInfo(cells1 == null ? null : cells1.get(0).getValue());
        if (info1 == null) {
            throw new NullPointerException("info1 is null using key " + Bytes.toStringBinary(this.region1) + " in " + (Object)((Object)meta1));
        }
        HRegion metaRegion2 = Bytes.equals(meta1.getRegionName(), meta2.getRegionName()) ? metaRegion1 : this.utils.getMetaRegion(meta2);
        get2 = new Get(this.region2);
        get2.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        List<KeyValue> cells2 = metaRegion2.get(get2, null).list();
        HRegionInfo info2 = Writables.getHRegionInfo(cells2 == null ? null : cells2.get(0).getValue());
        if (info2 == null) {
            throw new NullPointerException("info2 is null using key " + (Object)((Object)meta2));
        }
        HTableDescriptor htd = FSTableDescriptors.getTableDescriptor(FileSystem.get((Configuration)this.getConf()), this.rootdir, this.tableName);
        HRegion merged = this.merge(htd, info1, metaRegion1, info2, metaRegion2);
        listener = new MetaScannerListener(merged.getRegionName(), null);
        this.utils.scanRootRegion(listener);
        HRegionInfo mergedInfo = listener.getMeta1();
        if (mergedInfo == null) {
            throw new IOException("Could not find meta region for " + Bytes.toStringBinary(merged.getRegionName()));
        }
        HRegion mergeMeta = Bytes.equals(mergedInfo.getRegionName(), meta1.getRegionName()) ? metaRegion1 : (Bytes.equals(mergedInfo.getRegionName(), meta2.getRegionName()) ? metaRegion2 : this.utils.getMetaRegion(mergedInfo));
        LOG.info((Object)("Adding " + (Object)((Object)merged.getRegionInfo()) + " to " + (Object)((Object)mergeMeta.getRegionInfo())));
        HRegion.addRegionToMETA(mergeMeta, merged);
        merged.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HRegion merge(HTableDescriptor htd, HRegionInfo info1, HRegion meta1, HRegionInfo info2, HRegion meta2) throws IOException {
        if (info1 == null) {
            throw new IOException("Could not find " + Bytes.toStringBinary(this.region1) + " in " + Bytes.toStringBinary(meta1.getRegionName()));
        }
        if (info2 == null) {
            throw new IOException("Cound not find " + Bytes.toStringBinary(this.region2) + " in " + Bytes.toStringBinary(meta2.getRegionName()));
        }
        HRegion merged = null;
        HLog log = this.utils.getLog();
        HRegion r1 = HRegion.openHRegion(info1, htd, log, this.getConf());
        try {
            HRegion r2 = HRegion.openHRegion(info2, htd, log, this.getConf());
            try {
                merged = HRegion.merge(r1, r2);
            }
            finally {
                if (!r2.isClosed()) {
                    r2.close();
                }
            }
        }
        finally {
            if (!r1.isClosed()) {
                r1.close();
            }
        }
        this.removeRegionFromMeta(meta1, info1);
        this.removeRegionFromMeta(meta2, info2);
        this.mergeInfo = merged.getRegionInfo();
        return merged;
    }

    private void removeRegionFromMeta(HRegion meta, HRegionInfo regioninfo) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing region: " + (Object)((Object)regioninfo) + " from " + meta));
        }
        Delete delete = new Delete(regioninfo.getRegionName(), System.currentTimeMillis(), null);
        meta.delete(delete, null, true);
    }

    private int parseArgs(String[] args) throws IOException {
        GenericOptionsParser parser = new GenericOptionsParser(this.getConf(), args);
        String[] remainingArgs = parser.getRemainingArgs();
        if (remainingArgs.length != 3) {
            this.usage();
            return -1;
        }
        this.tableName = Bytes.toBytes(remainingArgs[0]);
        this.isMetaTable = Bytes.compareTo(this.tableName, HConstants.META_TABLE_NAME) == 0;
        this.region1 = Bytes.toBytesBinary(remainingArgs[1]);
        this.region2 = Bytes.toBytesBinary(remainingArgs[2]);
        int status = 0;
        if (this.notInTable(this.tableName, this.region1) || this.notInTable(this.tableName, this.region2)) {
            status = -1;
        } else if (Bytes.equals(this.region1, this.region2)) {
            LOG.error((Object)"Can't merge a region with itself");
            status = -1;
        }
        return status;
    }

    private boolean notInTable(byte[] tn, byte[] rn) {
        if (WritableComparator.compareBytes((byte[])tn, (int)0, (int)tn.length, (byte[])rn, (int)0, (int)tn.length) != 0) {
            LOG.error((Object)("Region " + Bytes.toStringBinary(rn) + " does not belong to table " + Bytes.toString(tn)));
            return true;
        }
        return false;
    }

    private void usage() {
        System.err.println("For hadoop 0.20,  Usage: bin/hbase org.apache.hadoop.hbase.util.Merge [-Dfs.default.name=hdfs://nn:port] <table-name> <region-1> <region-2>\n");
        System.err.println("For hadoop 0.21+, Usage: bin/hbase org.apache.hadoop.hbase.util.Merge [-Dfs.defaultFS=hdfs://nn:port] <table-name> <region-1> <region-2>\n");
    }

    public static void main(String[] args) {
        int status;
        try {
            status = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new Merge(), (String[])args);
        }
        catch (Exception e) {
            LOG.error((Object)"exiting due to error", (Throwable)e);
            status = -1;
        }
        System.exit(status);
    }

    private static class MetaScannerListener
    implements MetaUtils.ScannerListener {
        private final byte[] region1;
        private final byte[] region2;
        private HRegionInfo meta1 = null;
        private HRegionInfo meta2 = null;

        MetaScannerListener(byte[] region1, byte[] region2) {
            this.region1 = region1;
            this.region2 = region2;
        }

        @Override
        public boolean processRow(HRegionInfo info) {
            if (this.meta1 == null && HRegion.rowIsInRange(info, this.region1)) {
                this.meta1 = info;
            }
            if (this.region2 != null && this.meta2 == null && HRegion.rowIsInRange(info, this.region2)) {
                this.meta2 = info;
            }
            return this.meta1 == null || this.region2 != null && this.meta2 == null;
        }

        HRegionInfo getMeta1() {
            return this.meta1;
        }

        HRegionInfo getMeta2() {
            return this.meta2;
        }
    }
}

