/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.iterator;

import java.util.EnumSet;
import java.util.List;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.hadoop.io.Text;
import org.vertexium.accumulo.iterator.ElementIterator;
import org.vertexium.accumulo.iterator.model.EdgeInfo;
import org.vertexium.accumulo.iterator.model.FetchHint;
import org.vertexium.accumulo.iterator.model.SoftDeleteEdgeInfo;
import org.vertexium.accumulo.iterator.model.VertexElementData;

public class VertexIterator
extends ElementIterator<VertexElementData> {
    public static final String CF_SIGNAL_STRING = "V";
    public static final Text CF_SIGNAL = new Text("V");
    public static final String CF_OUT_EDGE_STRING = "EOUT";
    public static final Text CF_OUT_EDGE = new Text("EOUT");
    public static final String CF_OUT_EDGE_HIDDEN_STRING = "EOUTH";
    public static final Text CF_OUT_EDGE_HIDDEN = new Text("EOUTH");
    public static final String CF_OUT_EDGE_SOFT_DELETE_STRING = "EOUTD";
    public static final Text CF_OUT_EDGE_SOFT_DELETE = new Text("EOUTD");
    public static final String CF_IN_EDGE_STRING = "EIN";
    public static final Text CF_IN_EDGE = new Text("EIN");
    public static final String CF_IN_EDGE_HIDDEN_STRING = "EINH";
    public static final Text CF_IN_EDGE_HIDDEN = new Text("EINH");
    public static final String CF_IN_EDGE_SOFT_DELETE_STRING = "EIND";
    public static final Text CF_IN_EDGE_SOFT_DELETE = new Text("EIND");

    public VertexIterator() {
        this(FetchHint.ALL);
    }

    public VertexIterator(EnumSet<FetchHint> fetchHints) {
        super(null, fetchHints);
    }

    public VertexIterator(SortedKeyValueIterator<Key, Value> source, EnumSet<FetchHint> fetchHints) {
        super(source, fetchHints);
    }

    @Override
    protected boolean populateElementData(List<Key> keys, List<Value> values) {
        boolean ret = super.populateElementData(keys, values);
        if (ret) {
            this.removeHiddenAndSoftDeletes();
        }
        return ret;
    }

    private void removeHiddenAndSoftDeletes() {
        if (!this.getFetchHints().contains((Object)FetchHint.INCLUDE_HIDDEN)) {
            for (Text edgeId : ((VertexElementData)this.getElementData()).hiddenEdges) {
                ((VertexElementData)this.getElementData()).inEdges.remove(edgeId);
                ((VertexElementData)this.getElementData()).outEdges.remove(edgeId);
            }
        }
        for (SoftDeleteEdgeInfo inSoftDelete : ((VertexElementData)this.getElementData()).inSoftDeletes) {
            EdgeInfo inEdge = ((VertexElementData)this.getElementData()).inEdges.get(inSoftDelete.getEdgeId());
            if (inEdge == null || inSoftDelete.getTimestamp() < inEdge.getTimestamp()) continue;
            ((VertexElementData)this.getElementData()).inEdges.remove(inSoftDelete.getEdgeId());
        }
        for (SoftDeleteEdgeInfo outSoftDelete : ((VertexElementData)this.getElementData()).outSoftDeletes) {
            EdgeInfo outEdge = ((VertexElementData)this.getElementData()).outEdges.get(outSoftDelete.getEdgeId());
            if (outEdge == null || outSoftDelete.getTimestamp() < outEdge.getTimestamp()) continue;
            ((VertexElementData)this.getElementData()).outEdges.remove(outSoftDelete.getEdgeId());
        }
    }

    @Override
    protected boolean processColumn(Key key, Value value, Text columnFamily, Text columnQualifier) {
        if (CF_OUT_EDGE.equals((Object)columnFamily)) {
            Text edgeId = key.getColumnQualifier();
            EdgeInfo edgeInfo = EdgeInfo.parse(value, key.getTimestamp());
            ((VertexElementData)this.getElementData()).outEdges.add(edgeId, edgeInfo);
            return true;
        }
        if (CF_IN_EDGE.equals((Object)columnFamily)) {
            Text edgeId = key.getColumnQualifier();
            EdgeInfo edgeInfo = EdgeInfo.parse(value, key.getTimestamp());
            ((VertexElementData)this.getElementData()).inEdges.add(edgeId, edgeInfo);
            return true;
        }
        if (CF_OUT_EDGE_HIDDEN.equals((Object)columnFamily) || CF_IN_EDGE_HIDDEN.equals((Object)columnFamily)) {
            Text edgeId = key.getColumnQualifier();
            ((VertexElementData)this.getElementData()).hiddenEdges.add(edgeId);
            return true;
        }
        if (CF_IN_EDGE_SOFT_DELETE.equals((Object)columnFamily)) {
            Text edgeId = key.getColumnQualifier();
            ((VertexElementData)this.getElementData()).inSoftDeletes.add(new SoftDeleteEdgeInfo(edgeId, key.getTimestamp()));
            return true;
        }
        if (CF_OUT_EDGE_SOFT_DELETE.equals((Object)columnFamily)) {
            Text edgeId = key.getColumnQualifier();
            ((VertexElementData)this.getElementData()).outSoftDeletes.add(new SoftDeleteEdgeInfo(edgeId, key.getTimestamp()));
            return true;
        }
        return false;
    }

    @Override
    protected Text getVisibilitySignal() {
        return CF_SIGNAL;
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        if (this.sourceIter != null) {
            return new VertexIterator((SortedKeyValueIterator<Key, Value>)this.sourceIter.deepCopy(env), this.getFetchHints());
        }
        return new VertexIterator(this.getFetchHints());
    }

    @Override
    protected VertexElementData createElementData() {
        return new VertexElementData();
    }
}

