/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.serializer.kryo;

import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.vertexium.GraphConfiguration;
import org.vertexium.VertexiumException;
import org.vertexium.VertexiumSerializer;
import org.vertexium.serializer.kryo.quickSerializers.BigDecimalQuickTypeSerializer;
import org.vertexium.serializer.kryo.quickSerializers.DateQuickTypeSerializer;
import org.vertexium.serializer.kryo.quickSerializers.DoubleQuickTypeSerializer;
import org.vertexium.serializer.kryo.quickSerializers.KryoQuickTypeSerializer;
import org.vertexium.serializer.kryo.quickSerializers.LongQuickTypeSerializer;
import org.vertexium.serializer.kryo.quickSerializers.QuickTypeSerializer;
import org.vertexium.serializer.kryo.quickSerializers.StringQuickTypeSerializer;

public class QuickKryoVertexiumSerializer
implements VertexiumSerializer {
    private static final byte[] EMPTY = new byte[0];
    public static final String CONFIG_COMPRESS = "serializer.enableCompression";
    public static final boolean CONFIG_COMPRESS_DEFAULT = false;
    private final boolean enableCompression;
    private QuickTypeSerializer defaultQuickTypeSerializer = new KryoQuickTypeSerializer();
    private Map<Class, QuickTypeSerializer> quickTypeSerializersByClass = new HashMap<Class, QuickTypeSerializer>(){
        {
            this.put(String.class, new StringQuickTypeSerializer());
            this.put(Long.class, new LongQuickTypeSerializer());
            this.put(Date.class, new DateQuickTypeSerializer());
            this.put(Double.class, new DoubleQuickTypeSerializer());
            this.put(BigDecimal.class, new BigDecimalQuickTypeSerializer());
        }
    };
    private Map<Byte, QuickTypeSerializer> quickTypeSerializersByMarker = new HashMap<Byte, QuickTypeSerializer>(){
        {
            this.put((byte)0, new KryoQuickTypeSerializer());
            this.put((byte)1, new StringQuickTypeSerializer());
            this.put((byte)2, new LongQuickTypeSerializer());
            this.put((byte)3, new DateQuickTypeSerializer());
            this.put((byte)4, new DoubleQuickTypeSerializer());
            this.put((byte)5, new BigDecimalQuickTypeSerializer());
        }
    };

    public QuickKryoVertexiumSerializer(GraphConfiguration config) {
        this.enableCompression = config.getBoolean(CONFIG_COMPRESS, false);
    }

    public byte[] objectToBytes(Object object) {
        if (object == null) {
            return EMPTY;
        }
        QuickTypeSerializer quickTypeSerializer = this.quickTypeSerializersByClass.get(object.getClass());
        byte[] bytes = quickTypeSerializer != null ? quickTypeSerializer.objectToBytes(object) : this.defaultQuickTypeSerializer.objectToBytes(object);
        return this.compress(bytes);
    }

    public <T> T bytesToObject(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        QuickTypeSerializer quickTypeSerializer = this.quickTypeSerializersByMarker.get((bytes = this.expand(bytes))[0]);
        if (quickTypeSerializer != null) {
            return quickTypeSerializer.valueToObject(bytes);
        }
        throw new VertexiumException("Invalid marker: " + Integer.toHexString(bytes[0]));
    }

    protected byte[] compress(byte[] bytes) {
        if (!this.enableCompression) {
            return bytes;
        }
        try {
            Deflater deflater = new Deflater(9);
            deflater.setInput(bytes);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(bytes.length);
            deflater.finish();
            byte[] buffer = new byte[1024];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            outputStream.close();
            return outputStream.toByteArray();
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not compress bytes", (Throwable)ex);
        }
    }

    protected byte[] expand(byte[] bytes) {
        if (!this.enableCompression) {
            return bytes;
        }
        try {
            Inflater inflater = new Inflater();
            inflater.setInput(bytes);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(bytes.length);
            byte[] buffer = new byte[1024];
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            outputStream.close();
            return outputStream.toByteArray();
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not decompress bytes", (Throwable)ex);
        }
    }
}

