/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.management.MemoryUsage;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.management.openmbean.TabularData;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutorMBean;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.EndpointSnitchInfoMBean;
import org.apache.cassandra.net.MessagingServiceMBean;
import org.apache.cassandra.service.CacheServiceMBean;
import org.apache.cassandra.service.StorageProxyMBean;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.SessionInfo;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeToolHelp;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class NodeCmd {
    private static final String HISTORYFILE = "nodetool.history";
    private static final Pair<String, String> SNAPSHOT_COLUMNFAMILY_OPT = Pair.create("cf", "column-family");
    private static final Pair<String, String> HOST_OPT = Pair.create("h", "host");
    private static final Pair<String, String> PORT_OPT = Pair.create("p", "port");
    private static final Pair<String, String> USERNAME_OPT = Pair.create("u", "username");
    private static final Pair<String, String> PASSWORD_OPT = Pair.create("pw", "password");
    private static final Pair<String, String> TAG_OPT = Pair.create("t", "tag");
    private static final Pair<String, String> TOKENS_OPT = Pair.create("T", "tokens");
    private static final Pair<String, String> PRIMARY_RANGE_OPT = Pair.create("pr", "partitioner-range");
    private static final Pair<String, String> PARALLEL_REPAIR_OPT = Pair.create("par", "parallel");
    private static final Pair<String, String> LOCAL_DC_REPAIR_OPT = Pair.create("local", "in-local-dc");
    private static final Pair<String, String> HOST_REPAIR_OPT = Pair.create("hosts", "in-host");
    private static final Pair<String, String> DC_REPAIR_OPT = Pair.create("dc", "in-dc");
    private static final Pair<String, String> START_TOKEN_OPT = Pair.create("st", "start-token");
    private static final Pair<String, String> END_TOKEN_OPT = Pair.create("et", "end-token");
    private static final Pair<String, String> UPGRADE_ALL_SSTABLE_OPT = Pair.create("a", "include-all-sstables");
    private static final Pair<String, String> NO_SNAPSHOT = Pair.create("ns", "no-snapshot");
    private static final Pair<String, String> CFSTATS_IGNORE_OPT = Pair.create("i", "ignore");
    private static final Pair<String, String> RESOLVE_IP = Pair.create("r", "resolve-ip");
    private static final Pair<String, String> SCRUB_SKIP_CORRUPTED_OPT = Pair.create("s", "skip-corrupted");
    private static final Pair<String, String> COMPACT_OPT = Pair.create("c", "compact");
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 7199;
    private static final ToolOptions options = new ToolOptions();
    private final NodeProbe probe;

    public NodeCmd(NodeProbe probe) {
        this.probe = probe;
    }

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        StringBuilder header = new StringBuilder(512);
        header.append("\nAvailable commands\n");
        NodeToolHelp ntHelp = NodeCmd.loadHelp();
        Collections.sort(ntHelp.commands, new Comparator<NodeToolHelp.NodeToolCommand>(){

            @Override
            public int compare(NodeToolHelp.NodeToolCommand o1, NodeToolHelp.NodeToolCommand o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        for (NodeToolHelp.NodeToolCommand cmd : ntHelp.commands) {
            NodeCmd.addCmdHelp(header, cmd);
        }
        String usage = String.format("java %s --host <arg> <command>%n", NodeCmd.class.getName());
        hf.printHelp(usage, "", (Options)options, "");
        System.out.println(header.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NodeToolHelp loadHelp() {
        InputStream is = NodeCmd.class.getClassLoader().getResourceAsStream("org/apache/cassandra/tools/NodeToolHelp.yaml");
        assert (is != null);
        try {
            Constructor constructor = new Constructor(NodeToolHelp.class);
            Yaml yaml = new Yaml((BaseConstructor)constructor);
            NodeToolHelp nodeToolHelp = (NodeToolHelp)yaml.load(is);
            return nodeToolHelp;
        }
        finally {
            FileUtils.closeQuietly(is);
        }
    }

    private static void addCmdHelp(StringBuilder sb, NodeToolHelp.NodeToolCommand cmd) {
        sb.append("  ").append(cmd.name);
        if (cmd.name.length() <= 20) {
            for (int i = cmd.name.length(); i < 22; ++i) {
                sb.append(" ");
            }
        }
        sb.append(" - ").append(cmd.help);
    }

    public void printRing(PrintStream outs, String keyspace, boolean resolveIp) {
        boolean keyspaceSelected;
        Map<InetAddress, Float> ownerships;
        Map<String, String> tokensToEndpoints = this.probe.getTokenToEndpointMap();
        LinkedHashMultimap endpointsToTokens = LinkedHashMultimap.create();
        for (Map.Entry<String, String> entry : tokensToEndpoints.entrySet()) {
            endpointsToTokens.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        int maxAddressLength = Collections.max(endpointsToTokens.keys(), new Comparator<String>(){

            @Override
            public int compare(String first, String second) {
                return Integer.valueOf(first.length()).compareTo(second.length());
            }
        }).length();
        String formatPlaceholder = "%%-%ds  %%-12s%%-7s%%-8s%%-16s%%-20s%%-44s%%n";
        String format = String.format(formatPlaceholder, maxAddressLength);
        try {
            ownerships = this.probe.effectiveOwnership(keyspace);
            keyspaceSelected = true;
        }
        catch (IllegalStateException ex) {
            ownerships = this.probe.getOwnership();
            outs.printf("Note: Ownership information does not include topology; for complete information, specify a keyspace%n", new Object[0]);
            keyspaceSelected = false;
        }
        try {
            outs.println();
            for (Map.Entry<String, SetHostStat> entry : this.getOwnershipByDc(resolveIp, tokensToEndpoints, ownerships).entrySet()) {
                this.printDc(outs, format, entry.getKey(), (LinkedHashMultimap<String, String>)endpointsToTokens, keyspaceSelected, entry.getValue());
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        if (DatabaseDescriptor.getNumTokens() > 1) {
            outs.println("  Warning: \"nodetool ring\" is used to output all the tokens of a node.");
            outs.println("  To view status related info of a node use \"nodetool status\" instead.\n");
        }
    }

    private void printDc(PrintStream outs, String format, String dc, LinkedHashMultimap<String, String> endpointsToTokens, boolean keyspaceSelected, SetHostStat hoststats) {
        List<String> liveNodes = this.probe.getLiveNodes();
        List<String> deadNodes = this.probe.getUnreachableNodes();
        List<String> joiningNodes = this.probe.getJoiningNodes();
        List<String> leavingNodes = this.probe.getLeavingNodes();
        List<String> movingNodes = this.probe.getMovingNodes();
        Map<String, String> loadMap = this.probe.getLoadMap();
        outs.println("Datacenter: " + dc);
        outs.println("==========");
        ArrayList tokens = new ArrayList();
        String lastToken = "";
        for (HostStat stat : hoststats) {
            tokens.addAll(endpointsToTokens.get((Object)stat.endpoint.getHostAddress()));
            lastToken = (String)tokens.get(tokens.size() - 1);
        }
        outs.printf(format, "Address", "Rack", "Status", "State", "Load", "Owns", "Token");
        if (hoststats.size() > 1) {
            outs.printf(format, "", "", "", "", "", "", lastToken);
        } else {
            outs.println();
        }
        for (HostStat stat : hoststats) {
            String rack;
            String endpoint = stat.endpoint.getHostAddress();
            try {
                rack = this.probe.getEndpointSnitchInfoProxy().getRack(endpoint);
            }
            catch (UnknownHostException e) {
                rack = "Unknown";
            }
            String status = liveNodes.contains(endpoint) ? "Up" : (deadNodes.contains(endpoint) ? "Down" : "?");
            String state = "Normal";
            if (joiningNodes.contains(endpoint)) {
                state = "Joining";
            } else if (leavingNodes.contains(endpoint)) {
                state = "Leaving";
            } else if (movingNodes.contains(endpoint)) {
                state = "Moving";
            }
            String load = loadMap.containsKey(endpoint) ? loadMap.get(endpoint) : "?";
            String owns = stat.owns != null ? new DecimalFormat("##0.00%").format(stat.owns) : "?";
            outs.printf(format, stat.ipOrDns(), rack, status, state, load, owns, stat.token);
        }
        outs.println();
    }

    private Map<String, SetHostStat> getOwnershipByDc(boolean resolveIp, Map<String, String> tokenToEndpoint, Map<InetAddress, Float> ownerships) throws UnknownHostException {
        LinkedHashMap ownershipByDc = Maps.newLinkedHashMap();
        EndpointSnitchInfoMBean epSnitchInfo = this.probe.getEndpointSnitchInfoProxy();
        for (Map.Entry<String, String> tokenAndEndPoint : tokenToEndpoint.entrySet()) {
            String dc = epSnitchInfo.getDatacenter(tokenAndEndPoint.getValue());
            if (!ownershipByDc.containsKey(dc)) {
                ownershipByDc.put(dc, new SetHostStat(resolveIp));
            }
            ((SetHostStat)ownershipByDc.get(dc)).add(tokenAndEndPoint.getKey(), tokenAndEndPoint.getValue(), ownerships);
        }
        return ownershipByDc;
    }

    public void printClusterStatus(PrintStream outs, String keyspace, boolean resolveIp) throws UnknownHostException {
        new ClusterStatus(outs, keyspace, resolveIp).print();
    }

    public void printThreadPoolStats(PrintStream outs) {
        outs.printf("%-25s%10s%10s%15s%10s%18s%n", "Pool Name", "Active", "Pending", "Completed", "Blocked", "All time blocked");
        Iterator<Map.Entry<String, JMXEnabledThreadPoolExecutorMBean>> threads = this.probe.getThreadPoolMBeanProxies();
        while (threads.hasNext()) {
            Map.Entry<String, JMXEnabledThreadPoolExecutorMBean> thread = threads.next();
            String poolName = thread.getKey();
            JMXEnabledThreadPoolExecutorMBean threadPoolProxy = thread.getValue();
            outs.printf("%-25s%10s%10s%15s%10s%18s%n", poolName, threadPoolProxy.getActiveCount(), threadPoolProxy.getPendingTasks(), threadPoolProxy.getCompletedTasks(), threadPoolProxy.getCurrentlyBlockedTasks(), threadPoolProxy.getTotalBlockedTasks());
        }
        outs.printf("%n%-20s%10s%n", "Message type", "Dropped");
        for (Map.Entry<String, Integer> entry : this.probe.getDroppedMessages().entrySet()) {
            outs.printf("%-20s%10s%n", entry.getKey(), entry.getValue());
        }
    }

    public void printInfo(PrintStream outs, ToolCommandLine cmd) {
        boolean gossipInitialized = this.probe.isInitialized();
        List<String> toks = this.probe.getTokens();
        if (toks.size() == 1) {
            outs.printf("%-17s: %s%n", "Token", toks.get(0));
        } else if (!cmd.hasOption((String)NodeCmd.TOKENS_OPT.left)) {
            outs.printf("%-17s: (invoke with -T/--tokens to see all %d tokens)%n", "Token", toks.size());
        }
        outs.printf("%-17s: %s%n", "ID", this.probe.getLocalHostId());
        outs.printf("%-17s: %s%n", "Gossip active", gossipInitialized);
        outs.printf("%-17s: %s%n", "Thrift active", this.probe.isThriftServerRunning());
        outs.printf("%-17s: %s%n", "Native Transport active", this.probe.isNativeTransportRunning());
        outs.printf("%-17s: %s%n", "Load", this.probe.getLoadString());
        if (gossipInitialized) {
            outs.printf("%-17s: %s%n", "Generation No", this.probe.getCurrentGenerationNumber());
        } else {
            outs.printf("%-17s: %s%n", "Generation No", 0);
        }
        long secondsUp = this.probe.getUptime() / 1000L;
        outs.printf("%-17s: %d%n", "Uptime (seconds)", secondsUp);
        MemoryUsage heapUsage = this.probe.getHeapMemoryUsage();
        double memUsed = (double)heapUsage.getUsed() / 1048576.0;
        double memMax = (double)heapUsage.getMax() / 1048576.0;
        outs.printf("%-17s: %.2f / %.2f%n", "Heap Memory (MB)", memUsed, memMax);
        outs.printf("%-17s: %s%n", "Data Center", this.probe.getDataCenter());
        outs.printf("%-17s: %s%n", "Rack", this.probe.getRack());
        outs.printf("%-17s: %s%n", "Exceptions", this.probe.getExceptionCount());
        CacheServiceMBean cacheService = this.probe.getCacheServiceMBean();
        outs.printf("%-17s: size %d (bytes), capacity %d (bytes), %d hits, %d requests, %.3f recent hit rate, %d save period in seconds%n", "Key Cache", cacheService.getKeyCacheSize(), cacheService.getKeyCacheCapacityInBytes(), cacheService.getKeyCacheHits(), cacheService.getKeyCacheRequests(), cacheService.getKeyCacheRecentHitRate(), cacheService.getKeyCacheSavePeriodInSeconds());
        outs.printf("%-17s: size %d (bytes), capacity %d (bytes), %d hits, %d requests, %.3f recent hit rate, %d save period in seconds%n", "Row Cache", cacheService.getRowCacheSize(), cacheService.getRowCacheCapacityInBytes(), cacheService.getRowCacheHits(), cacheService.getRowCacheRequests(), cacheService.getRowCacheRecentHitRate(), cacheService.getRowCacheSavePeriodInSeconds());
        if (toks.size() > 1 && cmd.hasOption((String)NodeCmd.TOKENS_OPT.left)) {
            for (String tok : toks) {
                outs.printf("%-17s: %s%n", "Token", tok);
            }
        }
    }

    public void printReleaseVersion(PrintStream outs) {
        outs.println("ReleaseVersion: " + this.probe.getReleaseVersion());
    }

    public void printNetworkStats(InetAddress addr, PrintStream outs) {
        outs.printf("Mode: %s%n", this.probe.getOperationMode());
        Set<StreamState> statuses = this.probe.getStreamStatus();
        if (statuses.isEmpty()) {
            outs.println("Not sending any streams.");
        }
        for (StreamState status : statuses) {
            outs.printf("%s %s%n", status.description, status.planId.toString());
            for (SessionInfo info : status.sessions) {
                outs.printf("    %s%n", info.peer.toString());
                if (!info.receivingSummaries.isEmpty()) {
                    outs.printf("        Receiving %d files, %d bytes total%n", info.getTotalFilesToReceive(), info.getTotalSizeToReceive());
                    for (ProgressInfo progress : info.getReceivingFiles()) {
                        outs.printf("            %s%n", progress.toString());
                    }
                }
                if (info.sendingSummaries.isEmpty()) continue;
                outs.printf("        Sending %d files, %d bytes total%n", info.getTotalFilesToSend(), info.getTotalSizeToSend());
                for (ProgressInfo progress : info.getSendingFiles()) {
                    outs.printf("            %s%n", progress.toString());
                }
            }
        }
        outs.printf("Read Repair Statistics:%nAttempted: %d%nMismatch (Blocking): %d%nMismatch (Background): %d%n", this.probe.getReadRepairAttempted(), this.probe.getReadRepairRepairedBlocking(), this.probe.getReadRepairRepairedBackground());
        MessagingServiceMBean ms = this.probe.msProxy;
        outs.printf("%-25s", "Pool Name");
        outs.printf("%10s", "Active");
        outs.printf("%10s", "Pending");
        outs.printf("%15s%n", "Completed");
        int pending = 0;
        Iterator<Serializable> i$ = ms.getCommandPendingTasks().values().iterator();
        while (i$.hasNext()) {
            int n = (Integer)i$.next();
            pending += n;
        }
        long completed = 0L;
        i$ = ms.getCommandCompletedTasks().values().iterator();
        while (i$.hasNext()) {
            long n = (Long)i$.next();
            completed += n;
        }
        outs.printf("%-25s%10s%10s%15s%n", "Commands", "n/a", pending, completed);
        pending = 0;
        i$ = ms.getResponsePendingTasks().values().iterator();
        while (i$.hasNext()) {
            int n = (Integer)i$.next();
            pending += n;
        }
        completed = 0L;
        i$ = ms.getResponseCompletedTasks().values().iterator();
        while (i$.hasNext()) {
            long n = (Long)i$.next();
            completed += n;
        }
        outs.printf("%-25s%10s%10s%15s%n", "Responses", "n/a", pending, completed);
    }

    public void printCompactionStats(PrintStream outs) {
        int compactionThroughput = this.probe.getCompactionThroughput();
        CompactionManagerMBean cm = this.probe.getCompactionManagerProxy();
        outs.println("pending tasks: " + cm.getPendingTasks());
        if (cm.getCompactions().size() > 0) {
            outs.printf("%25s%16s%16s%16s%16s%10s%10s%n", "compaction type", "keyspace", "table", "completed", "total", "unit", "progress");
        }
        long remainingBytes = 0L;
        for (Map<String, String> c : cm.getCompactions()) {
            String percentComplete = new Long(c.get("total")) == 0L ? "n/a" : new DecimalFormat("0.00").format((double)new Long(c.get("completed")).longValue() / (double)new Long(c.get("total")).longValue() * 100.0) + "%";
            outs.printf("%25s%16s%16s%16s%16s%10s%10s%n", c.get("taskType"), c.get("keyspace"), c.get("columnfamily"), c.get("completed"), c.get("total"), c.get("unit"), percentComplete);
            if (!c.get("taskType").equals(OperationType.COMPACTION.toString())) continue;
            remainingBytes += new Long(c.get("total")) - new Long(c.get("completed"));
        }
        long remainingTimeInSecs = compactionThroughput == 0 || remainingBytes == 0L ? -1L : remainingBytes / (0x100000L * (long)compactionThroughput);
        String remainingTime = remainingTimeInSecs < 0L ? "n/a" : String.format("%dh%02dm%02ds", remainingTimeInSecs / 3600L, remainingTimeInSecs % 3600L / 60L, remainingTimeInSecs % 60L);
        outs.printf("%25s%10s%n", "Active compaction remaining time : ", remainingTime);
    }

    public void printCompactionThreshold(PrintStream outs, String ks, String cf) {
        ColumnFamilyStoreMBean cfsProxy = this.probe.getCfsProxy(ks, cf);
        outs.println("Current compaction thresholds for " + ks + "/" + cf + ": \n" + " min = " + cfsProxy.getMinimumCompactionThreshold() + ", " + " max = " + cfsProxy.getMaximumCompactionThreshold());
    }

    public void printCompactionThroughput(PrintStream outs) {
        outs.println("Current compaction throughput: " + this.probe.getCompactionThroughput() + " MB/s");
    }

    public void printStreamThroughput(PrintStream outs) {
        outs.println("Current stream throughput: " + this.probe.getStreamThroughput() + " MB/s");
    }

    public void printClusterDescription(PrintStream outs, String host) {
        outs.println("Cluster Information:");
        outs.println("\tName: " + this.probe.getClusterName());
        outs.println("\tSnitch: " + this.probe.getEndpointSnitchInfoProxy().getSnitchName());
        outs.println("\tPartitioner: " + this.probe.getPartitioner());
        outs.println("\tSchema versions:");
        Map<String, List<String>> schemaVersions = this.probe.getSpProxy().getSchemaVersions();
        for (String version : schemaVersions.keySet()) {
            outs.println(String.format("\t\t%s: %s%n", version, schemaVersions.get(version)));
        }
    }

    public void printColumnFamilyStats(PrintStream outs, boolean ignoreMode, String[] filterList) {
        ArrayList<ColumnFamilyStoreMBean> columnFamilies;
        OptionFilter filter = new OptionFilter(ignoreMode, filterList);
        HashMap cfstoreMap = new HashMap();
        Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> cfamilies = this.probe.getColumnFamilyStoreMBeanProxies();
        while (cfamilies.hasNext()) {
            Map.Entry<String, ColumnFamilyStoreMBean> entry = cfamilies.next();
            String keyspaceName = entry.getKey();
            ColumnFamilyStoreMBean cfsProxy = entry.getValue();
            if (!cfstoreMap.containsKey(keyspaceName) && filter.isColumnFamilyIncluded(entry.getKey(), cfsProxy.getColumnFamilyName())) {
                columnFamilies = new ArrayList<ColumnFamilyStoreMBean>();
                columnFamilies.add(cfsProxy);
                cfstoreMap.put(keyspaceName, columnFamilies);
                continue;
            }
            if (!filter.isColumnFamilyIncluded(entry.getKey(), cfsProxy.getColumnFamilyName())) continue;
            ((List)cfstoreMap.get(keyspaceName)).add(cfsProxy);
        }
        filter.verifyKeyspaces(this.probe.getKeyspaces());
        filter.verifyColumnFamilies();
        for (Map.Entry entry : cfstoreMap.entrySet()) {
            String keyspaceName = (String)entry.getKey();
            columnFamilies = (ArrayList<ColumnFamilyStoreMBean>)entry.getValue();
            long keyspaceReadCount = 0L;
            long keyspaceWriteCount = 0L;
            int keyspacePendingTasks = 0;
            double keyspaceTotalReadTime = 0.0;
            double keyspaceTotalWriteTime = 0.0;
            outs.println("Keyspace: " + keyspaceName);
            for (ColumnFamilyStoreMBean cfstore : columnFamilies) {
                long writeCount = cfstore.getWriteCount();
                long readCount = cfstore.getReadCount();
                if (readCount > 0L) {
                    keyspaceReadCount += readCount;
                    keyspaceTotalReadTime += (double)cfstore.getTotalReadLatencyMicros();
                }
                if (writeCount > 0L) {
                    keyspaceWriteCount += writeCount;
                    keyspaceTotalWriteTime += (double)cfstore.getTotalWriteLatencyMicros();
                }
                keyspacePendingTasks += cfstore.getPendingTasks();
            }
            double keyspaceReadLatency = keyspaceReadCount > 0L ? keyspaceTotalReadTime / (double)keyspaceReadCount / 1000.0 : Double.NaN;
            double keyspaceWriteLatency = keyspaceWriteCount > 0L ? keyspaceTotalWriteTime / (double)keyspaceWriteCount / 1000.0 : Double.NaN;
            outs.println("\tRead Count: " + keyspaceReadCount);
            outs.println("\tRead Latency: " + String.format("%s", keyspaceReadLatency) + " ms.");
            outs.println("\tWrite Count: " + keyspaceWriteCount);
            outs.println("\tWrite Latency: " + String.format("%s", keyspaceWriteLatency) + " ms.");
            outs.println("\tPending Tasks: " + keyspacePendingTasks);
            for (ColumnFamilyStoreMBean cfstore : columnFamilies) {
                String cfName = cfstore.getColumnFamilyName();
                if (cfName.contains(".")) {
                    outs.println("\t\tTable (index): " + cfName);
                } else {
                    outs.println("\t\tTable: " + cfName);
                }
                outs.println("\t\tSSTable count: " + cfstore.getLiveSSTableCount());
                int[] leveledSStables = cfstore.getSSTableCountPerLevel();
                if (leveledSStables != null) {
                    outs.print("\t\tSSTables in each level: [");
                    for (int level = 0; level < leveledSStables.length; ++level) {
                        int count = leveledSStables[level];
                        outs.print(count);
                        long maxCount = 4L;
                        if (level > 0) {
                            maxCount = (long)Math.pow(10.0, level);
                        }
                        if ((long)count > maxCount) {
                            outs.print("/" + maxCount);
                        }
                        if (level < leveledSStables.length - 1) {
                            outs.print(", ");
                            continue;
                        }
                        outs.println("]");
                    }
                }
                outs.println("\t\tSpace used (live), bytes: " + cfstore.getLiveDiskSpaceUsed());
                outs.println("\t\tSpace used (total), bytes: " + cfstore.getTotalDiskSpaceUsed());
                outs.println("\t\tSSTable Compression Ratio: " + cfstore.getCompressionRatio());
                outs.println("\t\tNumber of keys (estimate): " + cfstore.estimateKeys());
                outs.println("\t\tMemtable cell count: " + cfstore.getMemtableColumnsCount());
                outs.println("\t\tMemtable data size, bytes: " + cfstore.getMemtableDataSize());
                outs.println("\t\tMemtable switch count: " + cfstore.getMemtableSwitchCount());
                outs.println("\t\tLocal read count: " + cfstore.getReadCount());
                outs.printf("\t\tLocal read latency: %01.3f ms%n", cfstore.getRecentReadLatencyMicros() / 1000.0);
                outs.println("\t\tLocal write count: " + cfstore.getWriteCount());
                outs.printf("\t\tLocal write latency: %01.3f ms%n", cfstore.getRecentWriteLatencyMicros() / 1000.0);
                outs.println("\t\tPending tasks: " + cfstore.getPendingTasks());
                outs.println("\t\tBloom filter false positives: " + cfstore.getBloomFilterFalsePositives());
                outs.println("\t\tBloom filter false ratio: " + String.format("%01.5f", cfstore.getRecentBloomFilterFalseRatio()));
                outs.println("\t\tBloom filter space used, bytes: " + cfstore.getBloomFilterDiskSpaceUsed());
                outs.println("\t\tCompacted partition minimum bytes: " + cfstore.getMinRowSize());
                outs.println("\t\tCompacted partition maximum bytes: " + cfstore.getMaxRowSize());
                outs.println("\t\tCompacted partition mean bytes: " + cfstore.getMeanRowSize());
                outs.println("\t\tAverage live cells per slice (last five minutes): " + cfstore.getLiveCellsPerSlice());
                outs.println("\t\tAverage tombstones per slice (last five minutes): " + cfstore.getTombstonesPerSlice());
                outs.println("");
            }
            outs.println("----------------");
        }
    }

    public void printRemovalStatus(PrintStream outs) {
        outs.println("RemovalStatus: " + this.probe.getRemovalStatus());
    }

    private Pair<Integer, Integer> getDataBounds(long[] data) {
        int lowestIndex = -1;
        int highestIndex = -1;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] <= 0L) continue;
            highestIndex = i;
            if (lowestIndex != -1) continue;
            lowestIndex = i;
        }
        return Pair.create(lowestIndex, highestIndex);
    }

    private void printHistogram(long[] data, long[] offsets, String unit, PrintStream output) {
        Pair<Integer, Integer> bounds = this.getDataBounds(data);
        if ((Integer)bounds.left == -1) {
            output.println("No Data");
        } else {
            long maxValue = -1L;
            for (int i = ((Integer)bounds.left).intValue(); i <= (Integer)bounds.right; ++i) {
                maxValue = Math.max(maxValue, offsets[i]);
            }
            String format = "%" + new Long(maxValue).toString().length() + "d %s: %d";
            for (int i = ((Integer)bounds.left).intValue(); i <= (Integer)bounds.right; ++i) {
                output.println(String.format(format, offsets[i], unit, data[i]));
            }
        }
        output.println("");
    }

    private void printCfHistograms(String keySpace, String columnFamily, PrintStream output, boolean compactFormat) {
        ColumnFamilyStoreMBean store = this.probe.getCfsProxy(keySpace, columnFamily);
        long[] offsets = new EstimatedHistogram().getBucketOffsets();
        long[] rrlh = store.getRecentReadLatencyHistogramMicros();
        long[] rwlh = store.getRecentWriteLatencyHistogramMicros();
        long[] sprh = store.getRecentSSTablesPerReadHistogram();
        long[] ersh = store.getEstimatedRowSizeHistogram();
        long[] ecch = store.getEstimatedColumnCountHistogram();
        output.println(String.format("%s/%s histograms", keySpace, columnFamily));
        output.println("");
        if (compactFormat) {
            output.println(String.format("%-10s%10s%18s%18s%18s%18s", "Offset", "SSTables", "Write Latency", "Read Latency", "Partition Size", "Cell Count"));
            output.println(String.format("%-10s%10s%18s%18s%18s%18s", "", "", "(micros)", "(micros)", "(bytes)", ""));
            for (int i = 0; i < offsets.length; ++i) {
                output.println(String.format("%-10d%10s%18s%18s%18s%18s", offsets[i], i < sprh.length ? Long.valueOf(sprh[i]) : "0", i < rwlh.length ? Long.valueOf(rwlh[i]) : "0", i < rrlh.length ? Long.valueOf(rrlh[i]) : "0", i < ersh.length ? Long.valueOf(ersh[i]) : "0", i < ecch.length ? Long.valueOf(ecch[i]) : "0"));
            }
        } else {
            output.println("SSTables per Read");
            this.printHistogram(sprh, offsets, "sstables", output);
            output.println("Write Latency (microseconds)");
            this.printHistogram(rwlh, offsets, "us", output);
            output.println("Read Latency (microseconds)");
            this.printHistogram(rrlh, offsets, "us", output);
            output.println("Partition Size (bytes)");
            this.printHistogram(ersh, offsets, "bytes", output);
            output.println("Cell Count per Partition");
            this.printHistogram(ecch, offsets, "cells", output);
        }
    }

    private void printProxyHistograms(PrintStream output, boolean compactFormat) {
        StorageProxyMBean sp = this.probe.getSpProxy();
        long[] offsets = new EstimatedHistogram().getBucketOffsets();
        long[] rrlh = sp.getRecentReadLatencyHistogramMicros();
        long[] rwlh = sp.getRecentWriteLatencyHistogramMicros();
        long[] rrnglh = sp.getRecentRangeLatencyHistogramMicros();
        output.println("proxy histograms");
        output.println("");
        if (compactFormat) {
            output.println(String.format("%-10s%18s%18s%18s", "Offset", "Read Latency", "Write Latency", "Range Latency"));
            for (int i = 0; i < offsets.length; ++i) {
                output.println(String.format("%-10d%18s%18s%18s", offsets[i], i < rrlh.length ? Long.valueOf(rrlh[i]) : "0", i < rwlh.length ? Long.valueOf(rwlh[i]) : "0", i < rrnglh.length ? Long.valueOf(rrnglh[i]) : "0"));
            }
        } else {
            output.println("Read Latency (microseconds)");
            this.printHistogram(rrlh, offsets, "us", output);
            output.println("Write Latency (microseconds)");
            this.printHistogram(rwlh, offsets, "us", output);
            output.println("Range Latency (microseconds)");
            this.printHistogram(rrnglh, offsets, "us", output);
        }
    }

    private void printEndPoints(String keySpace, String cf, String key, PrintStream output) {
        List<InetAddress> endpoints = this.probe.getEndpoints(keySpace, cf, key);
        for (InetAddress anEndpoint : endpoints) {
            output.println(anEndpoint.getHostAddress());
        }
    }

    private void printSSTables(String keyspace, String cf, String key, PrintStream output) {
        List<String> sstables = this.probe.getSSTables(keyspace, cf, key);
        for (String sstable : sstables) {
            output.println(sstable);
        }
    }

    private void printIsNativeTransportRunning(PrintStream outs) {
        outs.println(this.probe.isNativeTransportRunning() ? "running" : "not running");
    }

    private void printIsThriftServerRunning(PrintStream outs) {
        outs.println(this.probe.isThriftServerRunning() ? "running" : "not running");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] args) throws IOException, InterruptedException, ParseException {
        parser = new PosixParser();
        cmd = null;
        try {
            cmd = new ToolCommandLine(parser.parse((Options)NodeCmd.options, args));
        }
        catch (ParseException p) {
            NodeCmd.badUse(p.getMessage());
        }
        host = cmd.hasOption((String)NodeCmd.HOST_OPT.left) != false ? cmd.getOptionValue((String)NodeCmd.HOST_OPT.left) : "127.0.0.1";
        port = 7199;
        portNum = cmd.getOptionValue((String)NodeCmd.PORT_OPT.left);
        if (portNum != null) {
            try {
                port = Integer.parseInt(portNum);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Port must be a number");
            }
        }
        command = null;
        try {
            command = cmd.getCommand();
        }
        catch (IllegalArgumentException e) {
            NodeCmd.badUse(e.getMessage());
        }
        if (NodeCommand.HELP.equals((Object)command)) {
            NodeCmd.printUsage();
            System.exit(0);
        }
        probe = null;
        try {
            username = cmd.getOptionValue((String)NodeCmd.USERNAME_OPT.left);
            password = cmd.getOptionValue((String)NodeCmd.PASSWORD_OPT.left);
            try {
                probe = username == null ? new NodeProbe(host, port) : new NodeProbe(host, port, username, password);
            }
            catch (IOException ioe) {
                inner = NodeCmd.findInnermostThrowable(ioe);
                if (inner instanceof ConnectException) {
                    System.err.printf("Failed to connect to '%s:%d': %s%n", new Object[]{host, port, inner.getMessage()});
                    System.exit(1);
                }
                if (inner instanceof UnknownHostException) {
                    System.err.printf("Cannot resolve '%s': unknown host%n", new Object[]{host});
                    System.exit(1);
                }
                NodeCmd.err(ioe, "Error connecting to remote JMX agent!");
            }
            nodeCmd = new NodeCmd(probe);
            NodeCmd.printHistory(args, cmd);
            arguments = cmd.getCommandArguments();
            columnFamilyName = null;
            switch (3.$SwitchMap$org$apache$cassandra$tools$NodeCmd$NodeCommand[command.ordinal()]) {
                case 1: {
                    resolveIp = cmd.hasOption((String)NodeCmd.RESOLVE_IP.left);
                    if (arguments.length > 0) {
                        nodeCmd.printRing(System.out, arguments[0], resolveIp);
                        ** break;
lbl56:
                        // 1 sources

                    } else {
                        nodeCmd.printRing(System.out, null, resolveIp);
                        ** break;
                    }
lbl59:
                    // 1 sources

                    break;
                }
                case 2: {
                    nodeCmd.printInfo(System.out, cmd);
                    ** break;
lbl63:
                    // 1 sources

                    break;
                }
                case 3: {
                    ignoreMode = cmd.hasOption((String)NodeCmd.CFSTATS_IGNORE_OPT.left);
                    if (arguments.length > 0) {
                        nodeCmd.printColumnFamilyStats(System.out, ignoreMode, arguments);
                        ** break;
lbl69:
                        // 1 sources

                    } else {
                        nodeCmd.printColumnFamilyStats(System.out, false, null);
                        ** break;
                    }
lbl72:
                    // 1 sources

                    break;
                }
                case 4: {
                    nodeCmd.printThreadPoolStats(System.out);
                    ** break;
lbl76:
                    // 1 sources

                    break;
                }
                case 5: {
                    nodeCmd.printReleaseVersion(System.out);
                    ** break;
lbl80:
                    // 1 sources

                    break;
                }
                case 6: {
                    nodeCmd.printCompactionStats(System.out);
                    ** break;
lbl84:
                    // 1 sources

                    break;
                }
                case 7: {
                    nodeCmd.printCompactionHistory(System.out);
                    ** break;
lbl88:
                    // 1 sources

                    break;
                }
                case 8: {
                    nodeCmd.printClusterDescription(System.out, host);
                    ** break;
lbl92:
                    // 1 sources

                    break;
                }
                case 9: {
                    probe.stopNativeTransport();
                    ** break;
lbl96:
                    // 1 sources

                    break;
                }
                case 10: {
                    probe.startNativeTransport();
                    ** break;
lbl100:
                    // 1 sources

                    break;
                }
                case 11: {
                    nodeCmd.printIsNativeTransportRunning(System.out);
                    ** break;
lbl104:
                    // 1 sources

                    break;
                }
                case 12: {
                    probe.stopGossiping();
                    ** break;
lbl108:
                    // 1 sources

                    break;
                }
                case 13: {
                    probe.startGossiping();
                    ** break;
lbl112:
                    // 1 sources

                    break;
                }
                case 14: {
                    probe.disableHintedHandoff();
                    ** break;
lbl116:
                    // 1 sources

                    break;
                }
                case 15: {
                    if (arguments.length > 0) {
                        probe.enableHintedHandoff(arguments[0]);
                        ** break;
lbl121:
                        // 1 sources

                    } else {
                        probe.enableHintedHandoff();
                        ** break;
                    }
lbl124:
                    // 1 sources

                    break;
                }
                case 16: {
                    probe.pauseHintsDelivery();
                    ** break;
lbl128:
                    // 1 sources

                    break;
                }
                case 17: {
                    probe.resumeHintsDelivery();
                    ** break;
lbl132:
                    // 1 sources

                    break;
                }
                case 18: {
                    probe.stopThriftServer();
                    ** break;
lbl136:
                    // 1 sources

                    break;
                }
                case 19: {
                    probe.startThriftServer();
                    ** break;
lbl140:
                    // 1 sources

                    break;
                }
                case 20: {
                    nodeCmd.printIsThriftServerRunning(System.out);
                    ** break;
lbl144:
                    // 1 sources

                    break;
                }
                case 21: {
                    probe.resetLocalSchema();
                    ** break;
lbl148:
                    // 1 sources

                    break;
                }
                case 22: {
                    probe.setIncrementalBackupsEnabled(true);
                    ** break;
lbl152:
                    // 1 sources

                    break;
                }
                case 23: {
                    probe.setIncrementalBackupsEnabled(false);
                    ** break;
lbl156:
                    // 1 sources

                    break;
                }
                case 24: {
                    if (arguments.length > 1) {
                        NodeCmd.badUse("Too many arguments.");
                        ** break;
lbl161:
                        // 1 sources

                    } else if (arguments.length == 1) {
                        probe.truncateHints(arguments[0]);
                        ** break;
lbl165:
                        // 1 sources

                    } else {
                        probe.truncateHints();
                        ** break;
                    }
lbl168:
                    // 1 sources

                    break;
                }
                case 25: {
                    resolveIp = cmd.hasOption((String)NodeCmd.RESOLVE_IP.left);
                    if (arguments.length > 0) {
                        nodeCmd.printClusterStatus(System.out, arguments[0], resolveIp);
                        ** break;
lbl174:
                        // 1 sources

                    } else {
                        nodeCmd.printClusterStatus(System.out, null, resolveIp);
                        ** break;
                    }
lbl177:
                    // 1 sources

                    break;
                }
                case 26: {
                    if (arguments.length > 0) {
                        System.err.println("Decommission will decommission the node you are connected to and does not take arguments!");
                        System.exit(1);
                    }
                    probe.decommission();
                    ** break;
lbl184:
                    // 1 sources

                    break;
                }
                case 27: {
                    try {
                        probe.drain();
                        ** break;
lbl189:
                        // 1 sources

                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occured during flushing");
                        ** break;
                    }
lbl193:
                    // 1 sources

                    break;
                }
                case 28: {
                    if (arguments.length > 0) {
                        nodeCmd.printNetworkStats(InetAddress.getByName(arguments[0]), System.out);
                        ** break;
lbl198:
                        // 1 sources

                    } else {
                        nodeCmd.printNetworkStats(null, System.out);
                        ** break;
                    }
lbl201:
                    // 1 sources

                    break;
                }
                case 29: {
                    columnFamilyName = cmd.getOptionValue((String)NodeCmd.SNAPSHOT_COLUMNFAMILY_OPT.left);
                }
                case 30: {
                    tag = cmd.getOptionValue((String)NodeCmd.TAG_OPT.left);
                    NodeCmd.handleSnapshots(command, tag, arguments, columnFamilyName, probe);
                    ** break;
lbl208:
                    // 1 sources

                    break;
                }
                case 31: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing token argument for move.");
                    }
                    try {
                        probe.move(arguments[0]);
                        ** break;
lbl215:
                        // 1 sources

                    }
                    catch (UnsupportedOperationException uoerror) {
                        System.err.println(uoerror.getMessage());
                        System.exit(1);
                        ** break;
                    }
lbl220:
                    // 1 sources

                    break;
                }
                case 32: {
                    if (probe.isJoined()) {
                        System.err.println("This node has already joined the ring.");
                        System.exit(1);
                    }
                    probe.joinRing();
                    ** break;
lbl227:
                    // 1 sources

                    break;
                }
                case 33: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing value argument.");
                    }
                    probe.setCompactionThroughput(Integer.parseInt(arguments[0]));
                    ** break;
lbl233:
                    // 1 sources

                    break;
                }
                case 34: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing value argument.");
                    }
                    probe.setStreamThroughput(Integer.parseInt(arguments[0]));
                    ** break;
lbl239:
                    // 1 sources

                    break;
                }
                case 35: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing value argument.");
                    }
                    probe.setTraceProbability(Double.parseDouble(arguments[0]));
                    ** break;
lbl245:
                    // 1 sources

                    break;
                }
                case 36: {
                    if (arguments.length < 1) {
                        NodeCmd.badUse("Must supply at least one token to take");
                    }
                    probe.takeTokens(arguments);
                    ** break;
lbl251:
                    // 1 sources

                    break;
                }
                case 37: {
                    if (arguments.length > 1) {
                        NodeCmd.badUse("Too many arguments.");
                    }
                    probe.rebuild(arguments.length == 1 ? arguments[0] : null);
                    ** break;
lbl257:
                    // 1 sources

                    break;
                }
                case 38: {
                    System.err.println("Warn: removetoken is deprecated, please use removenode instead");
                }
                case 39: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing an argument for removenode (either status, force, or an ID)");
                        ** break;
lbl264:
                        // 1 sources

                    } else if (arguments[0].equals("status")) {
                        nodeCmd.printRemovalStatus(System.out);
                        ** break;
lbl268:
                        // 1 sources

                    } else if (arguments[0].equals("force")) {
                        nodeCmd.printRemovalStatus(System.out);
                        probe.forceRemoveCompletion();
                        ** break;
lbl273:
                        // 1 sources

                    } else {
                        probe.removeNode(arguments[0]);
                        ** break;
                    }
lbl276:
                    // 1 sources

                    break;
                }
                case 40: {
                    probe.invalidateKeyCache();
                    ** break;
lbl280:
                    // 1 sources

                    break;
                }
                case 41: {
                    probe.invalidateRowCache();
                    ** break;
lbl284:
                    // 1 sources

                    break;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    NodeCmd.optionalKSandCFs(command, cmd, arguments, probe);
                    ** break;
lbl288:
                    // 1 sources

                    break;
                }
                case 50: {
                    if (arguments.length != 2) {
                        NodeCmd.badUse("getcompactionthreshold requires ks and cf args.");
                    }
                    nodeCmd.printCompactionThreshold(System.out, arguments[0], arguments[1]);
                    ** break;
lbl294:
                    // 1 sources

                    break;
                }
                case 51: {
                    nodeCmd.printCompactionThroughput(System.out);
                    ** break;
lbl298:
                    // 1 sources

                    break;
                }
                case 52: {
                    nodeCmd.printStreamThroughput(System.out);
                    ** break;
lbl302:
                    // 1 sources

                    break;
                }
                case 53: {
                    if (arguments.length != 2) {
                        NodeCmd.badUse("cfhistograms requires ks and cf args");
                    }
                    nodeCmd.printCfHistograms(arguments[0], arguments[1], System.out, cmd.hasOption((String)NodeCmd.COMPACT_OPT.left));
                    ** break;
lbl308:
                    // 1 sources

                    break;
                }
                case 54: {
                    if (arguments.length != 2) {
                        NodeCmd.badUse("setcachecapacity requires key-cache-capacity, and row-cache-capacity args.");
                    }
                    probe.setCacheCapacities(Integer.parseInt(arguments[0]), Integer.parseInt(arguments[1]));
                    ** break;
lbl314:
                    // 1 sources

                    break;
                }
                case 55: {
                    if (arguments.length != 2) {
                        NodeCmd.badUse("setcachekeystosave requires key-cache-keys-to-save, and row-cache-keys-to-save args.");
                    }
                    probe.setCacheKeysToSave(Integer.parseInt(arguments[0]), Integer.parseInt(arguments[1]));
                    ** break;
lbl320:
                    // 1 sources

                    break;
                }
                case 56: {
                    if (arguments.length != 4) {
                        NodeCmd.badUse("setcompactionthreshold requires ks, cf, min, and max threshold args.");
                    }
                    minthreshold = Integer.parseInt(arguments[2]);
                    maxthreshold = Integer.parseInt(arguments[3]);
                    if (minthreshold < 0 || maxthreshold < 0) {
                        NodeCmd.badUse("Thresholds must be positive integers");
                    }
                    if (minthreshold > maxthreshold) {
                        NodeCmd.badUse("Min threshold cannot be greater than max.");
                    }
                    if (minthreshold < 2 && maxthreshold != 0) {
                        NodeCmd.badUse("Min threshold must be at least 2");
                    }
                    probe.setCompactionThreshold(arguments[0], arguments[1], minthreshold, maxthreshold);
                    ** break;
lbl334:
                    // 1 sources

                    break;
                }
                case 57: {
                    if (arguments.length != 3) {
                        NodeCmd.badUse("getendpoints requires ks, cf and key args");
                    }
                    nodeCmd.printEndPoints(arguments[0], arguments[1], arguments[2], System.out);
                    ** break;
lbl340:
                    // 1 sources

                    break;
                }
                case 58: {
                    if (arguments.length != 0) {
                        NodeCmd.badUse("proxyhistograms does not take arguments");
                    }
                    nodeCmd.printProxyHistograms(System.out, cmd.hasOption((String)NodeCmd.COMPACT_OPT.left));
                    ** break;
lbl346:
                    // 1 sources

                    break;
                }
                case 59: {
                    if (arguments.length != 3) {
                        NodeCmd.badUse("getsstables requires ks, cf and key args");
                    }
                    nodeCmd.printSSTables(arguments[0], arguments[1], arguments[2], System.out);
                    ** break;
lbl352:
                    // 1 sources

                    break;
                }
                case 60: {
                    if (arguments.length != 2) {
                        NodeCmd.badUse("load_new_sstables requires ks and cf args");
                    }
                    probe.loadNewSSTables(arguments[0], arguments[1]);
                    ** break;
lbl358:
                    // 1 sources

                    break;
                }
                case 61: {
                    if (arguments.length <= 2) {
                        NodeCmd.badUse("rebuild_index requires ks, cf and idx args");
                    }
                    probe.rebuildIndex(arguments[0], arguments[1], arguments[2].split(","));
                    ** break;
lbl364:
                    // 1 sources

                    break;
                }
                case 62: {
                    nodeCmd.printGossipInfo(System.out);
                    ** break;
lbl368:
                    // 1 sources

                    break;
                }
                case 63: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("stop requires a type.");
                    }
                    probe.stop(arguments[0].toUpperCase());
                    ** break;
lbl374:
                    // 1 sources

                    break;
                }
                case 64: {
                    if (arguments.length != 0) {
                        NodeCmd.badUse("stopdaemon does not take arguments.");
                    }
                    try {
                        probe.stopCassandraDaemon();
                        ** break;
lbl381:
                        // 1 sources

                    }
                    catch (Throwable t) {
                        System.out.println("Cassandra has shut down.\n");
                        ** break;
                    }
lbl385:
                    // 1 sources

                    break;
                }
                case 65: {
                    if (arguments.length != 1) {
                        NodeCmd.badUse("Missing keyspace argument for describering.");
                    }
                    nodeCmd.printDescribeRing(arguments[0], System.out);
                    ** break;
lbl391:
                    // 1 sources

                    break;
                }
                case 66: {
                    nodeCmd.printRangeKeySample(System.out);
                    ** break;
lbl395:
                    // 1 sources

                    break;
                }
                case 67: {
                    probe.reloadTriggers();
                    ** break;
lbl399:
                    // 1 sources

                    break;
                }
                case 68: {
                    classQualifer = "";
                    level = "";
                    if (arguments.length >= 1) {
                        classQualifer = arguments[0];
                    }
                    if (arguments.length == 2) {
                        level = arguments[1];
                    }
                    probe.setLoggingLevel(classQualifer, level);
                    ** break;
lbl409:
                    // 1 sources

                    break;
                }
                case 69: {
                    nodeCmd.getLoggingLevels(System.out);
                    ** break;
lbl413:
                    // 1 sources

                    break;
                }
                default: {
                    throw new RuntimeException("Unreachable code.");
                }
            }
        }
        finally {
            if (probe != null) {
                try {
                    probe.close();
                }
                catch (IOException ex) {}
            }
        }
        System.exit(probe.isFailed() != false ? 1 : 0);
    }

    private void getLoggingLevels(PrintStream out) {
        System.out.printf("%n%-50s%10s%n", "Logger Name", "Log Level");
        for (Map.Entry<String, String> entry : this.probe.getLoggingLevels().entrySet()) {
            System.out.printf("%-50s%10s%n", entry.getKey(), entry.getValue());
        }
    }

    private void printCompactionHistory(PrintStream out) {
        out.println("Compaction History: ");
        TabularData tabularData = this.probe.getCompactionHistory();
        if (tabularData.isEmpty()) {
            out.printf("There is no compaction history", new Object[0]);
            return;
        }
        String format = "%-41s%-19s%-29s%-26s%-15s%-15s%s%n";
        List<String> indexNames = tabularData.getTabularType().getIndexNames();
        out.printf(format, indexNames.toArray(new String[indexNames.size()]));
        Set<?> values = tabularData.keySet();
        for (Object eachValue : values) {
            List value = (List)eachValue;
            out.printf(format, value.toArray(new Object[value.size()]));
        }
    }

    private static void printHistory(String[] args, ToolCommandLine cmd) {
        if (args.length == 0) {
            return;
        }
        String cmdLine = Joiner.on((String)" ").skipNulls().join((Object[])args);
        String password = cmd.getOptionValue((String)NodeCmd.PASSWORD_OPT.left);
        if (password != null) {
            cmdLine = cmdLine.replace(password, "<hidden>");
        }
        try (FileWriter writer = new FileWriter(new File(FBUtilities.getToolsOutputDirectory(), HISTORYFILE), true);){
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
            writer.append(sdf.format(new Date()) + ": " + cmdLine + "\n");
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private static Throwable findInnermostThrowable(Throwable ex) {
        Throwable inner = ex.getCause();
        return inner == null ? ex : NodeCmd.findInnermostThrowable(inner);
    }

    private void printDescribeRing(String keyspaceName, PrintStream out) {
        out.println("Schema Version:" + this.probe.getSchemaVersion());
        out.println("TokenRange: ");
        try {
            for (String tokenRangeString : this.probe.describeRing(keyspaceName)) {
                out.println("\t" + tokenRangeString);
            }
        }
        catch (IOException e) {
            NodeCmd.err(e, e.getMessage());
        }
    }

    private void printRangeKeySample(PrintStream outs) {
        outs.println("RangeKeySample: ");
        List<String> tokenStrings = this.probe.sampleKeyRange();
        for (String tokenString : tokenStrings) {
            outs.println("\t" + tokenString);
        }
    }

    private void printGossipInfo(PrintStream out) {
        out.println(this.probe.getGossipInfo());
    }

    private static void badUse(String useStr) {
        System.err.println(useStr);
        NodeCmd.printUsage();
        System.exit(1);
    }

    private static void err(Exception e, String errStr) {
        System.err.println(errStr);
        e.printStackTrace();
        System.exit(3);
    }

    private static void complainNonzeroArgs(String[] args, NodeCommand cmd) {
        if (args.length > 0) {
            System.err.println("Too many arguments for command '" + cmd.toString() + "'.");
            NodeCmd.printUsage();
            System.exit(1);
        }
    }

    private static void handleSnapshots(NodeCommand nc, String tag, String[] cmdArgs, String columnFamily, NodeProbe probe) throws IOException {
        String[] keyspaces = Arrays.copyOfRange(cmdArgs, 0, cmdArgs.length);
        System.out.print("Requested " + (nc == NodeCommand.SNAPSHOT ? "creating" : "clearing") + " snapshot for: ");
        if (keyspaces.length > 0) {
            for (int i = 0; i < keyspaces.length; ++i) {
                System.out.print(keyspaces[i] + " ");
            }
        } else {
            System.out.print("all keyspaces ");
        }
        if (columnFamily != null) {
            System.out.print("and table: " + columnFamily);
        }
        System.out.println();
        switch (nc) {
            case SNAPSHOT: {
                if (tag == null || tag.equals("")) {
                    tag = new Long(System.currentTimeMillis()).toString();
                }
                probe.takeSnapshot(tag, columnFamily, keyspaces);
                System.out.println("Snapshot directory: " + tag);
                break;
            }
            case CLEARSNAPSHOT: {
                probe.clearSnapshot(tag, keyspaces);
            }
        }
    }

    private static void optionalKSandCFs(NodeCommand nc, ToolCommandLine cmd, String[] cmdArgs, NodeProbe probe) throws InterruptedException, IOException {
        List<String> keyspaces = cmdArgs.length == 0 ? probe.getKeyspaces() : Arrays.asList(cmdArgs[0]);
        for (String keyspace : keyspaces) {
            if (probe.getKeyspaces().contains(keyspace)) continue;
            System.err.println("Keyspace [" + keyspace + "] does not exist.");
            System.exit(1);
        }
        for (String keyspace : keyspaces) {
            String[] columnFamilies = cmdArgs.length <= 1 ? new String[]{} : Arrays.copyOfRange(cmdArgs, 1, cmdArgs.length);
            switch (nc) {
                case REPAIR: {
                    boolean sequential = !cmd.hasOption((String)NodeCmd.PARALLEL_REPAIR_OPT.left);
                    boolean localDC = cmd.hasOption((String)NodeCmd.LOCAL_DC_REPAIR_OPT.left);
                    boolean specificDC = cmd.hasOption((String)NodeCmd.DC_REPAIR_OPT.left);
                    boolean specificHosts = cmd.hasOption((String)NodeCmd.HOST_REPAIR_OPT.left);
                    boolean primaryRange = cmd.hasOption((String)NodeCmd.PRIMARY_RANGE_OPT.left);
                    List<String> dataCenters = null;
                    List<String> hosts = null;
                    if (specificDC) {
                        dataCenters = Arrays.asList(cmd.getOptionValue((String)NodeCmd.DC_REPAIR_OPT.left).split(","));
                    } else if (localDC) {
                        dataCenters = Arrays.asList(probe.getDataCenter());
                    } else if (specificHosts) {
                        hosts = Arrays.asList(cmd.getOptionValue((String)NodeCmd.HOST_REPAIR_OPT.left).split(","));
                    }
                    if (cmd.hasOption((String)NodeCmd.START_TOKEN_OPT.left) || cmd.hasOption((String)NodeCmd.END_TOKEN_OPT.left)) {
                        probe.forceRepairRangeAsync(System.out, keyspace, sequential, dataCenters, hosts, cmd.getOptionValue((String)NodeCmd.START_TOKEN_OPT.left), cmd.getOptionValue((String)NodeCmd.END_TOKEN_OPT.left), columnFamilies);
                        break;
                    }
                    probe.forceRepairAsync(System.out, keyspace, sequential, dataCenters, hosts, primaryRange, columnFamilies);
                    break;
                }
                case FLUSH: {
                    try {
                        probe.forceKeyspaceFlush(keyspace, columnFamilies);
                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occurred during flushing");
                    }
                    break;
                }
                case COMPACT: {
                    try {
                        probe.forceKeyspaceCompaction(keyspace, columnFamilies);
                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occurred during compaction");
                    }
                    break;
                }
                case CLEANUP: {
                    if (keyspace.equals("system")) break;
                    try {
                        probe.forceKeyspaceCleanup(keyspace, columnFamilies);
                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occurred during cleanup");
                    }
                    break;
                }
                case SCRUB: {
                    boolean disableSnapshot = cmd.hasOption((String)NodeCmd.NO_SNAPSHOT.left);
                    boolean skipCorrupted = cmd.hasOption((String)NodeCmd.SCRUB_SKIP_CORRUPTED_OPT.left);
                    try {
                        probe.scrub(disableSnapshot, skipCorrupted, keyspace, columnFamilies);
                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occurred while scrubbing keyspace " + keyspace);
                    }
                    break;
                }
                case UPGRADESSTABLES: {
                    boolean excludeCurrentVersion = !cmd.hasOption((String)NodeCmd.UPGRADE_ALL_SSTABLE_OPT.left);
                    try {
                        probe.upgradeSSTables(keyspace, excludeCurrentVersion, columnFamilies);
                    }
                    catch (ExecutionException ee) {
                        NodeCmd.err(ee, "Error occurred while upgrading the sstables for keyspace " + keyspace);
                    }
                    break;
                }
                case ENABLEAUTOCOMPACTION: {
                    probe.enableAutoCompaction(keyspace, columnFamilies);
                    break;
                }
                case DISABLEAUTOCOMPACTION: {
                    probe.disableAutoCompaction(keyspace, columnFamilies);
                    break;
                }
                default: {
                    throw new RuntimeException("Unreachable code.");
                }
            }
        }
    }

    static {
        options.addOption(SNAPSHOT_COLUMNFAMILY_OPT, true, "only take a snapshot of the specified table (column family)");
        options.addOption(HOST_OPT, true, "node hostname or ip address");
        options.addOption(PORT_OPT, true, "remote jmx agent port number");
        options.addOption(USERNAME_OPT, true, "remote jmx agent username");
        options.addOption(PASSWORD_OPT, true, "remote jmx agent password");
        options.addOption(TAG_OPT, true, "optional name to give a snapshot");
        options.addOption(TOKENS_OPT, false, "display all tokens");
        options.addOption(PRIMARY_RANGE_OPT, false, "only repair the first range returned by the partitioner for the node");
        options.addOption(PARALLEL_REPAIR_OPT, false, "repair nodes in parallel.");
        options.addOption(LOCAL_DC_REPAIR_OPT, false, "only repair against nodes in the same datacenter");
        options.addOption(DC_REPAIR_OPT, true, "only repair against nodes in the specified datacenters (comma separated)");
        options.addOption(HOST_REPAIR_OPT, true, "only repair against specified nodes (comma separated)");
        options.addOption(START_TOKEN_OPT, true, "token at which repair range starts");
        options.addOption(END_TOKEN_OPT, true, "token at which repair range ends");
        options.addOption(UPGRADE_ALL_SSTABLE_OPT, false, "includes sstables that are already on the most recent version during upgradesstables");
        options.addOption(NO_SNAPSHOT, false, "disables snapshot creation for scrub");
        options.addOption(CFSTATS_IGNORE_OPT, false, "ignore the supplied list of keyspace.columnfamiles in statistics");
        options.addOption(RESOLVE_IP, false, "show node domain names instead of IPs");
        options.addOption(SCRUB_SKIP_CORRUPTED_OPT, false, "when scrubbing counter tables, skip corrupted rows");
        options.addOption(COMPACT_OPT, false, "print histograms in a more compact format");
    }

    private static class ToolCommandLine {
        private final CommandLine commandLine;

        public ToolCommandLine(CommandLine commands) {
            this.commandLine = commands;
        }

        public Option[] getOptions() {
            return this.commandLine.getOptions();
        }

        public boolean hasOption(String opt) {
            return this.commandLine.hasOption(opt);
        }

        public String getOptionValue(String opt) {
            return this.commandLine.getOptionValue(opt);
        }

        public NodeCommand getCommand() {
            if (this.commandLine.getArgs().length == 0) {
                throw new IllegalArgumentException("Command was not specified.");
            }
            String command = this.commandLine.getArgs()[0];
            try {
                return NodeCommand.valueOf(command.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unrecognized command: " + command);
            }
        }

        public String[] getCommandArguments() {
            List params = this.commandLine.getArgList();
            if (params.size() < 2) {
                return new String[0];
            }
            String[] toReturn = new String[params.size() - 1];
            for (int i = 1; i < params.size(); ++i) {
                String parm = (String)params.get(i);
                if (parm.startsWith("\\")) {
                    parm = parm.substring(1);
                }
                toReturn[i - 1] = parm;
            }
            return toReturn;
        }
    }

    private static class ToolOptions
    extends Options {
        private ToolOptions() {
        }

        public void addOption(Pair<String, String> opts, boolean hasArgument, String description) {
            this.addOption(opts, hasArgument, description, false);
        }

        public void addOption(Pair<String, String> opts, boolean hasArgument, String description, boolean required) {
            this.addOption((String)opts.left, (String)opts.right, hasArgument, description, required);
        }

        public void addOption(String opt, String longOpt, boolean hasArgument, String description, boolean required) {
            Option option = new Option(opt, longOpt, hasArgument, description);
            option.setRequired(required);
            this.addOption(option);
        }
    }

    private static class OptionFilter {
        private Map<String, List<String>> filter = new HashMap<String, List<String>>();
        private Map<String, List<String>> verifier = new HashMap<String, List<String>>();
        private String[] filterList;
        private boolean ignoreMode;

        public OptionFilter(boolean ignoreMode, String ... filterList) {
            this.filterList = filterList;
            this.ignoreMode = ignoreMode;
            if (filterList == null) {
                return;
            }
            for (String s : filterList) {
                String[] keyValues = s.split("\\.", 2);
                if (!this.filter.containsKey(keyValues[0])) {
                    this.filter.put(keyValues[0], new ArrayList());
                    this.verifier.put(keyValues[0], new ArrayList());
                    if (keyValues.length != 2) continue;
                    this.filter.get(keyValues[0]).add(keyValues[1]);
                    this.verifier.get(keyValues[0]).add(keyValues[1]);
                    continue;
                }
                if (keyValues.length != 2) continue;
                this.filter.get(keyValues[0]).add(keyValues[1]);
                this.verifier.get(keyValues[0]).add(keyValues[1]);
            }
        }

        public boolean isColumnFamilyIncluded(String keyspace, String columnFamily) {
            if (this.filterList == null) {
                return !this.ignoreMode;
            }
            List<String> cfs = this.filter.get(keyspace);
            if (cfs == null) {
                return this.ignoreMode;
            }
            if (cfs.size() == 0) {
                return !this.ignoreMode;
            }
            this.verifier.get(keyspace).remove(columnFamily);
            return this.ignoreMode ^ cfs.contains(columnFamily);
        }

        public void verifyKeyspaces(List<String> keyspaces) {
            for (String ks : this.verifier.keySet()) {
                if (keyspaces.contains(ks)) continue;
                throw new RuntimeException("Unknown keyspace: " + ks);
            }
        }

        public void verifyColumnFamilies() {
            for (String ks : this.filter.keySet()) {
                if (this.verifier.get(ks).size() <= 0) continue;
                throw new RuntimeException("Unknown column families: " + this.verifier.get(ks).toString() + " in keyspace: " + ks);
            }
        }
    }

    static class HostStat {
        public final InetAddress endpoint;
        public final boolean resolveIp;
        public final Float owns;
        public final String token;

        public HostStat(String token, InetAddress endpoint, boolean resolveIp, Float owns) {
            this.token = token;
            this.endpoint = endpoint;
            this.resolveIp = resolveIp;
            this.owns = owns;
        }

        public String ipOrDns() {
            return this.resolveIp ? this.endpoint.getHostName() : this.endpoint.getHostAddress();
        }
    }

    static class SetHostStat
    implements Iterable<HostStat> {
        final List<HostStat> hostStats = new ArrayList<HostStat>();
        final boolean resolveIp;

        public SetHostStat(boolean resolveIp) {
            this.resolveIp = resolveIp;
        }

        public int size() {
            return this.hostStats.size();
        }

        @Override
        public Iterator<HostStat> iterator() {
            return this.hostStats.iterator();
        }

        public void add(String token, String host, Map<InetAddress, Float> ownerships) throws UnknownHostException {
            InetAddress endpoint = InetAddress.getByName(host);
            Float owns = ownerships.get(endpoint);
            this.hostStats.add(new HostStat(token, endpoint, this.resolveIp, owns));
        }
    }

    private class ClusterStatus {
        String kSpace = null;
        String format = null;
        int maxAddressLength;
        Collection<String> joiningNodes;
        Collection<String> leavingNodes;
        Collection<String> movingNodes;
        Collection<String> liveNodes;
        Collection<String> unreachableNodes;
        Map<String, String> loadMap;
        Map<String, String> hostIDMap;
        Map<String, String> tokensToEndpoints;
        EndpointSnitchInfoMBean epSnitchInfo;
        PrintStream outs;
        private final boolean resolveIp;

        ClusterStatus(PrintStream outs, String kSpace, boolean resolveIp) {
            this.kSpace = kSpace;
            this.outs = outs;
            this.resolveIp = resolveIp;
            this.joiningNodes = NodeCmd.this.probe.getJoiningNodes();
            this.leavingNodes = NodeCmd.this.probe.getLeavingNodes();
            this.movingNodes = NodeCmd.this.probe.getMovingNodes();
            this.loadMap = NodeCmd.this.probe.getLoadMap();
            this.tokensToEndpoints = NodeCmd.this.probe.getTokenToEndpointMap();
            this.liveNodes = NodeCmd.this.probe.getLiveNodes();
            this.unreachableNodes = NodeCmd.this.probe.getUnreachableNodes();
            this.hostIDMap = NodeCmd.this.probe.getHostIdMap();
            this.epSnitchInfo = NodeCmd.this.probe.getEndpointSnitchInfoProxy();
        }

        private void printStatusLegend() {
            this.outs.println("Status=Up/Down");
            this.outs.println("|/ State=Normal/Leaving/Joining/Moving");
        }

        private String getFormat(boolean hasEffectiveOwns, boolean isTokenPerNode) {
            if (this.format == null) {
                StringBuilder buf = new StringBuilder();
                String addressPlaceholder = String.format("%%-%ds  ", this.maxAddressLength);
                buf.append("%s%s  ");
                buf.append(addressPlaceholder);
                buf.append("%-9s  ");
                if (!isTokenPerNode) {
                    buf.append("%-6s  ");
                }
                if (hasEffectiveOwns) {
                    buf.append("%-16s  ");
                } else {
                    buf.append("%-5s  ");
                }
                buf.append("%-36s  ");
                if (isTokenPerNode) {
                    buf.append("%-39s  ");
                }
                buf.append("%s%n");
                this.format = buf.toString();
            }
            return this.format;
        }

        private void printNode(String endpoint, Float owns, List<HostStat> tokens, boolean hasEffectiveOwns, boolean isTokenPerNode) throws UnknownHostException {
            String fmt = this.getFormat(hasEffectiveOwns, isTokenPerNode);
            String status = this.liveNodes.contains(endpoint) ? "U" : (this.unreachableNodes.contains(endpoint) ? "D" : "?");
            String state = this.joiningNodes.contains(endpoint) ? "J" : (this.leavingNodes.contains(endpoint) ? "L" : (this.movingNodes.contains(endpoint) ? "M" : "N"));
            String load = this.loadMap.containsKey(endpoint) ? this.loadMap.get(endpoint) : "?";
            String strOwns = owns != null ? new DecimalFormat("##0.0%").format(owns) : "?";
            String hostID = this.hostIDMap.get(endpoint);
            String rack = this.epSnitchInfo.getRack(endpoint);
            String endpointDns = tokens.get(0).ipOrDns();
            if (isTokenPerNode) {
                this.outs.printf(fmt, status, state, endpointDns, load, strOwns, hostID, tokens.get((int)0).token, rack);
            } else {
                this.outs.printf(fmt, status, state, endpointDns, load, tokens.size(), strOwns, hostID, rack);
            }
        }

        private void printNodesHeader(boolean hasEffectiveOwns, boolean isTokenPerNode) {
            String owns;
            String fmt = this.getFormat(hasEffectiveOwns, isTokenPerNode);
            String string = owns = hasEffectiveOwns ? "Owns (effective)" : "Owns";
            if (isTokenPerNode) {
                this.outs.printf(fmt, "-", "-", "Address", "Load", owns, "Host ID", "Token", "Rack");
            } else {
                this.outs.printf(fmt, "-", "-", "Address", "Load", "Tokens", owns, "Host ID", "Rack");
            }
        }

        void findMaxAddressLength(Map<String, SetHostStat> dcs) {
            this.maxAddressLength = 0;
            for (Map.Entry<String, SetHostStat> dc : dcs.entrySet()) {
                for (HostStat stat : dc.getValue()) {
                    this.maxAddressLength = Math.max(this.maxAddressLength, stat.ipOrDns().length());
                }
            }
        }

        void print() throws UnknownHostException {
            Map<InetAddress, Float> ownerships;
            boolean hasEffectiveOwns = false;
            boolean isTokenPerNode = true;
            try {
                ownerships = NodeCmd.this.probe.effectiveOwnership(this.kSpace);
                hasEffectiveOwns = true;
            }
            catch (IllegalStateException e) {
                ownerships = NodeCmd.this.probe.getOwnership();
                this.outs.printf("Note: Ownership information does not include topology; for complete information, specify a keyspace%n", new Object[0]);
            }
            Map dcs = NodeCmd.this.getOwnershipByDc(this.resolveIp, this.tokensToEndpoints, ownerships);
            if (dcs.values().size() < this.tokensToEndpoints.keySet().size()) {
                isTokenPerNode = false;
            }
            this.findMaxAddressLength(dcs);
            for (Map.Entry dc : dcs.entrySet()) {
                String dcHeader = String.format("Datacenter: %s%n", dc.getKey());
                this.outs.printf(dcHeader, new Object[0]);
                for (int i = 0; i < dcHeader.length() - 1; ++i) {
                    this.outs.print('=');
                }
                this.outs.println();
                this.printStatusLegend();
                this.printNodesHeader(hasEffectiveOwns, isTokenPerNode);
                ArrayListMultimap hostToTokens = ArrayListMultimap.create();
                for (HostStat stat : (SetHostStat)dc.getValue()) {
                    hostToTokens.put((Object)stat.endpoint, (Object)stat);
                }
                for (InetAddress endpoint : hostToTokens.keySet()) {
                    Float owns = ownerships.get(endpoint);
                    List tokens = hostToTokens.get((Object)endpoint);
                    this.printNode(endpoint.getHostAddress(), owns, tokens, hasEffectiveOwns, isTokenPerNode);
                }
            }
        }
    }

    private static enum NodeCommand {
        CFHISTOGRAMS,
        CFSTATS,
        CLEANUP,
        CLEARSNAPSHOT,
        COMPACT,
        COMPACTIONSTATS,
        COMPACTIONHISTORY,
        DECOMMISSION,
        DESCRIBECLUSTER,
        DISABLEBINARY,
        DISABLEGOSSIP,
        DISABLEHANDOFF,
        DISABLETHRIFT,
        DRAIN,
        ENABLEBINARY,
        ENABLEGOSSIP,
        ENABLEHANDOFF,
        ENABLETHRIFT,
        FLUSH,
        GETCOMPACTIONTHRESHOLD,
        DISABLEAUTOCOMPACTION,
        ENABLEAUTOCOMPACTION,
        GETCOMPACTIONTHROUGHPUT,
        GETSTREAMTHROUGHPUT,
        GETENDPOINTS,
        GETSSTABLES,
        GOSSIPINFO,
        HELP,
        INFO,
        INVALIDATEKEYCACHE,
        INVALIDATEROWCACHE,
        JOIN,
        MOVE,
        NETSTATS,
        PAUSEHANDOFF,
        PROXYHISTOGRAMS,
        REBUILD,
        REFRESH,
        REMOVETOKEN,
        REMOVENODE,
        REPAIR,
        RESUMEHANDOFF,
        RING,
        SCRUB,
        SETCACHECAPACITY,
        SETCOMPACTIONTHRESHOLD,
        SETCOMPACTIONTHROUGHPUT,
        SETSTREAMTHROUGHPUT,
        SETTRACEPROBABILITY,
        SNAPSHOT,
        STATUS,
        STATUSBINARY,
        STATUSTHRIFT,
        STOP,
        STOPDAEMON,
        TAKETOKEN,
        TPSTATS,
        TRUNCATEHINTS,
        UPGRADESSTABLES,
        VERSION,
        DESCRIBERING,
        RANGEKEYSAMPLE,
        REBUILD_INDEX,
        RESETLOCALSCHEMA,
        ENABLEBACKUP,
        DISABLEBACKUP,
        SETCACHEKEYSTOSAVE,
        RELOADTRIGGERS,
        SETLOGGINGLEVEL,
        GETLOGGINGLEVELS;

    }
}

