/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import com.google.common.base.Stopwatch;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.TreeMapBackedSortedColumns;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.helpers.MessageFormatter;

public class TraceState {
    public final UUID sessionId;
    public final InetAddress coordinator;
    public final Stopwatch watch;
    public final ByteBuffer sessionIdBytes;

    public TraceState(InetAddress coordinator, UUID sessionId) {
        assert (coordinator != null);
        assert (sessionId != null);
        this.coordinator = coordinator;
        this.sessionId = sessionId;
        this.sessionIdBytes = ByteBufferUtil.bytes(sessionId);
        this.watch = new Stopwatch();
        this.watch.start();
    }

    public int elapsed() {
        long elapsed = this.watch.elapsedTime(TimeUnit.MICROSECONDS);
        return elapsed < Integer.MAX_VALUE ? (int)elapsed : Integer.MAX_VALUE;
    }

    public void trace(String format, Object arg) {
        this.trace(MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.trace(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    public void trace(String format, Object[] args) {
        this.trace(MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage());
    }

    public void trace(String message) {
        TraceState.trace(this.sessionIdBytes, message, this.elapsed());
    }

    public static void trace(final ByteBuffer sessionIdBytes, final String message, final int elapsed) {
        final ByteBuffer eventId = ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes());
        final String threadName = Thread.currentThread().getName();
        StageManager.getStage(Stage.TRACING).execute(new WrappedRunnable(){

            @Override
            public void runMayThrow() {
                CFMetaData cfMeta = CFMetaData.TraceEventsCf;
                TreeMapBackedSortedColumns cf = TreeMapBackedSortedColumns.factory.create(cfMeta);
                Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cfMeta, eventId, ByteBufferUtil.bytes("activity")), message);
                Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cfMeta, eventId, ByteBufferUtil.bytes("source")), FBUtilities.getBroadcastAddress());
                if (elapsed >= 0) {
                    Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cfMeta, eventId, ByteBufferUtil.bytes("source_elapsed")), elapsed);
                }
                Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cfMeta, eventId, ByteBufferUtil.bytes("thread")), threadName);
                Tracing.mutateWithCatch(new RowMutation("system_traces", sessionIdBytes, cf));
            }
        });
    }
}

