/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools;

import info.aduna.iteration.CloseableIteration;
import java.util.Collection;
import java.util.Iterator;

public class CompoundCloseableIteration<T, E extends Exception>
implements CloseableIteration<T, E> {
    private Iterator<CloseableIteration<T, E>> iterations;
    private CloseableIteration<T, E> currentIteration;

    public CompoundCloseableIteration(Collection<CloseableIteration<T, E>> childIterations) {
        this.iterations = childIterations.iterator();
        this.currentIteration = this.iterations.hasNext() ? this.iterations.next() : null;
    }

    public void close() throws E {
        if (null != this.currentIteration) {
            this.currentIteration.close();
            this.currentIteration = null;
        }
        while (this.iterations.hasNext()) {
            this.iterations.next().close();
        }
    }

    public boolean hasNext() throws E {
        if (null == this.currentIteration) {
            return false;
        }
        if (this.currentIteration.hasNext()) {
            return true;
        }
        this.currentIteration.close();
        if (this.iterations.hasNext()) {
            this.currentIteration = this.iterations.next();
            return this.hasNext();
        }
        this.currentIteration = null;
        return false;
    }

    public T next() throws E {
        return (T)this.currentIteration.next();
    }

    public void remove() throws E {
        this.currentIteration.remove();
    }
}

