/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.impl.TabletServerBatchWriter;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.util.ArgumentChecker;

public class BatchWriterImpl
implements BatchWriter {
    private String table;
    private TabletServerBatchWriter bw;

    public BatchWriterImpl(Instance instance, Credentials credentials, String table, BatchWriterConfig config) {
        ArgumentChecker.notNull(instance, credentials, table);
        if (config == null) {
            config = new BatchWriterConfig();
        }
        this.table = table;
        this.bw = new TabletServerBatchWriter(instance, credentials, config);
    }

    @Override
    public void addMutation(Mutation m) throws MutationsRejectedException {
        ArgumentChecker.notNull(m);
        this.bw.addMutation(this.table, m);
    }

    @Override
    public void addMutations(Iterable<Mutation> iterable) throws MutationsRejectedException {
        ArgumentChecker.notNull(iterable);
        this.bw.addMutation(this.table, iterable.iterator());
    }

    @Override
    public void close() throws MutationsRejectedException {
        this.bw.close();
    }

    @Override
    public void flush() throws MutationsRejectedException {
        this.bw.flush();
    }
}

