/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mrunit.TestDriver;
import org.apache.hadoop.mrunit.mapreduce.ReduceDriver;
import org.apache.hadoop.mrunit.types.KeyValueReuseList;
import org.apache.hadoop.mrunit.types.Pair;

class ReducePhaseRunner<INKEY, INVAL, OUTKEY, OUTVAL> {
    public static final Log LOG = LogFactory.getLog(ReducePhaseRunner.class);
    private final Configuration configuration;
    private final Counters counters;
    private Configuration outputSerializationConfiguration;
    private Class<? extends OutputFormat> outputFormatClass;
    private Class<? extends InputFormat> inputFormatClass;

    ReducePhaseRunner(Class<? extends InputFormat> inputFormatClass, Configuration configuration, Counters counters, Configuration outputSerializationConfiguration, Class<? extends OutputFormat> outputFormatClass) {
        this.inputFormatClass = inputFormatClass;
        this.configuration = configuration;
        this.counters = counters;
        this.outputSerializationConfiguration = outputSerializationConfiguration;
        this.outputFormatClass = outputFormatClass;
    }

    public List<Pair<OUTKEY, OUTVAL>> runReduce(List<KeyValueReuseList<INKEY, INVAL>> inputs, Reducer<INKEY, INVAL, OUTKEY, OUTVAL> reducer) throws IOException {
        ArrayList<Pair<OUTKEY, OUTVAL>> reduceOutputs = new ArrayList<Pair<OUTKEY, OUTVAL>>();
        if (!inputs.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                for (List list : inputs) {
                    TestDriver.formatValueList(list, sb);
                    LOG.debug((Object)("Reducing input " + sb));
                    sb.delete(0, sb.length());
                }
            }
            ReduceDriver reduceDriver = ((ReduceDriver)ReduceDriver.newReduceDriver(reducer).withCounters(this.counters).withConfiguration(this.configuration)).withAllElements(inputs);
            if (this.outputSerializationConfiguration != null) {
                reduceDriver.withOutputSerializationConfiguration(this.outputSerializationConfiguration);
            }
            if (this.outputFormatClass != null) {
                reduceDriver.withOutputFormat(this.outputFormatClass, this.inputFormatClass);
            }
            reduceOutputs.addAll(reduceDriver.run());
        }
        return reduceOutputs;
    }
}

