/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import java.util.Map;
import org.apache.hadoop.io.Text;
import org.cache2k.Cache;
import org.cache2k.CacheBuilder;
import org.cache2k.CacheSource;
import org.vertexium.id.IdentityNameSubstitutionStrategy;
import org.vertexium.id.NameSubstitutionStrategy;

public class AccumuloNameSubstitutionStrategy
implements NameSubstitutionStrategy {
    private final NameSubstitutionStrategy nameSubstitutionStrategy;
    private final Cache<Text, String> inflateTextCache;

    protected AccumuloNameSubstitutionStrategy(NameSubstitutionStrategy nameSubstitutionStrategy) {
        this.nameSubstitutionStrategy = nameSubstitutionStrategy;
        this.inflateTextCache = CacheBuilder.newCache(Text.class, String.class).name(AccumuloNameSubstitutionStrategy.class, "inflateTextCache-" + System.identityHashCode(this)).maxSize(10000).source((CacheSource)new CacheSource<Text, String>(){

            public String get(Text text) throws Throwable {
                return AccumuloNameSubstitutionStrategy.this.inflate(text.toString());
            }
        }).build();
    }

    public void setup(Map config) {
    }

    public String deflate(String value) {
        return this.nameSubstitutionStrategy.deflate(value);
    }

    public String inflate(String value) {
        return this.nameSubstitutionStrategy.inflate(value);
    }

    public String inflate(Text text) {
        if (text == null) {
            return null;
        }
        if (this.nameSubstitutionStrategy instanceof IdentityNameSubstitutionStrategy) {
            return text.toString();
        }
        return (String)this.inflateTextCache.get((Object)text);
    }

    public static AccumuloNameSubstitutionStrategy create(NameSubstitutionStrategy nameSubstitutionStrategy) {
        if (nameSubstitutionStrategy instanceof AccumuloNameSubstitutionStrategy) {
            return (AccumuloNameSubstitutionStrategy)nameSubstitutionStrategy;
        }
        return new AccumuloNameSubstitutionStrategy(nameSubstitutionStrategy);
    }
}

