/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.transform;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.transform.TransformPipe;
import com.tinkerpop.pipes.util.FastNoSuchElementException;
import com.tinkerpop.pipes.util.PipeHelper;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class ToStringPipe<S>
extends AbstractPipe<S, String>
implements TransformPipe<S, String> {
    private Iterator<Object> tempIterator = PipeHelper.emptyIterator();
    private static final String NULL = "null";

    @Override
    protected String processNextStart() throws NoSuchElementException {
        Object result;
        while (true) {
            if (this.tempIterator.hasNext()) {
                Object object = this.tempIterator.next();
                return null == object ? NULL : object.toString();
            }
            result = this.starts.next();
            if (result instanceof Iterator) {
                this.tempIterator = (Iterator)result;
                continue;
            }
            if (result instanceof Iterable) {
                this.tempIterator = ((Iterable)result).iterator();
                continue;
            }
            if (result instanceof Object[]) {
                this.tempIterator = new ArrayIterator((Object[])result);
                continue;
            }
            if (!(result instanceof Map)) break;
            this.tempIterator = ((Map)result).entrySet().iterator();
        }
        return null == result ? NULL : result.toString();
    }

    @Override
    public void reset() {
        this.tempIterator = PipeHelper.emptyIterator();
        super.reset();
    }

    class ArrayIterator
    implements Iterator {
        private final Object[] array;
        private int count = 0;

        public ArrayIterator(Object[] array) {
            this.array = array;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            if (this.count > this.array.length) {
                throw new FastNoSuchElementException();
            }
            return this.array[this.count++];
        }

        @Override
        public boolean hasNext() {
            return this.count < this.array.length;
        }
    }
}

