/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.schema.RelationTypeIndex;
import com.thinkaurelius.titan.core.schema.SchemaAction;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanIndex;
import com.thinkaurelius.titan.core.schema.TitanSchemaElement;
import com.thinkaurelius.titan.diskstorage.BackendTransaction;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.KCVSCache;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.database.management.ManagementSystem;
import com.thinkaurelius.titan.graphdb.database.management.RelationTypeIndexWrapper;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.thinkaurelius.titan.graphdb.relations.StandardEdge;
import com.thinkaurelius.titan.graphdb.relations.StandardProperty;
import com.thinkaurelius.titan.graphdb.relations.StandardRelation;
import com.thinkaurelius.titan.graphdb.schema.SchemaContainer;
import com.thinkaurelius.titan.graphdb.schema.SchemaProvider;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.CompositeIndexType;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.MixedIndexType;
import com.thinkaurelius.titan.graphdb.types.TypeInspector;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanSchemaVertex;
import com.thinkaurelius.titan.hadoop.FaunusEdge;
import com.thinkaurelius.titan.hadoop.FaunusElement;
import com.thinkaurelius.titan.hadoop.FaunusProperty;
import com.thinkaurelius.titan.hadoop.FaunusSchemaManager;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.StandardFaunusProperty;
import com.thinkaurelius.titan.hadoop.StandardFaunusRelation;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.tinkerpop.blueprints.Direction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitanIndexRepairMapper
extends Mapper<NullWritable, FaunusVertex, NullWritable, NullWritable> {
    private static final Logger log = LoggerFactory.getLogger(TitanIndexRepairMapper.class);
    private StandardTitanGraph graph;
    private ManagementSystem mgmt;
    private String indexName;
    private String indexType;
    private TitanIndex index;
    private RelationType indexRelationType;

    public void setup(Mapper.Context context) throws IOException {
        Configuration hadoopConf = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context);
        ModifiableHadoopConfiguration faunusConf = ModifiableHadoopConfiguration.of(hadoopConf);
        ModifiableConfiguration titanConf = faunusConf.getOutputConf();
        this.indexName = faunusConf.get(TitanHadoopConfiguration.INDEX_NAME, new String[0]);
        this.indexType = faunusConf.get(TitanHadoopConfiguration.INDEX_TYPE, new String[0]);
        try {
            Preconditions.checkNotNull((Object)this.indexName, (Object)"Need to provide at least an index name for re-index job");
            log.info("Read index information: name={} type={}", (Object)this.indexName, (Object)this.indexType);
            this.graph = (StandardTitanGraph)TitanFactory.open((BasicConfiguration)titanConf);
            SchemaContainer schema = new SchemaContainer((TitanGraph)this.graph);
            FaunusSchemaManager typeManager = FaunusSchemaManager.getTypeManager((com.thinkaurelius.titan.diskstorage.configuration.Configuration)titanConf);
            typeManager.setSchemaProvider((SchemaProvider)schema);
            log.info("Opened graph {}", (Object)this.graph);
            this.mgmt = (ManagementSystem)this.graph.getManagementSystem();
            this.validateIndexStatus();
        }
        catch (Exception e) {
            if (null != this.mgmt && this.mgmt.isOpen()) {
                this.mgmt.rollback();
            }
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.FAILED_TRANSACTIONS, 1L);
            throw new IOException(e.getMessage(), e);
        }
    }

    public void cleanup(Mapper.Context context) {
        try {
            if (null != this.mgmt && this.mgmt.isOpen()) {
                this.mgmt.commit();
            }
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.SUCCESSFUL_TRANSACTIONS, 1L);
        }
        catch (RuntimeException e) {
            log.error("Transaction commit threw runtime exception:", (Throwable)e);
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.FAILED_TRANSACTIONS, 1L);
            throw e;
        }
        try {
            if (null != this.graph && this.graph.isOpen()) {
                this.graph.shutdown();
            }
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.SUCCESSFUL_GRAPH_SHUTDOWNS, 1L);
        }
        catch (RuntimeException e) {
            log.error("Graph shutdown threw runtime exception:", (Throwable)e);
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.FAILED_GRAPH_SHUTDOWNS, 1L);
            throw e;
        }
    }

    private StandardRelation getTitanRelation(StandardFaunusRelation faunusRelation, StandardTitanTx tx) {
        StandardProperty titanRelation;
        if (faunusRelation.isEdge()) {
            StandardFaunusEdge faunusEdge = (StandardFaunusEdge)faunusRelation;
            InternalVertex start = tx.getInternalVertex(faunusEdge.getVertexId(Direction.OUT));
            InternalVertex end = tx.getInternalVertex(faunusEdge.getVertexId(Direction.IN));
            if (start == null || end == null) {
                return null;
            }
            titanRelation = new StandardEdge(faunusRelation.getLongId(), tx.getOrCreateEdgeLabel(this.indexType), start, end, 2);
        } else {
            assert (faunusRelation.isProperty());
            StandardFaunusProperty faunusProperty = (StandardFaunusProperty)faunusRelation;
            InternalVertex v = tx.getInternalVertex(faunusProperty.getVertex().getLongId());
            if (v == null) {
                return null;
            }
            titanRelation = new StandardProperty(faunusProperty.getLongId(), tx.getOrCreatePropertyKey(this.indexType), v, faunusProperty.getValue(), 2);
        }
        for (TitanRelation rel : faunusRelation.query().relations()) {
            Object value = rel.isProperty() ? ((FaunusProperty)rel).getValue() : tx.getInternalVertex(((FaunusEdge)rel).getVertexId(Direction.IN));
            if (value == null) continue;
            titanRelation.setProperty(rel.getType().getName(), value);
        }
        return titanRelation;
    }

    public void map(NullWritable key, FaunusVertex faunusVertex, Mapper.Context context) throws IOException {
        block20: {
            try {
                StandardTitanTx tx = this.mgmt.getWrappedTx();
                BackendTransaction mutator = tx.getTxHandle();
                if (this.index instanceof RelationTypeIndex) {
                    RelationTypeIndexWrapper wrapper = (RelationTypeIndexWrapper)this.index;
                    InternalRelationType wrappedType = wrapper.getWrappedType();
                    EdgeSerializer edgeSerializer = this.graph.getEdgeSerializer();
                    ArrayList<StaticArrayEntry> additions = new ArrayList<StaticArrayEntry>();
                    for (TitanRelation faunusRelation : faunusVertex.query().relations()) {
                        if (!faunusRelation.getType().getName().equals(this.indexType) || faunusRelation.getDirection((TitanVertex)faunusVertex) != Direction.OUT) continue;
                        StandardRelation titanRelation = this.getTitanRelation((StandardFaunusRelation)faunusRelation, tx);
                        for (int pos = 0; pos < titanRelation.getArity(); ++pos) {
                            if (!wrappedType.isUnidirected(Direction.BOTH) && !wrappedType.isUnidirected(EdgeDirection.fromPosition((int)pos))) continue;
                            StaticArrayEntry entry = edgeSerializer.writeRelation((InternalRelation)titanRelation, wrappedType, pos, (TypeInspector)tx);
                            additions.add(entry);
                        }
                    }
                    StaticBuffer vertexKey = this.graph.getIDManager().getKey(faunusVertex.getLongId());
                    mutator.mutateEdges(vertexKey, additions, KCVSCache.NO_DELETIONS);
                    break block20;
                }
                if (this.index instanceof TitanGraphIndex) {
                    ArrayList elements;
                    IndexType indexType = this.mgmt.getSchemaVertex((TitanSchemaElement)this.index).asIndexType();
                    assert (indexType != null);
                    IndexSerializer indexSerializer = this.graph.getIndexSerializer();
                    switch (indexType.getElement()) {
                        case VERTEX: {
                            elements = ImmutableList.of((Object)faunusVertex);
                            break;
                        }
                        case PROPERTY: {
                            elements = Lists.newArrayList();
                            for (TitanProperty p : faunusVertex.query().properties()) {
                                elements.add((StandardFaunusProperty)p);
                            }
                            break;
                        }
                        case EDGE: {
                            elements = Lists.newArrayList();
                            for (TitanEdge e : faunusVertex.query().titanEdges()) {
                                elements.add((StandardFaunusEdge)e);
                            }
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected category: " + indexType.getElement()));
                        }
                    }
                    if (indexType.isCompositeIndex()) {
                        for (FaunusElement element : elements) {
                            Set updates = indexSerializer.reindexElement((TitanElement)element, (CompositeIndexType)indexType);
                            for (IndexSerializer.IndexUpdate update : updates) {
                                log.debug("Mutating index {}: {}", (Object)indexType, update.getEntry());
                                mutator.mutateIndex((StaticBuffer)update.getKey(), (List)Lists.newArrayList((Object[])new Entry[]{(Entry)update.getEntry()}), KCVSCache.NO_DELETIONS);
                            }
                        }
                    } else {
                        assert (indexType.isMixedIndex());
                        HashMap documentsPerStore = Maps.newHashMap();
                        for (FaunusElement element : elements) {
                            indexSerializer.reindexElement((TitanElement)element, (MixedIndexType)indexType, (Map)documentsPerStore);
                        }
                        mutator.getIndexTransaction(indexType.getBackingIndexName()).restore((Map)documentsPerStore);
                    }
                    break block20;
                }
                throw new UnsupportedOperationException("Unsupported index found: " + this.index);
            }
            catch (Exception e) {
                this.mgmt.rollback();
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.FAILED_TRANSACTIONS, 1L);
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    private void validateIndexStatus() {
        String invalidIndexHint;
        if (this.indexType == null || StringUtils.isBlank((CharSequence)this.indexType)) {
            this.index = this.mgmt.getGraphIndex(this.indexName);
        } else {
            this.indexRelationType = this.mgmt.getRelationType(this.indexType);
            Preconditions.checkArgument((this.indexRelationType != null ? 1 : 0) != 0, (String)"Could not find relation type: %s", (Object[])new Object[]{this.indexType});
            this.index = this.mgmt.getRelationIndex(this.indexRelationType, this.indexName);
        }
        Preconditions.checkArgument((this.index != null ? 1 : 0) != 0, (String)"Could not find index: %s", (Object[])new Object[]{this.indexName});
        log.info("Found index {}", (Object)this.indexName);
        TitanSchemaVertex schemaVertex = this.mgmt.getSchemaVertex((TitanSchemaElement)this.index);
        Set acceptableStatuses = SchemaAction.REINDEX.getApplicableStatus();
        boolean isValidIndex = true;
        if (this.index instanceof RelationTypeIndex || this.index instanceof TitanGraphIndex && ((TitanGraphIndex)this.index).isCompositeIndex()) {
            SchemaStatus actualStatus = schemaVertex.getStatus();
            isValidIndex = acceptableStatuses.contains(actualStatus);
            invalidIndexHint = String.format("The index has status %s, but one of %s is required", actualStatus, acceptableStatuses);
        } else {
            Preconditions.checkArgument((boolean)(this.index instanceof TitanGraphIndex), (String)"Unexpected index: %s", (Object[])new Object[]{this.index});
            TitanGraphIndex gindex = (TitanGraphIndex)this.index;
            Preconditions.checkArgument((boolean)gindex.isMixedIndex());
            HashMap invalidKeyStatuses = Maps.newHashMap();
            for (PropertyKey key : gindex.getFieldKeys()) {
                SchemaStatus status = gindex.getIndexStatus(key);
                if (status == SchemaStatus.DISABLED || acceptableStatuses.contains(status)) continue;
                isValidIndex = false;
                invalidKeyStatuses.put(key.getName(), status);
                log.warn("Index {} has key {} in an invalid status {}", new Object[]{this.index, key, status});
            }
            invalidIndexHint = String.format("The following index keys have invalid status: %s (status must be one of %s)", Joiner.on((String)",").withKeyValueSeparator(" has status ").join((Map)invalidKeyStatuses), acceptableStatuses);
        }
        Preconditions.checkArgument((boolean)isValidIndex, (String)"The index %s is in an invalid state and cannot be indexed. %s", (Object[])new Object[]{this.indexName, invalidIndexHint});
        log.debug("Index {} is valid for re-indexing");
    }

    public static enum Counters {
        SUCCESSFUL_TRANSACTIONS,
        FAILED_TRANSACTIONS,
        SUCCESSFUL_GRAPH_SHUTDOWNS,
        FAILED_GRAPH_SHUTDOWNS;

    }
}

