/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce;

import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.formats.util.TitanSchemaAwareMapper;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class IdentityMap {
    public static Configuration createConfiguration() {
        return new EmptyConfiguration();
    }

    public static class Map
    extends TitanSchemaAwareMapper<NullWritable, FaunusVertex, NullWritable, FaunusVertex> {
        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTEX_COUNT, 1L);
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTEX_PROPERTY_COUNT, value.getPropertyCollection().size());
            long edgeCount = 0L;
            long edgePropertyCount = 0L;
            for (Edge edge : value.getEdges(Direction.IN, new String[0])) {
                ++edgeCount;
                edgePropertyCount += (long)((StandardFaunusEdge)edge).getPropertyCollection().size();
            }
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.IN_EDGE_COUNT, edgeCount);
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.IN_EDGE_PROPERTY_COUNT, edgePropertyCount);
            edgeCount = 0L;
            edgePropertyCount = 0L;
            for (Edge edge : value.getEdges(Direction.OUT, new String[0])) {
                ++edgeCount;
                edgePropertyCount += (long)((StandardFaunusEdge)edge).getPropertyCollection().size();
            }
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.OUT_EDGE_COUNT, edgeCount);
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.OUT_EDGE_PROPERTY_COUNT, edgePropertyCount);
            context.write((Object)NullWritable.get(), (Object)value);
        }
    }

    public static enum Counters {
        VERTEX_COUNT,
        OUT_EDGE_COUNT,
        IN_EDGE_COUNT,
        VERTEX_PROPERTY_COUNT,
        OUT_EDGE_PROPERTY_COUNT,
        IN_EDGE_PROPERTY_COUNT;

    }
}

