/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.tinkerpop.gremlin;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.codehaus.groovy.tools.shell.util.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsolePreferenceChangeListener
implements PreferenceChangeListener {
    static final String PREF_TINKERPOP_PREFIX = "tp-";
    private static final Logger log = LoggerFactory.getLogger(ConsolePreferenceChangeListener.class);
    private final ConcurrentHashMap<String, Function<PreferenceChangeEvent, ?>> prefChangeConsumers = new ConcurrentHashMap();

    public void setConsumer(String triggerPrefKey, Function<PreferenceChangeEvent, ?> consumer) {
        Preconditions.checkNotNull((Object)triggerPrefKey);
        Preconditions.checkArgument((!triggerPrefKey.startsWith("/") ? 1 : 0) != 0);
        String k = PREF_TINKERPOP_PREFIX + triggerPrefKey;
        Function<PreferenceChangeEvent, ?> oldConsumer = this.prefChangeConsumers.putIfAbsent(k, consumer);
        if (null == oldConsumer) {
            log.debug("Installing new preference consumer for key {}", (Object)k);
        } else {
            log.debug("Replacing existing preference consumer for key {} (old consumer: {})", (Object)k, oldConsumer);
        }
        String currentValue = Preferences.get((String)k);
        if (null != currentValue) {
            log.debug("Resetting stored value to trigger consumer: {}={}", (Object)k, (Object)currentValue);
            Preferences.put((String)k, (String)currentValue);
        } else {
            log.debug("Read null for {}", (Object)k);
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (null == evt || null == evt.getKey()) {
            return;
        }
        String k = evt.getKey();
        Function<PreferenceChangeEvent, ?> consumer = this.prefChangeConsumers.get(k);
        if (null == consumer) {
            log.debug("Ignoring preference key {} (no consumer registered)", (Object)k);
            return;
        }
        log.debug("Invoking consumer {} for key {}", consumer, (Object)k);
        consumer.apply((Object)evt);
    }
}

