/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.google.common.base.Preconditions;
import com.netflix.astyanax.serializers.ComparatorType;
import com.netflix.astyanax.serializers.ReversedSerializer;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ReversedType;

public class SpecificReversedSerializer
extends ReversedSerializer {
    private String reversedTypeName;
    private final ComparatorType reversedComparatorType;

    public SpecificReversedSerializer(ReversedType type) {
        Preconditions.checkNotNull((Object)type);
        AbstractType compType = type.baseType;
        this.reversedTypeName = compType.toString();
        if (this.reversedTypeName.startsWith("org.apache.cassandra.db.marshal.")) {
            this.reversedTypeName = this.reversedTypeName.substring("org.apache.cassandra.db.marshal.".length());
        }
        this.reversedComparatorType = ComparatorType.getByClassName(this.reversedTypeName);
    }

    @Override
    public ByteBuffer fromString(String string) {
        return this.reversedComparatorType.getSerializer().fromString(string);
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        return this.reversedComparatorType.getSerializer().getString(byteBuffer);
    }
}

