/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium;

import java.util.ArrayList;
import java.util.List;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.KeyNameVisibilityPropertyDeleteMutation;
import org.vertexium.mutation.KeyNameVisibilityPropertySoftDeleteMutation;
import org.vertexium.mutation.PropertyDeleteMutation;
import org.vertexium.mutation.PropertyPropertyDeleteMutation;
import org.vertexium.mutation.PropertyPropertySoftDeleteMutation;
import org.vertexium.mutation.PropertySoftDeleteMutation;
import org.vertexium.property.MutablePropertyImpl;
import org.vertexium.search.IndexHint;
import org.vertexium.util.Preconditions;

public abstract class ElementBuilder<T extends Element>
implements ElementMutation<T> {
    private final List<Property> properties = new ArrayList<Property>();
    private final List<PropertyDeleteMutation> propertyDeletes = new ArrayList<PropertyDeleteMutation>();
    private final List<PropertySoftDeleteMutation> propertySoftDeletes = new ArrayList<PropertySoftDeleteMutation>();
    private IndexHint indexHint = IndexHint.INDEX;

    @Override
    public ElementBuilder<T> setProperty(String name, Object value, Visibility visibility) {
        return this.setProperty(name, value, new Metadata(), visibility);
    }

    @Override
    public ElementBuilder<T> setProperty(String name, Object value, Metadata metadata, Visibility visibility) {
        return this.addPropertyValue("", name, value, metadata, visibility);
    }

    @Override
    public ElementBuilder<T> addPropertyValue(String key, String name, Object value, Visibility visibility) {
        return this.addPropertyValue(key, name, value, new Metadata(), visibility);
    }

    @Override
    public ElementBuilder<T> addPropertyValue(String key, String name, Object value, Metadata metadata, Visibility visibility) {
        return this.addPropertyValue(key, name, value, metadata, null, visibility);
    }

    @Override
    public ElementBuilder<T> addPropertyValue(String key, String name, Object value, Metadata metadata, Long timestamp, Visibility visibility) {
        if (name == null) {
            throw new NullPointerException("property name cannot be null for property: " + name + ":" + key);
        }
        if (value == null) {
            throw new NullPointerException("property value cannot be null for property: " + name + ":" + key);
        }
        this.properties.add(new MutablePropertyImpl(key, name, value, metadata, timestamp, null, visibility));
        return this;
    }

    @Override
    public ElementBuilder<T> deleteProperty(Property property) {
        this.propertyDeletes.add(new PropertyPropertyDeleteMutation(property));
        return this;
    }

    @Override
    public ElementBuilder<T> deleteProperty(String name, Visibility visibility) {
        return this.deleteProperty("", name, visibility);
    }

    @Override
    public ElementBuilder<T> deleteProperty(String key, String name, Visibility visibility) {
        Preconditions.checkNotNull(name, "property name cannot be null for property: " + name + ":" + key);
        this.propertyDeletes.add(new KeyNameVisibilityPropertyDeleteMutation(key, name, visibility));
        return this;
    }

    @Override
    public ElementBuilder<T> softDeleteProperty(Property property) {
        this.propertySoftDeletes.add(new PropertyPropertySoftDeleteMutation(property));
        return this;
    }

    @Override
    public ElementBuilder<T> softDeleteProperty(String name, Visibility visibility) {
        return this.softDeleteProperty("", name, visibility);
    }

    @Override
    public ElementBuilder<T> softDeleteProperty(String key, String name, Visibility visibility) {
        Preconditions.checkNotNull(name, "property name cannot be null for property: " + name + ":" + key);
        this.propertySoftDeletes.add(new KeyNameVisibilityPropertySoftDeleteMutation(key, name, visibility));
        return this;
    }

    @Override
    public abstract T save(Authorizations var1);

    @Override
    public Iterable<Property> getProperties() {
        return this.properties;
    }

    @Override
    public Iterable<PropertyDeleteMutation> getPropertyDeletes() {
        return this.propertyDeletes;
    }

    @Override
    public Iterable<PropertySoftDeleteMutation> getPropertySoftDeletes() {
        return this.propertySoftDeletes;
    }

    @Override
    public IndexHint getIndexHint() {
        return this.indexHint;
    }

    @Override
    public ElementMutation<T> setIndexHint(IndexHint indexHint) {
        this.indexHint = indexHint;
        return this;
    }
}

