/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;

public class Metadata
implements Serializable {
    static final long serialVersionUID = 42L;
    public static final String KEY_SEPARATOR = "\u001f";
    private final Map<String, Entry> entries;
    private final transient ReadWriteLock entiresLock = new ReentrantReadWriteLock();

    public Metadata() {
        this.entries = new HashMap<String, Entry>();
    }

    public Metadata(Metadata copyFromMetadata) {
        this();
        if (copyFromMetadata != null) {
            this.entries.putAll(copyFromMetadata.entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metadata add(String key, Object value, Visibility visibility) {
        this.entiresLock.writeLock().lock();
        try {
            this.entries.put(this.toMapKey(key, visibility), new Entry(key, value, visibility));
            Metadata metadata = this;
            return metadata;
        }
        finally {
            this.entiresLock.writeLock().unlock();
        }
    }

    public void remove(String key, Visibility visibility) {
        this.entiresLock.writeLock().lock();
        try {
            this.entries.remove(this.toMapKey(key, visibility));
        }
        finally {
            this.entiresLock.writeLock().unlock();
        }
    }

    public void clear() {
        this.entiresLock.writeLock().lock();
        try {
            this.entries.clear();
        }
        finally {
            this.entiresLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        this.entiresLock.writeLock().lock();
        try {
            for (Map.Entry<String, Entry> e : new ArrayList<Map.Entry<String, Entry>>(this.entries.entrySet())) {
                if (!e.getValue().getKey().equals(key)) continue;
                this.entries.remove(e.getKey());
            }
        }
        finally {
            this.entiresLock.writeLock().unlock();
        }
    }

    public Collection<Entry> entrySet() {
        this.entiresLock.readLock().lock();
        try {
            ArrayList<Entry> arrayList = new ArrayList<Entry>(this.entries.values());
            return arrayList;
        }
        finally {
            this.entiresLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getEntry(String key, Visibility visibility) {
        this.entiresLock.readLock().lock();
        try {
            Entry entry = this.entries.get(this.toMapKey(key, visibility));
            return entry;
        }
        finally {
            this.entiresLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getEntry(String key) {
        this.entiresLock.readLock().lock();
        try {
            Entry entry = null;
            for (Map.Entry<String, Entry> e : this.entries.entrySet()) {
                if (!e.getValue().getKey().equals(key)) continue;
                if (entry != null) {
                    throw new VertexiumException("Multiple matching entries for key: " + key);
                }
                entry = e.getValue();
            }
            Iterator<Map.Entry<String, Entry>> iterator = entry;
            return iterator;
        }
        finally {
            this.entiresLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Entry> getEntries(String key) {
        this.entiresLock.readLock().lock();
        try {
            ArrayList<Entry> results = new ArrayList<Entry>();
            for (Map.Entry<String, Entry> e : this.entries.entrySet()) {
                if (!e.getValue().getKey().equals(key)) continue;
                Entry entry = e.getValue();
                results.add(entry);
            }
            ArrayList<Entry> arrayList = results;
            return arrayList;
        }
        finally {
            this.entiresLock.readLock().unlock();
        }
    }

    public Object getValue(String key, Visibility visibility) {
        Entry entry = this.getEntry(key, visibility);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Object getValue(String key) {
        Entry entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Collection<Object> getValues(String key) {
        ArrayList<Object> results = new ArrayList<Object>();
        Collection<Entry> entries = this.getEntries(key);
        for (Entry entry : entries) {
            results.add(entry.getValue());
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        this.entiresLock.readLock().lock();
        try {
            for (Map.Entry<String, Entry> e : this.entries.entrySet()) {
                if (!e.getValue().getKey().equals(key)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.entiresLock.readLock().unlock();
        }
    }

    public boolean contains(String key, Visibility visibility) {
        return this.getEntry(key, visibility) != null;
    }

    private String toMapKey(String key, Visibility visibility) {
        return key + KEY_SEPARATOR + visibility.getVisibilityString();
    }

    public static class Entry
    implements Serializable {
        static final long serialVersionUID = 42L;
        private final String key;
        private final Object value;
        private final Visibility visibility;

        private Entry(String key, Object value, Visibility visibility) {
            this.key = key;
            this.value = value;
            this.visibility = visibility;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Visibility getVisibility() {
            return this.visibility;
        }

        public String toString() {
            return "Entry{key='" + this.key + '\'' + ", value=" + this.value + ", visibility=" + this.visibility + '}';
        }
    }
}

