/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.inmemory;

import java.util.EnumSet;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.EdgeVertices;
import org.vertexium.Element;
import org.vertexium.FetchHint;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.inmemory.InMemoryElement;
import org.vertexium.inmemory.InMemoryGraph;
import org.vertexium.inmemory.InMemoryTableEdge;
import org.vertexium.inmemory.mutations.AlterEdgeLabelMutation;
import org.vertexium.inmemory.mutations.EdgeSetupMutation;
import org.vertexium.mutation.ExistingEdgeMutation;
import org.vertexium.search.IndexHint;

public class InMemoryEdge
extends InMemoryElement<InMemoryEdge>
implements Edge {
    private final EdgeSetupMutation edgeSetupMutation;

    public InMemoryEdge(InMemoryGraph graph, String id, InMemoryTableEdge inMemoryTableElement, boolean includeHidden, Long endTime, Authorizations authorizations) {
        super(graph, id, inMemoryTableElement, includeHidden, endTime, authorizations);
        this.edgeSetupMutation = inMemoryTableElement.findLastMutation(EdgeSetupMutation.class);
    }

    public String getLabel() {
        return this.getInMemoryTableElement().findLastMutation(AlterEdgeLabelMutation.class).getNewEdgeLabel();
    }

    public String getVertexId(Direction direction) {
        switch (direction) {
            case IN: {
                return this.edgeSetupMutation.getInVertexId();
            }
            case OUT: {
                return this.edgeSetupMutation.getOutVertexId();
            }
        }
        throw new IllegalArgumentException("Unexpected direction: " + direction);
    }

    public Vertex getVertex(Direction direction, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getVertex(this.getVertexId(direction), fetchHints, authorizations);
    }

    public Vertex getVertex(Direction direction, Authorizations authorizations) {
        return this.getVertex(direction, FetchHint.ALL, authorizations);
    }

    public String getOtherVertexId(String myVertexId) {
        if (this.edgeSetupMutation.getInVertexId().equals(myVertexId)) {
            return this.edgeSetupMutation.getOutVertexId();
        }
        if (this.edgeSetupMutation.getOutVertexId().equals(myVertexId)) {
            return this.edgeSetupMutation.getInVertexId();
        }
        throw new VertexiumException("myVertexId does not appear on either the in or the out.");
    }

    public Vertex getOtherVertex(String myVertexId, Authorizations authorizations) {
        return this.getOtherVertex(myVertexId, FetchHint.ALL, authorizations);
    }

    public Vertex getOtherVertex(String myVertexId, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getVertex(this.getOtherVertexId(myVertexId), fetchHints, authorizations);
    }

    public EdgeVertices getVertices(Authorizations authorizations) {
        return new EdgeVertices(this.getVertex(Direction.OUT, authorizations), this.getVertex(Direction.IN, authorizations));
    }

    public ExistingEdgeMutation prepareMutation() {
        return new ExistingEdgeMutation(this){

            public Edge save(Authorizations authorizations) {
                IndexHint indexHint = this.getIndexHint();
                Visibility oldVisibility = InMemoryEdge.this.getVisibility();
                InMemoryEdge.this.saveExistingElementMutation(this, indexHint, authorizations);
                Edge edge = (Edge)this.getElement();
                if (indexHint != IndexHint.DO_NOT_INDEX) {
                    InMemoryEdge.this.saveMutationToSearchIndex((Element)edge, oldVisibility, this.getNewElementVisibility(), this.getAlterPropertyVisibilities(), authorizations);
                }
                return edge;
            }
        };
    }
}

