/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.threading;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class GlobalThreadFactory
implements ThreadFactory {
    AtomicInteger threadCount = new AtomicInteger();
    String prefix = "cache2k-";

    public GlobalThreadFactory(String _threadNamePrefix) {
        if (_threadNamePrefix != null) {
            this.prefix = _threadNamePrefix;
        }
    }

    @Override
    public Thread newThread(Runnable r) {
        int id = this.threadCount.getAndIncrement();
        Thread thr = new Thread(r);
        thr.setName(this.prefix + Integer.toString(id, 36));
        thr.setDaemon(true);
        return thr;
    }
}

