/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.datatypes;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.util.LiteralUtilException;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.DatatypeHandler;

public class RDFDatatypeHandler
implements DatatypeHandler {
    public boolean isRecognizedDatatype(URI datatypeUri) {
        if (datatypeUri == null) {
            throw new NullPointerException("Datatype URI cannot be null");
        }
        return RDF.LANGSTRING.equals((Object)datatypeUri) || RDF.XMLLITERAL.equals((Object)datatypeUri);
    }

    public boolean verifyDatatype(String literalValue, URI datatypeUri) throws LiteralUtilException {
        if (this.isRecognizedDatatype(datatypeUri)) {
            if (literalValue == null) {
                throw new NullPointerException("Literal value cannot be null");
            }
            return true;
        }
        throw new LiteralUtilException("Could not verify RDF builtin literal");
    }

    public Literal normalizeDatatype(String literalValue, URI datatypeUri, ValueFactory valueFactory) throws LiteralUtilException {
        if (this.isRecognizedDatatype(datatypeUri)) {
            if (literalValue == null) {
                throw new NullPointerException("Literal value cannot be null");
            }
            try {
                return valueFactory.createLiteral(literalValue, datatypeUri);
            }
            catch (IllegalArgumentException e) {
                throw new LiteralUtilException("Could not normalise RDF vocabulary defined literal", (Throwable)e);
            }
        }
        throw new LiteralUtilException("Could not normalise RDF vocabulary defined literal");
    }

    public String getKey() {
        return "org.openrdf.rio.datatypes.rdf";
    }
}

