/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;

public class CommonTermsQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<CommonTermsQueryBuilder> {
    private final String name;
    private final Object text;
    private Operator highFreqOperator = null;
    private Operator lowFreqOperator = null;
    private String analyzer = null;
    private Float boost = null;
    private String lowFreqMinimumShouldMatch = null;
    private String highFreqMinimumShouldMatch = null;
    private Boolean disableCoord = null;
    private Float cutoffFrequency = null;
    private String queryName;

    public CommonTermsQueryBuilder(String name, Object text) {
        if (name == null) {
            throw new ElasticsearchIllegalArgumentException("Field name must not be null");
        }
        if (text == null) {
            throw new ElasticsearchIllegalArgumentException("Query must not be null");
        }
        this.text = text;
        this.name = name;
    }

    public CommonTermsQueryBuilder highFreqOperator(Operator operator) {
        this.highFreqOperator = operator;
        return this;
    }

    public CommonTermsQueryBuilder lowFreqOperator(Operator operator) {
        this.lowFreqOperator = operator;
        return this;
    }

    public CommonTermsQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    @Override
    public CommonTermsQueryBuilder boost(float boost) {
        this.boost = Float.valueOf(boost);
        return this;
    }

    public CommonTermsQueryBuilder cutoffFrequency(float cutoffFrequency) {
        this.cutoffFrequency = Float.valueOf(cutoffFrequency);
        return this;
    }

    public CommonTermsQueryBuilder highFreqMinimumShouldMatch(String highFreqMinimumShouldMatch) {
        this.highFreqMinimumShouldMatch = highFreqMinimumShouldMatch;
        return this;
    }

    public CommonTermsQueryBuilder lowFreqMinimumShouldMatch(String lowFreqMinimumShouldMatch) {
        this.lowFreqMinimumShouldMatch = lowFreqMinimumShouldMatch;
        return this;
    }

    public CommonTermsQueryBuilder disableCoord(boolean disableCoord) {
        this.disableCoord = disableCoord;
        return this;
    }

    public CommonTermsQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("common");
        builder.startObject(this.name);
        builder.field("query", this.text);
        if (this.disableCoord != null) {
            builder.field("disable_coord", (Object)this.disableCoord);
        }
        if (this.highFreqOperator != null) {
            builder.field("high_freq_operator", this.highFreqOperator.toString());
        }
        if (this.lowFreqOperator != null) {
            builder.field("low_freq_operator", this.lowFreqOperator.toString());
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.boost != null) {
            builder.field("boost", this.boost);
        }
        if (this.cutoffFrequency != null) {
            builder.field("cutoff_frequency", this.cutoffFrequency);
        }
        if (this.lowFreqMinimumShouldMatch != null || this.highFreqMinimumShouldMatch != null) {
            builder.startObject("minimum_should_match");
            if (this.lowFreqMinimumShouldMatch != null) {
                builder.field("low_freq", this.lowFreqMinimumShouldMatch);
            }
            if (this.highFreqMinimumShouldMatch != null) {
                builder.field("high_freq", this.highFreqMinimumShouldMatch);
            }
            builder.endObject();
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
        builder.endObject();
    }

    public static enum Operator {
        OR,
        AND;

    }
}

