/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.matchedqueries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.SearchContext;

public class MatchedQueriesFetchSubPhase
implements FetchSubPhase {
    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of();
    }

    @Override
    public boolean hitsExecutionNeeded(SearchContext context) {
        return false;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) throws ElasticsearchException {
    }

    @Override
    public boolean hitExecutionNeeded(SearchContext context) {
        return !context.parsedQuery().namedFilters().isEmpty() || context.parsedPostFilter() != null && !context.parsedPostFilter().namedFilters().isEmpty();
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) throws ElasticsearchException {
        ArrayList<String> matchedQueries = Lists.newArrayListWithCapacity(2);
        try {
            DocIdSet docAndNestedDocsIdSet = null;
            if (context.mapperService().documentMapper(hitContext.hit().type()).hasNestedObjects()) {
                TermFilter docAndNestedDocsFilter = new TermFilter(new Term("_uid", Uid.createUidAsBytes(hitContext.hit().type(), hitContext.hit().id())));
                docAndNestedDocsIdSet = docAndNestedDocsFilter.getDocIdSet(hitContext.readerContext(), null);
            }
            this.addMatchedQueries(hitContext, context.parsedQuery().namedFilters(), matchedQueries, docAndNestedDocsIdSet);
            if (context.parsedPostFilter() != null) {
                this.addMatchedQueries(hitContext, context.parsedPostFilter().namedFilters(), matchedQueries, docAndNestedDocsIdSet);
            }
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
        finally {
            SearchContext.current().clearReleasables(SearchContext.Lifetime.COLLECTION);
        }
        hitContext.hit().matchedQueries(matchedQueries.toArray(new String[matchedQueries.size()]));
    }

    private void addMatchedQueries(FetchSubPhase.HitContext hitContext, ImmutableMap<String, Filter> namedFiltersAndQueries, List<String> matchedQueries, DocIdSet docAndNestedDocsIdSet) throws IOException {
        block0: for (Map.Entry entry : namedFiltersAndQueries.entrySet()) {
            String name = (String)entry.getKey();
            Filter filter = (Filter)entry.getValue();
            DocIdSet filterDocIdSet = filter.getDocIdSet(hitContext.readerContext(), null);
            if (DocIdSets.isEmpty(filterDocIdSet)) continue;
            if (!DocIdSets.isEmpty(docAndNestedDocsIdSet)) {
                DocIdSetIterator filterIterator = filterDocIdSet.iterator();
                DocIdSetIterator docAndNestedDocsIterator = docAndNestedDocsIdSet.iterator();
                if (filterIterator == null || docAndNestedDocsIterator == null) continue;
                int matchedDocId = -1;
                int docId = docAndNestedDocsIterator.nextDoc();
                while (docId < Integer.MAX_VALUE) {
                    if (docId > matchedDocId) {
                        matchedDocId = filterIterator.advance(docId);
                    }
                    if (matchedDocId == docId) {
                        matchedQueries.add(name);
                        continue block0;
                    }
                    docId = docAndNestedDocsIterator.nextDoc();
                }
                continue;
            }
            Bits bits = filterDocIdSet.bits();
            if (bits != null) {
                if (!bits.get(hitContext.docId())) continue;
                matchedQueries.add(name);
                continue;
            }
            DocIdSetIterator iterator = filterDocIdSet.iterator();
            if (iterator == null || iterator.advance(hitContext.docId()) != hitContext.docId()) continue;
            matchedQueries.add(name);
        }
    }
}

