/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.support.single.shard.SingleShardOperationRequest;
import org.elasticsearch.common.hppc.IntArrayList;
import org.elasticsearch.common.hppc.LongArrayList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.search.fetch.source.FetchSourceContext;

public class MultiGetShardRequest
extends SingleShardOperationRequest<MultiGetShardRequest> {
    private int shardId;
    private String preference;
    Boolean realtime;
    boolean refresh;
    boolean ignoreErrorsOnGeneratedFields = false;
    IntArrayList locations;
    List<MultiGetRequest.Item> items;

    MultiGetShardRequest() {
    }

    MultiGetShardRequest(MultiGetRequest multiGetRequest, String index, int shardId) {
        super(multiGetRequest, index);
        this.shardId = shardId;
        this.locations = new IntArrayList();
        this.items = new ArrayList<MultiGetRequest.Item>();
        this.preference = multiGetRequest.preference;
        this.realtime = multiGetRequest.realtime;
        this.refresh = multiGetRequest.refresh;
        this.ignoreErrorsOnGeneratedFields = multiGetRequest.ignoreErrorsOnGeneratedFields;
    }

    public int shardId() {
        return this.shardId;
    }

    public MultiGetShardRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public boolean realtime() {
        return this.realtime == null ? true : this.realtime;
    }

    public MultiGetShardRequest realtime(Boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public MultiGetShardRequest ignoreErrorsOnGeneratedFields(Boolean ignoreErrorsOnGeneratedFields) {
        this.ignoreErrorsOnGeneratedFields = ignoreErrorsOnGeneratedFields;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public MultiGetShardRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    void add(int location, MultiGetRequest.Item item) {
        this.locations.add(location);
        this.items.add(item);
    }

    @Override
    public String[] indices() {
        String[] indices = new String[this.items.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.items.get(i).index();
        }
        return indices;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.locations = new IntArrayList(size);
        this.items = new ArrayList<MultiGetRequest.Item>(size);
        if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            for (int i = 0; i < size; ++i) {
                this.locations.add(in.readVInt());
                this.items.add(MultiGetRequest.Item.readItem(in));
            }
        } else {
            int i;
            ArrayList<String> types = new ArrayList<String>(size);
            ArrayList<String> ids = new ArrayList<String>(size);
            ArrayList<String[]> fields = new ArrayList<String[]>(size);
            LongArrayList versions = new LongArrayList(size);
            ArrayList<VersionType> versionTypes = new ArrayList<VersionType>(size);
            ArrayList<FetchSourceContext> fetchSourceContexts = new ArrayList<FetchSourceContext>(size);
            for (i = 0; i < size; ++i) {
                this.locations.add(in.readVInt());
                if (in.readBoolean()) {
                    types.add(in.readSharedString());
                } else {
                    types.add(null);
                }
                ids.add(in.readString());
                int size1 = in.readVInt();
                if (size1 > 0) {
                    String[] fieldsArray = new String[size1];
                    for (int j = 0; j < size1; ++j) {
                        fieldsArray[j] = in.readString();
                    }
                    fields.add(fieldsArray);
                } else {
                    fields.add(null);
                }
                versions.add(Versions.readVersionWithVLongForBW(in));
                versionTypes.add(VersionType.fromValue(in.readByte()));
                fetchSourceContexts.add(FetchSourceContext.optionalReadFromStream(in));
            }
            for (i = 0; i < size; ++i) {
                MultiGetRequest.Item item = new MultiGetRequest.Item(this.index, (String)types.get(i), (String)ids.get(i)).fields((String[])fields.get(i)).version(versions.get(i)).versionType((VersionType)((Object)versionTypes.get(i))).fetchSourceContext((FetchSourceContext)fetchSourceContexts.get(i));
                this.items.add(item);
            }
        }
        this.preference = in.readOptionalString();
        this.refresh = in.readBoolean();
        byte realtime = in.readByte();
        if (realtime == 0) {
            this.realtime = false;
        } else if (realtime == 1) {
            this.realtime = true;
        }
        if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            this.ignoreErrorsOnGeneratedFields = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.locations.size());
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            for (int i = 0; i < this.locations.size(); ++i) {
                out.writeVInt(this.locations.get(i));
                this.items.get(i).writeTo(out);
            }
        } else {
            for (int i = 0; i < this.locations.size(); ++i) {
                out.writeVInt(this.locations.get(i));
                MultiGetRequest.Item item = this.items.get(i);
                if (item.type() == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    out.writeSharedString(item.type());
                }
                out.writeString(item.id());
                if (item.fields() == null) {
                    out.writeVInt(0);
                } else {
                    out.writeVInt(item.fields().length);
                    for (String field : item.fields()) {
                        out.writeString(field);
                    }
                }
                Versions.writeVersionWithVLongForBW(item.version(), out);
                out.writeByte(item.versionType().getValue());
                FetchSourceContext.optionalWriteToStream(item.fetchSourceContext(), out);
            }
        }
        out.writeOptionalString(this.preference);
        out.writeBoolean(this.refresh);
        if (this.realtime == null) {
            out.writeByte((byte)-1);
        } else if (!this.realtime.booleanValue()) {
            out.writeByte((byte)0);
        } else {
            out.writeByte((byte)1);
        }
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            out.writeBoolean(this.ignoreErrorsOnGeneratedFields);
        }
    }

    public boolean ignoreErrorsOnGeneratedFields() {
        return this.ignoreErrorsOnGeneratedFields;
    }
}

