/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.action.support.nodes.NodesOperationResponse;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingService;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.StartedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.GatewayAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hppc.ObjectLongOpenHashMap;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.local.PriorityComparator;
import org.elasticsearch.gateway.local.state.shards.TransportNodesListGatewayStartedShards;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;

public class LocalGatewayAllocator
extends AbstractComponent
implements GatewayAllocator {
    public static final String INDEX_RECOVERY_INITIAL_SHARDS = "index.recovery.initial_shards";
    private final String initialShards;
    private final TransportNodesListGatewayStartedShards startedAction;
    private final TransportNodesListShardStoreMetaData storeAction;
    private RoutingService routingService;
    private final ConcurrentMap<ShardId, AsyncShardFetch<TransportNodesListGatewayStartedShards.NodeLocalGatewayStartedShards>> asyncFetchStarted = ConcurrentCollections.newConcurrentMap();
    private final ConcurrentMap<ShardId, AsyncShardFetch<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData>> asyncFetchStore = ConcurrentCollections.newConcurrentMap();

    @Inject
    public LocalGatewayAllocator(Settings settings, TransportNodesListGatewayStartedShards startedAction, TransportNodesListShardStoreMetaData storeAction) {
        super(settings);
        this.startedAction = startedAction;
        this.storeAction = storeAction;
        this.initialShards = settings.get("gateway.initial_shards", settings.get("gateway.local.initial_shards", "quorum"));
        this.logger.debug("using initial_shards [{}]", this.initialShards);
    }

    public void setReallocation(ClusterService clusterService, RoutingService routingService) {
        this.routingService = routingService;
        clusterService.add(new ClusterStateListener(){

            @Override
            public void clusterChanged(ClusterChangedEvent event) {
                boolean cleanCache = false;
                DiscoveryNode localNode = event.state().nodes().localNode();
                if (localNode != null) {
                    if (localNode.masterNode() && !event.localNodeMaster()) {
                        cleanCache = true;
                    }
                } else {
                    cleanCache = true;
                }
                if (cleanCache) {
                    Releasables.close(LocalGatewayAllocator.this.asyncFetchStarted.values());
                    LocalGatewayAllocator.this.asyncFetchStarted.clear();
                    Releasables.close(LocalGatewayAllocator.this.asyncFetchStore.values());
                    LocalGatewayAllocator.this.asyncFetchStore.clear();
                }
            }
        });
    }

    public int getNumberOfInFlightFetch() {
        int count = 0;
        for (AsyncShardFetch fetch : this.asyncFetchStarted.values()) {
            count += fetch.getNumberOfInFlightFetches();
        }
        for (AsyncShardFetch fetch : this.asyncFetchStore.values()) {
            count += fetch.getNumberOfInFlightFetches();
        }
        return count;
    }

    @Override
    public void applyStartedShards(StartedRerouteAllocation allocation) {
        for (ShardRouting shardRouting : allocation.startedShards()) {
            Releasables.close((Releasable)this.asyncFetchStarted.remove(shardRouting.shardId()));
            Releasables.close((Releasable)this.asyncFetchStore.remove(shardRouting.shardId()));
        }
    }

    @Override
    public void applyFailedShards(FailedRerouteAllocation allocation) {
        for (FailedRerouteAllocation.FailedShard shard : allocation.failedShards()) {
            Releasables.close((Releasable)this.asyncFetchStarted.remove(shard.shard.shardId()));
            Releasables.close((Releasable)this.asyncFetchStore.remove(shard.shard.shardId()));
        }
    }

    private boolean recoverOnAnyNode(@IndexSettings Settings idxSettings) {
        return IndexMetaData.isOnSharedFilesystem(idxSettings) && idxSettings.getAsBoolean("index.shared_filesystem.recover_on_any_node", (Boolean)false) != false;
    }

    @Override
    public boolean allocateUnassigned(RoutingAllocation allocation) {
        MutableShardRouting shard;
        long lastAllocateUnassignedRun = System.currentTimeMillis();
        this.routingService.setUnassignedShardsAllocatedTimestamp(lastAllocateUnassignedRun);
        boolean changed = false;
        DiscoveryNodes nodes = allocation.nodes();
        RoutingNodes routingNodes = allocation.routingNodes();
        final MetaData metaData = routingNodes.metaData();
        RoutingNodes.UnassignedShards unassigned = routingNodes.unassigned();
        unassigned.sort(new PriorityComparator(){

            @Override
            protected Settings getIndexSettings(String index) {
                IndexMetaData indexMetaData = metaData.index(index);
                return indexMetaData.getSettings();
            }
        });
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = routingNodes.unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            AsyncShardFetch.FetchResult shardState;
            shard = unassignedIterator.next();
            if (!shard.primary() || !routingNodes.routingTable().index(shard.index()).shard(shard.id()).primaryAllocatedPostApi()) continue;
            InternalAsyncFetch<TransportNodesListGatewayStartedShards.NodeLocalGatewayStartedShards> fetch = (InternalAsyncFetch<TransportNodesListGatewayStartedShards.NodeLocalGatewayStartedShards>)this.asyncFetchStarted.get(shard.shardId());
            if (fetch == null) {
                fetch = new InternalAsyncFetch<TransportNodesListGatewayStartedShards.NodeLocalGatewayStartedShards>(this.logger, "shard_started", shard.shardId(), this.startedAction);
                this.asyncFetchStarted.put(shard.shardId(), fetch);
            }
            if (!(shardState = fetch.fetchData(nodes, metaData, allocation.getIgnoreNodes(shard.shardId()))).hasData()) {
                this.logger.trace("{}: ignoring allocation, still fetching shard started state", shard);
                allocation.setHasPendingAsyncFetch();
                unassignedIterator.removeAndIgnore();
                continue;
            }
            shardState.processAllocation(allocation);
            IndexMetaData indexMetaData = metaData.index(shard.getIndex());
            ObjectLongOpenHashMap<DiscoveryNode> nodesState = new ObjectLongOpenHashMap<DiscoveryNode>();
            for (TransportNodesListGatewayStartedShards.NodeLocalGatewayStartedShards nodeShardState : shardState.getData().values()) {
                long version = nodeShardState.version();
                this.logger.trace("[{}] on node [{}] has version [{}] of shard", shard, nodeShardState.getNode(), version);
                nodesState.put(nodeShardState.getNode(), version);
            }
            int numberOfAllocationsFound = 0;
            long highestVersion = -1L;
            final HashMap<DiscoveryNode, Long> nodesWithVersion = Maps.newHashMap();
            boolean[] states = nodesState.allocated;
            KType[] keys = nodesState.keys;
            long[] values = nodesState.values;
            Settings idxSettings = indexMetaData.settings();
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                DiscoveryNode node = (DiscoveryNode)keys[i];
                long version = values[i];
                if (allocation.shouldIgnoreShardForNode(shard.shardId(), node.id())) continue;
                if (this.recoverOnAnyNode(idxSettings)) {
                    ++numberOfAllocationsFound;
                    if (version > highestVersion) {
                        highestVersion = version;
                    }
                    nodesWithVersion.put(node, version);
                    continue;
                }
                if (version == -1L) continue;
                ++numberOfAllocationsFound;
                if (version > highestVersion) {
                    highestVersion = version;
                    nodesWithVersion.clear();
                    nodesWithVersion.put(node, version);
                    continue;
                }
                if (version != highestVersion) continue;
                nodesWithVersion.put(node, version);
            }
            ArrayList<DiscoveryNode> nodesWithHighestVersion = Lists.newArrayList();
            nodesWithHighestVersion.addAll(nodesWithVersion.keySet());
            CollectionUtil.timSort(nodesWithHighestVersion, (Comparator)new Comparator<DiscoveryNode>(){

                @Override
                public int compare(DiscoveryNode o1, DiscoveryNode o2) {
                    return Long.compare((Long)nodesWithVersion.get(o2), (Long)nodesWithVersion.get(o1));
                }
            });
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}][{}] found {} allocations of {}, highest version: [{}]", shard.index(), shard.id(), numberOfAllocationsFound, shard, highestVersion);
            }
            if (this.logger.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder("[");
                for (DiscoveryNode n : nodesWithHighestVersion) {
                    sb.append("[");
                    sb.append(n.getName());
                    sb.append("]");
                    sb.append(" -> ");
                    sb.append(nodesWithVersion.get(n));
                    sb.append(", ");
                }
                sb.append("]");
                this.logger.trace("{} candidates for allocation: {}", shard, sb.toString());
            }
            int requiredAllocation = 1;
            if (shard.restoreSource() == null) {
                try {
                    String initialShards = indexMetaData.settings().get(INDEX_RECOVERY_INITIAL_SHARDS, this.settings.get(INDEX_RECOVERY_INITIAL_SHARDS, this.initialShards));
                    if ("quorum".equals(initialShards)) {
                        if (indexMetaData.numberOfReplicas() > 1) {
                            requiredAllocation = (1 + indexMetaData.numberOfReplicas()) / 2 + 1;
                        }
                    } else if ("quorum-1".equals(initialShards) || "half".equals(initialShards)) {
                        if (indexMetaData.numberOfReplicas() > 2) {
                            requiredAllocation = (1 + indexMetaData.numberOfReplicas()) / 2;
                        }
                    } else if ("one".equals(initialShards)) {
                        requiredAllocation = 1;
                    } else if ("full".equals(initialShards) || "all".equals(initialShards)) {
                        requiredAllocation = indexMetaData.numberOfReplicas() + 1;
                    } else if ("full-1".equals(initialShards) || "all-1".equals(initialShards)) {
                        if (indexMetaData.numberOfReplicas() > 1) {
                            requiredAllocation = indexMetaData.numberOfReplicas();
                        }
                    } else {
                        requiredAllocation = Integer.parseInt(initialShards);
                    }
                }
                catch (Exception e) {
                    this.logger.warn("[{}][{}] failed to derived initial_shards from value {}, ignore allocation for {}", shard.index(), shard.id(), this.initialShards, shard);
                }
            }
            if (numberOfAllocationsFound < requiredAllocation) {
                if (shard.restoreSource() == null) {
                    unassignedIterator.removeAndIgnore();
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("[{}][{}]: not allocating, number_of_allocated_shards_found [{}], required_number [{}]", shard.index(), shard.id(), numberOfAllocationsFound, requiredAllocation);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("[{}][{}]: missing local data, will restore from [{}]", shard.index(), shard.id(), shard.restoreSource());
                continue;
            }
            HashSet<DiscoveryNode> throttledNodes = Sets.newHashSet();
            HashSet<DiscoveryNode> noNodes = Sets.newHashSet();
            for (DiscoveryNode discoNode : nodesWithHighestVersion) {
                RoutingNode node = routingNodes.node(discoNode.id());
                if (node == null) continue;
                Decision decision = allocation.deciders().canAllocate(shard, node, allocation);
                if (decision.type() == Decision.Type.THROTTLE) {
                    throttledNodes.add(discoNode);
                    continue;
                }
                if (decision.type() == Decision.Type.NO) {
                    noNodes.add(discoNode);
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}][{}]: allocating [{}] to [{}] on primary allocation", shard.index(), shard.id(), shard, discoNode);
                }
                changed = true;
                unassignedIterator.initialize(node.nodeId(), highestVersion);
                throttledNodes.clear();
                noNodes.clear();
                break;
            }
            if (throttledNodes.isEmpty()) {
                if (noNodes.isEmpty()) continue;
                DiscoveryNode discoNode = (DiscoveryNode)noNodes.iterator().next();
                RoutingNode node = routingNodes.node(discoNode.id());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}][{}]: forcing allocating [{}] to [{}] on primary allocation", shard.index(), shard.id(), shard, discoNode);
                }
                changed = true;
                unassignedIterator.initialize(node.nodeId(), highestVersion);
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}][{}]: throttling allocation [{}] to [{}] on primary allocation", shard.index(), shard.id(), shard, throttledNodes);
            }
            unassignedIterator.removeAndIgnore();
        }
        if (routingNodes.unassigned().isEmpty()) {
            return changed;
        }
        unassignedIterator = unassigned.iterator();
        while (unassignedIterator.hasNext()) {
            long delay;
            AsyncShardFetch.FetchResult fetchResult;
            shard = unassignedIterator.next();
            if (shard.primary()) continue;
            boolean canBeAllocatedToAtLeastOneNode = false;
            for (ObjectCursor<DiscoveryNode> objectCursor : nodes.dataNodes().values()) {
                Decision decision;
                RoutingNode node = routingNodes.node(((DiscoveryNode)objectCursor.value).id());
                if (node == null || (decision = allocation.deciders().canAllocate(shard, node, allocation)).type() != Decision.Type.YES) continue;
                canBeAllocatedToAtLeastOneNode = true;
                break;
            }
            if (!canBeAllocatedToAtLeastOneNode) {
                this.logger.trace("{}: ignoring allocation, can't be allocated on any node", shard);
                unassignedIterator.removeAndIgnore();
                continue;
            }
            InternalAsyncFetch<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> fetch = (InternalAsyncFetch<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData>)this.asyncFetchStore.get(shard.shardId());
            if (fetch == null) {
                fetch = new InternalAsyncFetch<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData>(this.logger, "shard_store", shard.shardId(), this.storeAction);
                this.asyncFetchStore.put(shard.shardId(), fetch);
            }
            if (!(fetchResult = fetch.fetchData(nodes, metaData, allocation.getIgnoreNodes(shard.shardId()))).hasData()) {
                this.logger.trace("{}: ignoring allocation, still fetching shard stores", shard);
                allocation.setHasPendingAsyncFetch();
                unassignedIterator.removeAndIgnore();
                continue;
            }
            fetchResult.processAllocation(allocation);
            long lastSizeMatched = 0L;
            DiscoveryNode lastDiscoNodeMatched = null;
            RoutingNode lastNodeMatched = null;
            boolean hasReplicaData = false;
            IndexMetaData indexMetaData = metaData.index(shard.getIndex());
            for (Map.Entry nodeStoreEntry : fetchResult.getData().entrySet()) {
                TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryNodeStore;
                TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData primaryNodeFilesStore;
                Decision decision;
                RoutingNode node;
                DiscoveryNode discoNode = nodeStoreEntry.getKey();
                TransportNodesListShardStoreMetaData.StoreFilesMetaData storeFilesMetaData = ((TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData)nodeStoreEntry.getValue()).storeFilesMetaData();
                this.logger.trace("{}: checking node [{}]", shard, discoNode);
                if (storeFilesMetaData == null || (node = routingNodes.node(discoNode.id())) == null || (decision = allocation.deciders().canAllocate(shard, node, allocation)).type() == Decision.Type.NO || storeFilesMetaData.allocated() || shard.primary()) continue;
                hasReplicaData |= storeFilesMetaData.iterator().hasNext();
                MutableShardRouting primaryShard = routingNodes.activePrimary(shard);
                if (primaryShard == null) continue;
                assert (primaryShard.active());
                DiscoveryNode primaryNode = nodes.get(primaryShard.currentNodeId());
                if (primaryNode == null || (primaryNodeFilesStore = (TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData)fetchResult.getData().get(primaryNode)) == null || (primaryNodeStore = primaryNodeFilesStore.storeFilesMetaData()) == null || !primaryNodeStore.allocated()) continue;
                long sizeMatched = 0L;
                String primarySyncId = primaryNodeStore.syncId();
                String replicaSyncId = storeFilesMetaData.syncId();
                if (replicaSyncId != null && replicaSyncId.equals(primarySyncId)) {
                    this.logger.trace("{}: node [{}] has same sync id {} as primary", shard, discoNode.name(), replicaSyncId);
                    lastNodeMatched = node;
                    lastSizeMatched = Long.MAX_VALUE;
                    lastDiscoNodeMatched = discoNode;
                    continue;
                }
                for (StoreFileMetaData storeFileMetaData : storeFilesMetaData) {
                    String metaDataFileName = storeFileMetaData.name();
                    if (!primaryNodeStore.fileExists(metaDataFileName) || !primaryNodeStore.file(metaDataFileName).isSame(storeFileMetaData)) continue;
                    sizeMatched += storeFileMetaData.length();
                }
                this.logger.trace("{}: node [{}] has [{}/{}] bytes of re-usable data", shard, discoNode.name(), new ByteSizeValue(sizeMatched), sizeMatched);
                if (sizeMatched <= lastSizeMatched) continue;
                lastSizeMatched = sizeMatched;
                lastDiscoNodeMatched = discoNode;
                lastNodeMatched = node;
            }
            if (lastNodeMatched != null) {
                Decision decision = allocation.deciders().canAllocate(shard, lastNodeMatched, allocation);
                if (decision.type() == Decision.Type.THROTTLE) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("[{}][{}]: throttling allocation [{}] to [{}] in order to reuse its unallocated persistent store with total_size [{}]", shard.index(), shard.id(), shard, lastDiscoNodeMatched, new ByteSizeValue(lastSizeMatched));
                    }
                    unassignedIterator.removeAndIgnore();
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}][{}]: allocating [{}] to [{}] in order to reuse its unallocated persistent store with total_size [{}]", shard.index(), shard.id(), shard, lastDiscoNodeMatched, new ByteSizeValue(lastSizeMatched));
                }
                changed = true;
                unassignedIterator.initialize(lastNodeMatched.nodeId(), shard.version());
                continue;
            }
            if (hasReplicaData || (delay = shard.unassignedInfo().getDelayAllocationExpirationIn(lastAllocateUnassignedRun, this.settings, indexMetaData.getSettings())) <= 0L) continue;
            this.logger.debug("[{}][{}]: delaying allocation of [{}] for [{}]", shard.index(), shard.id(), shard, TimeValue.timeValueMillis(delay));
            changed = true;
            unassignedIterator.removeAndIgnore();
        }
        return changed;
    }

    class InternalAsyncFetch<T extends NodeOperationResponse>
    extends AsyncShardFetch<T> {
        public InternalAsyncFetch(ESLogger logger, String type, ShardId shardId, AsyncShardFetch.List<? extends NodesOperationResponse<T>, T> action) {
            super(logger, type, shardId, action);
        }

        @Override
        protected void reroute(ShardId shardId, String reason) {
            this.logger.trace("{} scheduling reroute for {}", shardId, reason);
            LocalGatewayAllocator.this.routingService.reroute("async_shard_fetch");
        }
    }
}

