/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.migrations;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.vertexium.VertexiumSerializer;
import org.vertexium.accumulo.AccumuloGraphConfiguration;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public abstract class MRMigrationBase
extends Configured
implements Tool {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(MRMigrationBase.class);

    protected static void run(MRMigrationBase mr, String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)mr, (String[])args);
        System.exit(res);
    }

    public static VertexiumSerializer getVertexiumSerializer(Configuration conf) {
        return MRMigrationBase.getAccumuloGraphConfiguration(conf).createSerializer();
    }

    public static String getOutputTableName(Configuration conf) {
        return conf.get("MRMigrationBase.output.tableName");
    }

    public static AccumuloGraphConfiguration getAccumuloGraphConfiguration(Configuration conf) {
        return new AccumuloGraphConfiguration(conf, conf.get("MRMigrationBase.config.prefix"));
    }

    public int run(String[] args) throws Exception {
        Opts opts = this.createOpts();
        opts.parseArgs(((Object)((Object)this)).getClass().getName(), args, new Object[0]);
        Job job = Job.getInstance((Configuration)this.getConf(), (String)((Object)((Object)this)).getClass().getSimpleName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        opts.setAccumuloConfigs(job);
        job.setInputFormatClass(this.getInputFormatClass());
        job.setMapperClass(this.getMigrationMapperClass());
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Mutation.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    protected Class getInputFormatClass() {
        return AccumuloInputFormat.class;
    }

    protected Opts createOpts() {
        return new OptsWithTableName();
    }

    protected abstract Class<? extends Mapper> getMigrationMapperClass();

    protected static abstract class MRMigrationMapperBase<TKey, TValue>
    extends Mapper<TKey, TValue, Text, Mutation> {
        private VertexiumSerializer vertexiumSerializer;
        private Text outputTableNameText;

        protected MRMigrationMapperBase() {
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            this.vertexiumSerializer = MRMigrationBase.getVertexiumSerializer(context.getConfiguration());
            this.outputTableNameText = new Text(MRMigrationBase.getOutputTableName(context.getConfiguration()));
        }

        protected void map(TKey key, TValue value, Mapper.Context context) throws IOException, InterruptedException {
            try {
                this.safeMap(key, value, context);
            }
            catch (Throwable ex) {
                LOGGER.error("Failed to process row: %s", new Object[]{key, ex});
            }
        }

        protected abstract void safeMap(TKey var1, TValue var2, Mapper.Context var3) throws Exception;

        public VertexiumSerializer getVertexiumSerializer() {
            return this.vertexiumSerializer;
        }

        protected Text getOutputTableNameText() {
            return this.outputTableNameText;
        }
    }

    protected static class OptsWithTableName
    extends Opts {
        @Parameter(names={"-t", "--table"}, description="Name of table to migrate")
        public String tableName = System.getProperty("table.name");

        protected OptsWithTableName() {
        }

        @Override
        protected String getTableName() {
            return this.tableName;
        }
    }

    protected static abstract class Opts
    extends ClientOpts {
        @Parameter(names={"-cp", "--configprefix"}, description="Configuration prefix")
        public String configPrefix = "graph";

        protected Opts() {
        }

        public void setAccumuloConfigs(Job job) throws AccumuloSecurityException {
            AccumuloInputFormat.setConnectorInfo((Job)job, (String)this.getPrincipal(), (AuthenticationToken)this.getToken());
            AccumuloOutputFormat.setConnectorInfo((Job)job, (String)this.getPrincipal(), (AuthenticationToken)this.getToken());
            AccumuloInputFormat.setInputTableName((Job)job, (String)this.getTableName());
            AccumuloInputFormat.setScanAuthorizations((Job)job, (Authorizations)this.auths);
            AccumuloOutputFormat.setCreateTables((Job)job, (boolean)true);
            AccumuloOutputFormat.setDefaultTableName((Job)job, (String)this.getTableName());
            job.getConfiguration().set("MRMigrationBase.config.prefix", this.configPrefix);
            job.getConfiguration().set("MRMigrationBase.output.tableName", this.getTableName());
        }

        protected abstract String getTableName();
    }
}

