/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium;

import java.io.Serializable;

public class Range
implements Serializable {
    private static final long serialVersionUID = -4491252292678133754L;
    private final String inclusiveStart;
    private final String exclusiveEnd;

    public Range(String inclusiveStart, String exclusiveEnd) {
        this.inclusiveStart = inclusiveStart;
        this.exclusiveEnd = exclusiveEnd;
    }

    public String getInclusiveStart() {
        return this.inclusiveStart;
    }

    public String getExclusiveEnd() {
        return this.exclusiveEnd;
    }

    public boolean isInRange(String str) {
        if (this.getInclusiveStart() != null && this.getInclusiveStart().compareTo(str) > 0) {
            return false;
        }
        return this.getExclusiveEnd() == null || str.compareTo(this.getExclusiveEnd()) < 0;
    }

    public String toString() {
        return "Range{inclusiveStart='" + this.getInclusiveStart() + '\'' + ", exclusiveEnd='" + this.getExclusiveEnd() + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        if (this.inclusiveStart != null ? !this.inclusiveStart.equals(range.inclusiveStart) : range.inclusiveStart != null) {
            return false;
        }
        return !(this.exclusiveEnd != null ? !this.exclusiveEnd.equals(range.exclusiveEnd) : range.exclusiveEnd != null);
    }

    public int hashCode() {
        int result = this.inclusiveStart != null ? this.inclusiveStart.hashCode() : 0;
        result = 31 * result + (this.exclusiveEnd != null ? this.exclusiveEnd.hashCode() : 0);
        return result;
    }
}

